/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.tutorial;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sphere;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.pick.PickSupport;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.OrderedRenderable;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.util.OGLUtil;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import java.awt.Color;
import java.awt.Point;
import javax.media.opengl.GL2;

public class Cube
extends ApplicationTemplate
implements OrderedRenderable {
    protected Position position;
    protected double size;
    protected PickSupport pickSupport = new PickSupport();
    protected long frameTimestamp = -1L;
    protected Vec4 placePoint;
    protected double eyeDistance;
    protected Extent extent;

    public Cube(Position position, double d) {
        this.position = position;
        this.size = d;
    }

    public void render(DrawContext drawContext) {
        if (this.extent != null) {
            if (!this.intersectsFrustum(drawContext)) {
                return;
            }
            if (drawContext.isSmall(this.extent, 1)) {
                return;
            }
        }
        if (drawContext.isOrderedRenderingMode()) {
            this.drawOrderedRenderable(drawContext, this.pickSupport);
        } else {
            this.makeOrderedRenderable(drawContext);
        }
    }

    protected boolean intersectsFrustum(DrawContext drawContext) {
        if (this.extent == null) {
            return true;
        }
        if (drawContext.isPickingMode()) {
            return drawContext.getPickFrustums().intersectsAny(this.extent);
        }
        return drawContext.getView().getFrustumInModelCoordinates().intersects(this.extent);
    }

    public double getDistanceFromEye() {
        return this.eyeDistance;
    }

    public void pick(DrawContext drawContext, Point point) {
        this.render(drawContext);
    }

    protected void beginDrawing(DrawContext drawContext) {
        GL2 gL2 = drawContext.getGL().getGL2();
        int n = 16385;
        gL2.glPushAttrib(n);
        if (!drawContext.isPickingMode()) {
            drawContext.beginStandardLighting();
            gL2.glEnable(3042);
            OGLUtil.applyBlending((GL2)gL2, (boolean)false);
            gL2.glEnable(2977);
        }
        gL2.glMatrixMode(5888);
        Matrix matrix = drawContext.getGlobe().computeSurfaceOrientationAtPosition(this.position);
        matrix = drawContext.getView().getModelviewMatrix().multiply(matrix);
        double[] dArray = new double[16];
        matrix.toArray(dArray, 0, false);
        gL2.glLoadMatrixd(dArray, 0);
    }

    protected void endDrawing(DrawContext drawContext) {
        GL2 gL2 = drawContext.getGL().getGL2();
        if (!drawContext.isPickingMode()) {
            drawContext.endStandardLighting();
        }
        gL2.glPopAttrib();
    }

    protected void makeOrderedRenderable(DrawContext drawContext) {
        if (drawContext.getFrameTimeStamp() != this.frameTimestamp) {
            this.placePoint = drawContext.getGlobe().computePointFromPosition(this.position);
            this.eyeDistance = drawContext.getView().getEyePoint().distanceTo3(this.placePoint);
            this.extent = new Sphere(this.placePoint, Math.sqrt(3.0) * this.size / 2.0);
            this.frameTimestamp = drawContext.getFrameTimeStamp();
        }
        drawContext.addOrderedRenderable((OrderedRenderable)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawOrderedRenderable(DrawContext drawContext, PickSupport pickSupport) {
        this.beginDrawing(drawContext);
        try {
            GL2 gL2 = drawContext.getGL().getGL2();
            if (drawContext.isPickingMode()) {
                Color color = drawContext.getUniquePickColor();
                pickSupport.addPickableObject(color.getRGB(), (Object)this, this.position);
                gL2.glColor3ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue());
            }
            gL2.glScaled(this.size, this.size, this.size);
            this.drawUnitCube(drawContext);
        }
        finally {
            this.endDrawing(drawContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawUnitCube(DrawContext drawContext) {
        float[][] fArrayArray = new float[][]{{-0.5f, 0.5f, -0.5f}, {-0.5f, 0.5f, 0.5f}, {0.5f, 0.5f, 0.5f}, {0.5f, 0.5f, -0.5f}, {-0.5f, -0.5f, 0.5f}, {0.5f, -0.5f, 0.5f}, {0.5f, -0.5f, -0.5f}, {-0.5f, -0.5f, -0.5f}};
        int[][] nArrayArray = new int[][]{{0, 1, 2, 3}, {2, 5, 6, 3}, {1, 4, 5, 2}, {0, 7, 4, 1}, {0, 7, 6, 3}, {4, 7, 6, 5}};
        float[][] fArrayArray2 = new float[][]{{0.0f, 1.0f, 0.0f}, {1.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 1.0f}, {-1.0f, 0.0f, 0.0f}, {0.0f, 0.0f, -1.0f}, {0.0f, -1.0f, 0.0f}};
        GL2 gL2 = drawContext.getGL().getGL2();
        gL2.glBegin(7);
        try {
            for (int i = 0; i < nArrayArray.length; ++i) {
                gL2.glNormal3f(fArrayArray2[i][0], fArrayArray2[i][1], fArrayArray2[i][2]);
                for (int j = 0; j < nArrayArray[0].length; ++j) {
                    gL2.glVertex3f(fArrayArray[nArrayArray[i][j]][0], fArrayArray[nArrayArray[i][j]][1], fArrayArray[nArrayArray[i][j]][2]);
                }
            }
        }
        finally {
            gL2.glEnd();
        }
    }

    public static void main(String[] stringArray) {
        Configuration.setValue((String)"gov.nasa.worldwind.avkey.InitialLatitude", (Object)35.0);
        Configuration.setValue((String)"gov.nasa.worldwind.avkey.InitialLongitude", (Object)-120.0);
        Configuration.setValue((String)"gov.nasa.worldwind.avkey.InitialAltitude", (Object)15500);
        Configuration.setValue((String)"gov.nasa.worldwind.avkey.InitialPitch", (Object)45);
        Configuration.setValue((String)"gov.nasa.worldwind.avkey.InitialHeading", (Object)45);
        ApplicationTemplate.start("World Wind Custom Renderable Tutorial", AppFrame.class);
    }

    protected static class AppFrame
    extends ApplicationTemplate.AppFrame {
        public AppFrame() {
            super(true, false, false);
            RenderableLayer renderableLayer = new RenderableLayer();
            Cube cube = new Cube(Position.fromDegrees((double)35.0, (double)-120.0, (double)3000.0), 1000.0);
            renderableLayer.addRenderable((Renderable)cube);
            this.getWwd().getModel().getLayers().add((Layer)renderableLayer);
        }
    }
}

