/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.util;

import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.render.Annotation;
import gov.nasa.worldwind.render.AnnotationAttributes;
import gov.nasa.worldwind.render.AnnotationFlowLayout;
import gov.nasa.worldwind.render.AnnotationLayoutManager;
import gov.nasa.worldwind.render.ScreenAnnotation;
import gov.nasa.worldwindx.examples.util.ButtonAnnotation;
import gov.nasa.worldwindx.examples.util.DialogAnnotation;
import gov.nasa.worldwindx.examples.util.ProgressAnnotation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;

public class AudioPlayerAnnotation
extends DialogAnnotation {
    protected static final String PLAY_IMAGE_PATH = "gov/nasa/worldwindx/examples/images/16x16-button-play.png";
    protected static final String PAUSE_IMAGE_PATH = "gov/nasa/worldwindx/examples/images/16x16-button-pause.png";
    protected static final String BACK_IMAGE_PATH = "gov/nasa/worldwindx/examples/images/16x16-button-start.png";
    protected static final String PLAY_TOOLTIP_TEXT = "Play audio clip";
    protected static final String PAUSE_TOOLTIP_TEXT = "Pause audio clip";
    protected static final String BACK_TOOLTIP_TEXT = "Stop and reset audio clip";
    protected long position;
    protected long length;
    protected Annotation titleLabel;
    protected ButtonAnnotation playButton;
    protected ButtonAnnotation backButton;
    protected Annotation positionLabel;
    protected Annotation lengthLabel;
    protected ProgressAnnotation progress;

    public AudioPlayerAnnotation(Position position) {
        super(position);
        this.setClipPosition(0L);
        this.setClipLength(0L);
    }

    public long getClipPosition() {
        return this.position;
    }

    public void setClipPosition(long l) {
        this.position = l;
        String string = this.formatTimeString(l);
        this.getClipPositionLabel().setText(string);
        this.getClipProgressBar().setValue(l);
    }

    public long getClipLength() {
        return this.length;
    }

    public void setClipLength(long l) {
        this.length = l;
        String string = this.formatTimeString(l);
        this.getClipLengthLabel().setText(string);
        this.getClipProgressBar().setMax(0.0);
        this.getClipProgressBar().setMax(l);
    }

    public Annotation getTitleLabel() {
        return this.titleLabel;
    }

    public ButtonAnnotation getPlayButton() {
        return this.playButton;
    }

    public ButtonAnnotation getBackButton() {
        return this.backButton;
    }

    public Annotation getClipPositionLabel() {
        return this.positionLabel;
    }

    public Annotation getClipLengthLabel() {
        return this.lengthLabel;
    }

    public ProgressAnnotation getClipProgressBar() {
        return this.progress;
    }

    public void setPlayButtonState(String string) {
        if (string == "gov.nasa.worldwind.avkey.Play") {
            this.playButton.setImageSource(PLAY_IMAGE_PATH);
            this.playButton.setToolTipText(PLAY_TOOLTIP_TEXT);
        } else if (string == "gov.nasa.worldwind.avkey.Pause") {
            this.playButton.setImageSource(PAUSE_IMAGE_PATH);
            this.playButton.setToolTipText(PAUSE_TOOLTIP_TEXT);
        }
    }

    @Override
    protected void initComponents() {
        super.initComponents();
        this.titleLabel = new ScreenAnnotation("", new Point());
        this.playButton = new ButtonAnnotation(PLAY_IMAGE_PATH, "gov/nasa/worldwindx/examples/images/16x16-button-depressed-mask.png");
        this.backButton = new ButtonAnnotation(BACK_IMAGE_PATH, "gov/nasa/worldwindx/examples/images/16x16-button-depressed-mask.png");
        this.positionLabel = new ScreenAnnotation("", new Point());
        this.lengthLabel = new ScreenAnnotation("", new Point());
        this.progress = new ProgressAnnotation();
        this.setupTitle(this.titleLabel);
        this.setupTimeLabel(this.positionLabel);
        this.setupTimeLabel(this.lengthLabel);
        this.setupProgressBar(this.progress);
        this.playButton.setActionCommand("gov.nasa.worldwind.avkey.Play");
        this.backButton.setActionCommand("gov.nasa.worldwind.avkey.Stop");
        this.playButton.addActionListener(this);
        this.backButton.addActionListener(this);
        this.playButton.setToolTipText(PLAY_TOOLTIP_TEXT);
        this.backButton.setToolTipText(BACK_TOOLTIP_TEXT);
    }

    @Override
    protected void layoutComponents() {
        super.layoutComponents();
        ScreenAnnotation screenAnnotation = new ScreenAnnotation("", new Point());
        this.setupContainer((Annotation)screenAnnotation);
        screenAnnotation.setLayout((AnnotationLayoutManager)new AnnotationFlowLayout("gov.nasa.worldwind.avkey.Horizontal", "gov.nasa.worldwind.avkey.Center", 4, 0));
        screenAnnotation.addChild((Annotation)this.playButton);
        screenAnnotation.addChild((Annotation)this.backButton);
        screenAnnotation.addChild(this.positionLabel);
        screenAnnotation.addChild((Annotation)this.progress);
        screenAnnotation.addChild(this.lengthLabel);
        Insets insets = this.positionLabel.getAttributes().getInsets();
        this.positionLabel.getAttributes().setInsets(new Insets(insets.top, insets.left + 4, insets.bottom, insets.right));
        insets = new ScreenAnnotation("", new Point());
        this.setupContainer((Annotation)insets);
        insets.setLayout((AnnotationLayoutManager)new AnnotationFlowLayout("gov.nasa.worldwind.avkey.Vertical", "gov.nasa.worldwind.avkey.Center", 0, 16));
        insets.addChild(this.titleLabel);
        insets.addChild((Annotation)screenAnnotation);
        this.addChild((Annotation)insets);
    }

    protected void setupTitle(Annotation annotation) {
        this.setupLabel(annotation);
        AnnotationAttributes annotationAttributes = annotation.getAttributes();
        annotationAttributes.setFont(Font.decode("Arial-BOLD-14"));
        annotationAttributes.setSize(new Dimension(260, 0));
        annotationAttributes.setTextAlign("gov.nasa.worldwind.avkey.Center");
    }

    protected void setupTimeLabel(Annotation annotation) {
        this.setupLabel(annotation);
        AnnotationAttributes annotationAttributes = annotation.getAttributes();
        annotationAttributes.setFont(Font.decode("CourierNew-PLAIN-12"));
        annotationAttributes.setSize(new Dimension(80, 0));
    }

    protected void setupProgressBar(ProgressAnnotation progressAnnotation) {
        AnnotationAttributes annotationAttributes = new AnnotationAttributes();
        this.setupDefaultAttributes(annotationAttributes);
        annotationAttributes.setSize(new Dimension(160, 10));
        progressAnnotation.getAttributes().setDefaults(annotationAttributes);
    }

    protected String formatTimeString(long l) {
        return this.formatAsMinutesSeconds(l);
    }

    protected String formatAsMinutesSeconds(long l) {
        long l2 = l / 1000L / 60L;
        long l3 = l / 1000L;
        long l4 = l3 - l2 * 60L;
        return String.format("%02d:%02d", l2, l4);
    }
}

