/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.util;

import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.pick.PickedObject;
import gov.nasa.worldwind.pick.PickedObjectList;
import gov.nasa.worldwind.render.Balloon;
import gov.nasa.worldwind.render.BalloonAttributes;
import gov.nasa.worldwind.render.BasicBalloonAttributes;
import gov.nasa.worldwind.render.Size;
import gov.nasa.worldwind.util.AbstractResizeHotSpot;
import gov.nasa.worldwind.util.Logging;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;

public class BalloonResizeController
extends AbstractResizeHotSpot {
    protected WorldWindow wwd;
    protected Rectangle bounds;
    protected Balloon balloon;
    protected static final Dimension DEFAULT_MIN_SIZE = new Dimension(50, 50);

    public BalloonResizeController(WorldWindow worldWindow, Balloon balloon) {
        if (worldWindow == null) {
            String string = Logging.getMessage((String)"nullValue.WorldWindow");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (balloon == null) {
            String string = Logging.getMessage((String)"nullValue.BalloonIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.wwd = worldWindow;
        this.balloon = balloon;
        this.wwd.addSelectListener((SelectListener)this);
        this.wwd.getInputHandler().addMouseMotionListener((MouseMotionListener)((Object)this));
    }

    public void detach() {
        this.wwd.removeSelectListener((SelectListener)this);
        this.wwd.getInputHandler().removeMouseMotionListener((MouseMotionListener)((Object)this));
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        Rectangle rectangle;
        if (mouseEvent == null || mouseEvent.isConsumed()) {
            return;
        }
        PickedObjectList pickedObjectList = this.wwd.getObjectsAtCurrentPosition();
        if (pickedObjectList != null && (rectangle = this.getBounds(pickedObjectList.getTopPickedObject())) != null) {
            this.setBounds(rectangle);
        }
        super.mouseMoved(mouseEvent);
        this.updateCursor();
    }

    public boolean isResizing() {
        return this.isDragging();
    }

    protected Dimension getSize() {
        Rectangle rectangle = this.getBounds();
        if (rectangle != null) {
            return rectangle.getSize();
        }
        return null;
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public void setBounds(Rectangle rectangle) {
        this.bounds = rectangle;
    }

    protected void updateCursor() {
        if (this.wwd instanceof Component) {
            ((Component)this.wwd).setCursor(this.getCursor());
        }
    }

    protected void setSize(Dimension dimension) {
        Size size = Size.fromPixels((int)dimension.width, (int)dimension.height);
        BalloonAttributes balloonAttributes = this.balloon.getAttributes();
        if (balloonAttributes == null) {
            balloonAttributes = new BasicBalloonAttributes();
            this.balloon.setAttributes(balloonAttributes);
        }
        balloonAttributes.setSize(size);
        balloonAttributes.setMaximumSize(null);
        BalloonAttributes balloonAttributes2 = this.balloon.getHighlightAttributes();
        if (balloonAttributes2 != null) {
            balloonAttributes2.setSize(size);
            balloonAttributes2.setMaximumSize(null);
        }
    }

    protected Rectangle getBounds(PickedObject pickedObject) {
        Object object;
        if (pickedObject != null && (object = pickedObject.getValue("gov.nasa.worldwind.avkey.Bounds")) instanceof Rectangle) {
            return (Rectangle)object;
        }
        return null;
    }

    protected Point getScreenPoint() {
        Rectangle rectangle = this.getBounds();
        if (rectangle != null) {
            return rectangle.getLocation();
        }
        return null;
    }

    protected void setScreenPoint(Point point) {
    }

    protected Dimension getMinimumSize() {
        return DEFAULT_MIN_SIZE;
    }
}

