/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.util;

import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Box;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwind.util.WWUtil;
import java.io.File;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class ExampleUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File unzipAndSaveToTempFile(String string, String string2) {
        if (WWUtil.isEmpty((Object)string)) {
            String string3 = Logging.getMessage((String)"nullValue.PathIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        InputStream inputStream = null;
        try {
            inputStream = WWIO.openStream((Object)string);
            ByteBuffer byteBuffer = WWIO.readStreamToBuffer((InputStream)inputStream);
            File file = WWIO.saveBufferToTempFile((ByteBuffer)byteBuffer, (String)WWIO.getFilename((String)string));
            byteBuffer = WWIO.readZipEntryToBuffer((File)file, null);
            File file2 = WWIO.saveBufferToTempFile((ByteBuffer)byteBuffer, (String)string2);
            return file2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            WWIO.closeStream((Object)inputStream, (String)string);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File saveResourceToTempFile(String string, String string2) {
        if (WWUtil.isEmpty((Object)string)) {
            String string3 = Logging.getMessage((String)"nullValue.PathIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        InputStream inputStream = null;
        try {
            inputStream = WWIO.openStream((Object)string);
            ByteBuffer byteBuffer = WWIO.readStreamToBuffer((InputStream)inputStream);
            File file = WWIO.saveBufferToTempFile((ByteBuffer)byteBuffer, (String)string2);
            return file;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            WWIO.closeStream((Object)inputStream, (String)string);
        }
        return null;
    }

    public static void goTo(WorldWindow worldWindow, Sector sector) {
        if (worldWindow == null) {
            String string = Logging.getMessage((String)"nullValue.WorldWindow");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (sector == null) {
            String string = Logging.getMessage((String)"nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Box box = Sector.computeBoundingBox((Globe)worldWindow.getModel().getGlobe(), (double)worldWindow.getSceneController().getVerticalExaggeration(), (Sector)sector);
        Angle angle = worldWindow.getView().getFieldOfView();
        double d = box.getRadius() / angle.cosHalfAngle() / angle.tanHalfAngle();
        worldWindow.getView().goTo(new Position(sector.getCentroid(), 0.0), d);
    }
}

