/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.util;

import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.pick.PickedObject;
import gov.nasa.worldwind.pick.PickedObjectList;
import gov.nasa.worldwind.util.HotSpot;
import gov.nasa.worldwind.util.Logging;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;

public class HotSpotController
implements SelectListener,
MouseMotionListener {
    protected WorldWindow wwd;
    protected HotSpot activeHotSpot;
    protected boolean dragging = false;
    protected boolean customCursor;

    public HotSpotController(WorldWindow worldWindow) {
        if (worldWindow == null) {
            String string = Logging.getMessage((String)"nullValue.WorldWindow");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.wwd = worldWindow;
        this.wwd.addSelectListener((SelectListener)this);
        this.wwd.getInputHandler().addMouseMotionListener((MouseMotionListener)this);
    }

    public void selected(SelectEvent selectEvent) {
        if (selectEvent == null) {
            return;
        }
        try {
            this.doSelected(selectEvent);
        }
        catch (Exception exception) {
            Logging.logger().warning(exception.getMessage() != null ? exception.getMessage() : exception.toString());
        }
    }

    protected void doSelected(SelectEvent selectEvent) {
        PickedObjectList pickedObjectList;
        HotSpot hotSpot = this.getActiveHotSpot();
        if (selectEvent.isDragEnd()) {
            if (hotSpot != null) {
                hotSpot.selected(selectEvent);
            }
            this.setDragging(false);
            pickedObjectList = this.wwd.getObjectsAtCurrentPosition();
            PickedObject pickedObject = pickedObjectList != null ? pickedObjectList.getTopPickedObject() : null;
            this.updateActiveHotSpot(pickedObject);
        } else if (!this.isDragging() && (selectEvent.isRollover() || selectEvent.isLeftPress())) {
            pickedObjectList = selectEvent.getTopPickedObject();
            this.updateActiveHotSpot((PickedObject)pickedObjectList);
        }
        if (hotSpot != null) {
            if (selectEvent.isDrag()) {
                boolean bl = selectEvent.isConsumed();
                hotSpot.selected(selectEvent);
                this.setDragging(selectEvent.isConsumed() && !bl);
            } else if (!selectEvent.isDragEnd()) {
                hotSpot.selected(selectEvent);
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        Cursor cursor;
        HotSpot hotSpot = this.getActiveHotSpot();
        if (hotSpot != null && (cursor = hotSpot.getCursor()) != null) {
            ((Component)this.wwd).setCursor(cursor);
            this.customCursor = true;
        }
    }

    protected boolean isDragging() {
        return this.dragging;
    }

    protected void setDragging(boolean bl) {
        this.dragging = bl;
    }

    protected HotSpot getActiveHotSpot() {
        return this.activeHotSpot;
    }

    protected void setActiveHotSpot(HotSpot hotSpot) {
        if (this.wwd instanceof Component) {
            Cursor cursor;
            if (this.activeHotSpot != hotSpot && this.customCursor) {
                ((Component)this.wwd).setCursor(null);
                this.customCursor = false;
            }
            if (hotSpot != null && (cursor = hotSpot.getCursor()) != null) {
                ((Component)this.wwd).setCursor(cursor);
                this.customCursor = true;
            }
        }
        if (this.activeHotSpot == hotSpot) {
            return;
        }
        if (this.activeHotSpot != null) {
            this.wwd.getInputHandler().removeKeyListener((KeyListener)this.activeHotSpot);
            this.wwd.getInputHandler().removeMouseListener((MouseListener)this.activeHotSpot);
            this.wwd.getInputHandler().removeMouseMotionListener((MouseMotionListener)this.activeHotSpot);
            this.wwd.getInputHandler().removeMouseWheelListener((MouseWheelListener)this.activeHotSpot);
            this.activeHotSpot.setActive(false);
        }
        this.activeHotSpot = hotSpot;
        if (this.activeHotSpot != null) {
            this.activeHotSpot.setActive(true);
            this.wwd.getInputHandler().addKeyListener((KeyListener)this.activeHotSpot);
            this.wwd.getInputHandler().addMouseListener((MouseListener)this.activeHotSpot);
            this.wwd.getInputHandler().addMouseMotionListener((MouseMotionListener)this.activeHotSpot);
            this.wwd.getInputHandler().addMouseWheelListener((MouseWheelListener)this.activeHotSpot);
        }
    }

    protected void updateActiveHotSpot(PickedObject pickedObject) {
        if (pickedObject != null && pickedObject.getValue("gov.nasa.worldwind.avkey.HotSpot") instanceof HotSpot) {
            this.setActiveHotSpot((HotSpot)pickedObject.getValue("gov.nasa.worldwind.avkey.HotSpot"));
        } else if (pickedObject != null && pickedObject.getObject() instanceof HotSpot) {
            this.setActiveHotSpot((HotSpot)pickedObject.getObject());
        } else {
            this.setActiveHotSpot(null);
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }
}

