/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.util;

import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.render.Annotation;
import gov.nasa.worldwind.render.AnnotationAttributes;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.OrderedRenderable;
import gov.nasa.worldwind.render.ScreenAnnotation;
import gov.nasa.worldwind.render.WWTexture;
import gov.nasa.worldwindx.examples.util.ToolTip;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import javax.media.opengl.GL;
import javax.media.opengl.GL2;

public class ImageAnnotation
extends ScreenAnnotation {
    protected int imageWidth;
    protected int imageHeight;
    protected boolean fitSizeToImage = true;
    protected boolean useImageAspectRatio = true;
    protected boolean enableSmoothing = true;
    protected boolean useMipmaps = true;
    protected boolean showToolTip;
    protected String toolTipText;
    protected Point toolTipPoint;

    public ImageAnnotation(Object object, int n, int n2) {
        super("", new Point());
        this.setImageSource(object, n, n2);
        this.setupAnnotationAttributes((Annotation)this);
    }

    public ImageAnnotation(Object object) {
        this(object, 0, 0);
    }

    public ImageAnnotation() {
        this(null, 0, 0);
    }

    public boolean isFitSizeToImage() {
        return this.fitSizeToImage;
    }

    public void setFitSizeToImage(boolean bl) {
        this.fitSizeToImage = bl;
    }

    public boolean isUseImageAspectRatio() {
        return this.useImageAspectRatio;
    }

    public void setUseImageAspectRatio(boolean bl) {
        this.useImageAspectRatio = bl;
    }

    public boolean isEnableSmoothing() {
        return this.enableSmoothing;
    }

    public void setEnableSmoothing(boolean bl) {
        this.enableSmoothing = bl;
    }

    public boolean isUseMipmaps() {
        return this.useMipmaps;
    }

    public void setUseMipmaps(boolean bl) {
        this.useMipmaps = bl;
    }

    public Object getImageSource() {
        return this.getAttributes().getImageSource();
    }

    public void setImageSource(Object object, int n, int n2) {
        this.getAttributes().setImageSource(object);
        this.imageWidth = n;
        this.imageHeight = n2;
    }

    public void setImageSource(Object object) {
        this.setImageSource(object, 0, 0);
    }

    public Dimension getImageDimension() {
        return new Dimension(this.imageWidth, this.imageHeight);
    }

    public WWTexture getTexture(DrawContext drawContext) {
        return this.getAttributes().getBackgroundTexture(drawContext);
    }

    public boolean isShowToolTip() {
        return this.showToolTip;
    }

    public void setShowToolTip(boolean bl) {
        this.showToolTip = bl;
    }

    public String getToolTipText() {
        return this.toolTipText;
    }

    public void setToolTipText(String string) {
        this.toolTipText = string;
    }

    public Point getToolTipPoint() {
        return this.toolTipPoint;
    }

    public void setToolTipPoint(Point point) {
        this.toolTipPoint = point;
    }

    public Dimension getPreferredSize(DrawContext drawContext) {
        Dimension dimension = this.getImageSize(drawContext);
        Dimension dimension2 = null;
        if (this.isFitSizeToImage()) {
            dimension2 = dimension;
        }
        if (dimension2 == null) {
            dimension2 = super.getPreferredSize(drawContext);
            if (this.isUseImageAspectRatio() && dimension != null) {
                double d = dimension.getHeight() / dimension.getWidth();
                dimension2 = new Dimension(dimension2.width, (int)Math.round(d * (double)dimension2.width));
            }
        }
        Insets insets = this.getAttributes().getInsets();
        return new Dimension(dimension2.width + (insets.left + insets.right), dimension2.height + (insets.top + insets.bottom));
    }

    protected Dimension getImageSize(DrawContext drawContext) {
        WWTexture wWTexture = this.getTexture(drawContext);
        if (wWTexture != null && this.imageWidth == 0 && this.imageHeight == 0) {
            return new Dimension(wWTexture.getWidth(drawContext), wWTexture.getHeight(drawContext));
        }
        if (this.imageWidth != 0 && this.imageHeight != 0) {
            return new Dimension(this.imageWidth, this.imageHeight);
        }
        return null;
    }

    public void drawContent(DrawContext drawContext, int n, int n2, double d, Position position) {
        super.drawContent(drawContext, n, n2, d, position);
        this.drawToolTip(drawContext);
    }

    protected void drawToolTip(DrawContext drawContext) {
        if (drawContext.isPickingMode()) {
            return;
        }
        if (!this.isShowToolTip()) {
            return;
        }
        String string = this.getToolTipText();
        if (string == null) {
            return;
        }
        Point point = this.getToolTipPoint();
        if (point == null) {
            return;
        }
        this.doDrawToolTip(drawContext, string, point.x, point.y);
    }

    protected void doDrawToolTip(DrawContext drawContext, String string, int n, int n2) {
        ToolTip toolTip = new ToolTip(string, n, n2);
        drawContext.addOrderedRenderable((OrderedRenderable)toolTip);
    }

    protected void applyBackgroundTextureState(DrawContext drawContext, int n, int n2, double d, WWTexture wWTexture) {
        super.applyBackgroundTextureState(drawContext, n, n2, d, wWTexture);
        int n3 = this.isEnableSmoothing() ? (this.isUseMipmaps() ? 9987 : 9729) : 9728;
        int n4 = this.isEnableSmoothing() ? 9729 : 9728;
        GL gL = drawContext.getGL();
        gL.glTexParameteri(3553, 10241, n3);
        gL.glTexParameteri(3553, 10240, n4);
    }

    protected void transformBackgroundImageCoordsToAnnotationCoords(DrawContext drawContext, int n, int n2, WWTexture wWTexture) {
        GL2 gL2 = drawContext.getGL().getGL2();
        Dimension dimension = this.getImageSize(drawContext);
        if (dimension != null) {
            gL2.glScaled(dimension.getWidth() / (double)n, dimension.getHeight() / (double)n2, 1.0);
        }
        super.transformBackgroundImageCoordsToAnnotationCoords(drawContext, n, n2, wWTexture);
    }

    protected void setupAnnotationAttributes(Annotation annotation) {
        Color color = new Color(0, 0, 0, 0);
        AnnotationAttributes annotationAttributes = new AnnotationAttributes();
        annotationAttributes.setAdjustWidthToText("gov.nasa.worldwind.avkey.SizeFixed");
        annotationAttributes.setBackgroundColor(color);
        annotationAttributes.setBorderColor(color);
        annotationAttributes.setBorderWidth(0.0);
        annotationAttributes.setCornerRadius(0);
        annotationAttributes.setDrawOffset(new Point(0, 0));
        annotationAttributes.setHighlightScale(1.0);
        annotationAttributes.setInsets(new Insets(0, 0, 0, 0));
        annotationAttributes.setImageScale(1.0);
        annotationAttributes.setImageOffset(new Point(0, 0));
        annotationAttributes.setImageOpacity(1.0);
        annotationAttributes.setImageRepeat("gov.nasa.worldwind.avkey.RepeatNone");
        annotationAttributes.setLeader("gov.nasa.worldwind.avkey.ShapeNone");
        annotationAttributes.setSize(new Dimension(0, 0));
        annotation.setPickEnabled(false);
        annotation.getAttributes().setDefaults(annotationAttributes);
    }
}

