/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.util;

import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.ScreenAnnotation;
import gov.nasa.worldwind.util.Logging;
import java.awt.Point;
import java.awt.Rectangle;

public class LabeledPath
implements Renderable {
    protected Iterable<? extends LatLon> locations;
    protected int altitudeMode = 0;
    protected ScreenAnnotation annotation;
    protected long frameNumber = -1L;
    protected int labelLocationIndex = -1;

    public LabeledPath() {
    }

    public LabeledPath(Iterable<? extends LatLon> iterable) {
        this.setLocations(iterable);
    }

    public LabeledPath(ScreenAnnotation screenAnnotation) {
        this.setAnnotation(screenAnnotation);
    }

    public LabeledPath(Iterable<? extends LatLon> iterable, ScreenAnnotation screenAnnotation) {
        this.setLocations(iterable);
        this.setAnnotation(screenAnnotation);
    }

    public Iterable<? extends LatLon> getLocations() {
        return this.locations;
    }

    public void setLocations(Iterable<? extends LatLon> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage((String)"nullValue.LocationsListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.locations = iterable;
        this.reset();
    }

    public int getAltitudeMode() {
        return this.altitudeMode;
    }

    public void setAltitudeMode(int n) {
        this.altitudeMode = n;
        this.reset();
    }

    public ScreenAnnotation getAnnotation() {
        return this.annotation;
    }

    public void setAnnotation(ScreenAnnotation screenAnnotation) {
        this.annotation = screenAnnotation;
        this.reset();
    }

    public void render(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage((String)"nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.frameNumber != drawContext.getFrameTimeStamp()) {
            this.determineLabelLocation(drawContext);
            this.frameNumber = drawContext.getFrameTimeStamp();
        }
        this.drawLabel(drawContext);
    }

    protected void reset() {
        this.labelLocationIndex = -1;
    }

    protected void determineLabelLocation(DrawContext drawContext) {
        Vec4 vec4 = this.getLabelPoint(drawContext);
        if (vec4 != null && drawContext.getView().getFrustumInModelCoordinates().contains(vec4)) {
            Vec4 vec42 = drawContext.getView().project(vec4);
            this.setLabelLocation(drawContext, vec42);
            if (this.isLabelCompletelyVisible(drawContext)) {
                return;
            }
        }
        this.labelLocationIndex = -1;
        if (this.getLocations() == null) {
            return;
        }
        double d = 0.0;
        double d2 = Double.MAX_VALUE;
        int n = -1;
        for (LatLon latLon : this.getLocations()) {
            double d3;
            Vec4 vec43;
            ++n;
            if (latLon == null || (vec43 = this.computePoint(drawContext, latLon)) == null || !drawContext.getView().getFrustumInModelCoordinates().contains(vec43)) continue;
            Vec4 vec44 = drawContext.getView().project(vec43);
            this.setLabelLocation(drawContext, vec44);
            double d4 = this.getLabelVisibleArea(drawContext);
            if (d < d4) {
                d = d4;
                this.labelLocationIndex = n;
                if (vec4 == null) continue;
                d2 = vec4.distanceToSquared3(vec43);
                continue;
            }
            if (d != d4 || vec4 == null || !(d2 > (d3 = vec4.distanceToSquared3(vec43)))) continue;
            d2 = d3;
            this.labelLocationIndex = n;
        }
    }

    protected void drawLabel(DrawContext drawContext) {
        if (this.getAnnotation() == null) {
            return;
        }
        Vec4 vec4 = this.getLabelPoint(drawContext);
        if (vec4 == null) {
            return;
        }
        Vec4 vec42 = drawContext.getView().project(vec4);
        this.setLabelLocation(drawContext, vec42);
        this.getAnnotation().render(drawContext);
    }

    protected void setLabelLocation(DrawContext drawContext, Vec4 vec4) {
        if (this.getAnnotation() != null) {
            this.getAnnotation().setScreenPoint(new Point((int)vec4.x, (int)vec4.y));
        }
    }

    protected double getLabelVisibleArea(DrawContext drawContext) {
        if (this.getAnnotation() == null) {
            return 0.0;
        }
        Rectangle rectangle = this.getAnnotation().getBounds(drawContext);
        if (rectangle == null) {
            return 0.0;
        }
        Rectangle rectangle2 = drawContext.getView().getViewport().intersection(rectangle);
        return rectangle2.width * rectangle2.height;
    }

    protected boolean isLabelCompletelyVisible(DrawContext drawContext) {
        if (this.getAnnotation() == null) {
            return false;
        }
        Rectangle rectangle = this.getAnnotation().getBounds(drawContext);
        return rectangle == null || drawContext.getView().getViewport().contains(rectangle);
    }

    protected Vec4 getLabelPoint(DrawContext drawContext) {
        if (this.getLocations() == null) {
            return null;
        }
        if (this.labelLocationIndex == -1) {
            return null;
        }
        int n = 0;
        LatLon latLon = null;
        for (LatLon latLon2 : this.getLocations()) {
            if (n++ != this.labelLocationIndex) continue;
            latLon = latLon2;
        }
        if (latLon == null) {
            return null;
        }
        return this.computePoint(drawContext, latLon);
    }

    protected Vec4 computePoint(DrawContext drawContext, LatLon latLon) {
        double d;
        double d2 = d = latLon instanceof Position ? ((Position)latLon).getElevation() : 0.0;
        if (this.getAltitudeMode() == 1) {
            return drawContext.computeTerrainPoint(latLon.getLatitude(), latLon.getLongitude(), 0.0);
        }
        if (this.getAltitudeMode() == 2) {
            return drawContext.computeTerrainPoint(latLon.getLatitude(), latLon.getLongitude(), d);
        }
        double d3 = d * drawContext.getVerticalExaggeration();
        return drawContext.getGlobe().computePointFromPosition(latLon.getLatitude(), latLon.getLongitude(), d3);
    }
}

