/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.util;

import gov.nasa.worldwind.formats.shapefile.Shapefile;
import gov.nasa.worldwind.formats.shapefile.ShapefileRecordPoint;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.GeographicText;
import gov.nasa.worldwind.render.GeographicTextRenderer;
import gov.nasa.worldwind.render.PatternFactory;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.SurfaceIcons;
import gov.nasa.worldwind.render.UserFacingText;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwind.util.WWUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.image.BufferedImage;
import java.util.ArrayList;

public class OpenStreetMapShapefileLoader {
    public static boolean isOSMPlacesSource(Object object) {
        if (object == null || WWUtil.isEmpty((Object)object)) {
            String string = Logging.getMessage((String)"nullValue.SourceIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        String string = WWIO.getSourcePath((Object)object);
        return string != null && WWIO.getFilename((String)string).equalsIgnoreCase("places.shp");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Layer makeLayerFromOSMPlacesSource(Object object) {
        if (object == null || WWUtil.isEmpty((Object)object)) {
            String string = Logging.getMessage((String)"nullValue.SourceIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Shapefile shapefile = null;
        Layer layer = null;
        try {
            shapefile = new Shapefile(object);
            layer = OpenStreetMapShapefileLoader.makeLayerFromOSMPlacesShapefile(shapefile);
        }
        finally {
            if (shapefile != null) {
                shapefile.close();
            }
        }
        return layer;
    }

    /*
     * WARNING - void declaration
     */
    public static Layer makeLayerFromOSMPlacesShapefile(Shapefile shapefile) {
        Object object;
        BufferedImage bufferedImage;
        Object object2;
        if (shapefile == null) {
            String string = Logging.getMessage((String)"nullValue.ShapefileIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        OSMShapes[] oSMShapesArray = new OSMShapes[]{new OSMShapes(Color.BLACK, 0.3, 30000.0), new OSMShapes(Color.GREEN, 0.5, 100000.0), new OSMShapes(Color.CYAN, 1.0, 500000.0), new OSMShapes(Color.YELLOW, 2.0, 3000000.0)};
        while (shapefile.hasNext()) {
            void var6_10;
            Object object32;
            Object object4;
            object2 = shapefile.nextRecord();
            if (object2 == null || !object2.getShapeType().equals("gov.nasa.worldwind.formats.shapefile.Shapefile.ShapePoint") || (object4 = object2.getAttributes().getValue("type")) == null || !(object4 instanceof String)) continue;
            OSMShapes oSMShapes = null;
            String string = (String)object4;
            if (string.equalsIgnoreCase("hamlet")) {
                oSMShapes = oSMShapesArray[0];
            } else if (string.equalsIgnoreCase("village")) {
                oSMShapes = oSMShapesArray[1];
            } else if (string.equalsIgnoreCase("town")) {
                oSMShapes = oSMShapesArray[2];
            } else if (string.equalsIgnoreCase("city")) {
                oSMShapes = oSMShapesArray[3];
            }
            if (oSMShapes == null) continue;
            Object var6_11 = null;
            bufferedImage = object2.getAttributes();
            if (bufferedImage.getEntries() != null) {
                for (Object object32 : bufferedImage.getEntries()) {
                    if (!((String)object32.getKey()).equalsIgnoreCase("name")) continue;
                    String string2 = (String)object32.getValue();
                    break;
                }
            }
            object = ((ShapefileRecordPoint)object2).getPoint();
            object32 = LatLon.fromDegrees((double)object[1], (double)object[0]);
            if (!WWUtil.isEmpty((Object)var6_10)) {
                Label label = new Label((String)var6_10, new Position((LatLon)object32, 0.0));
                label.setFont(oSMShapes.font);
                label.setColor(oSMShapes.foreground);
                label.setBackgroundColor(oSMShapes.background);
                label.setMaxActiveAltitude(oSMShapes.labelMaxAltitude);
                label.setPriority(oSMShapes.labelMaxAltitude);
                oSMShapes.labels.add(label);
            }
            oSMShapes.locations.add((LatLon)object32);
        }
        object2 = new TextAndShapesLayer();
        for (OSMShapes oSMShapes : oSMShapesArray) {
            bufferedImage = PatternFactory.createPattern((String)"PatternFactory.PatternCircle", (float)0.8f, (Color)oSMShapes.foreground);
            object = new SurfaceIcons((Object)bufferedImage, shapefile.getPointBuffer().getLocations());
            object.setMaxSize(4000.0 * oSMShapes.scale);
            object.setMinSize(100.0);
            object.setScale(oSMShapes.scale);
            object.setOpacity(0.8);
            object2.addRenderable((Renderable)object);
            oSMShapes.locations.clear();
            for (Label label : oSMShapes.labels) {
                ((TextAndShapesLayer)((Object)object2)).addLabel((GeographicText)label);
            }
            oSMShapes.labels.clear();
        }
        return object2;
    }

    protected static class Label
    extends UserFacingText {
        protected double minActiveAltitude = -1.7976931348623157E308;
        protected double maxActiveAltitude = Double.MAX_VALUE;

        public Label(String string, Position position) {
            super((CharSequence)string, position);
        }

        public void setMinActiveAltitude(double d) {
            this.minActiveAltitude = d;
        }

        public void setMaxActiveAltitude(double d) {
            this.maxActiveAltitude = d;
        }

        public boolean isActive(DrawContext drawContext) {
            double d = drawContext.getView().getEyePosition().getElevation();
            return this.minActiveAltitude <= d && d <= this.maxActiveAltitude;
        }
    }

    protected static class TextAndShapesLayer
    extends RenderableLayer {
        protected ArrayList<GeographicText> labels = new ArrayList();
        protected GeographicTextRenderer textRenderer = new GeographicTextRenderer();

        public TextAndShapesLayer() {
            this.textRenderer.setCullTextEnabled(true);
            this.textRenderer.setCullTextMargin(2);
            this.textRenderer.setDistanceMaxScale(2.0);
            this.textRenderer.setDistanceMinScale(0.5);
            this.textRenderer.setDistanceMinOpacity(0.5);
            this.textRenderer.setEffect("gov.nasa.worldwind.avkey.TextEffectOutline");
        }

        public void addLabel(GeographicText geographicText) {
            this.labels.add(geographicText);
        }

        public void doRender(DrawContext drawContext) {
            super.doRender(drawContext);
            this.setActiveLabels(drawContext);
            this.textRenderer.render(drawContext, this.labels);
        }

        protected void setActiveLabels(DrawContext drawContext) {
            for (GeographicText geographicText : this.labels) {
                if (!(geographicText instanceof Label)) continue;
                geographicText.setVisible(((Label)geographicText).isActive(drawContext));
            }
        }
    }

    protected static class OSMShapes {
        public ArrayList<LatLon> locations = new ArrayList();
        public ArrayList<Label> labels = new ArrayList();
        public Color foreground;
        public Color background;
        public Font font;
        public double scale;
        public double labelMaxAltitude;

        public OSMShapes(Color color, double d, double d2) {
            this.foreground = color;
            this.background = WWUtil.computeContrastingColor((Color)color);
            this.font = new Font("Arial", 1, 10 + (int)(3.0 * d));
            this.scale = d;
            this.labelMaxAltitude = d2;
        }
    }
}

