/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.util;

import gov.nasa.worldwind.util.ImageUtil;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwind.util.WWMath;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.logging.Level;
import javax.imageio.ImageIO;

public class PowerOfTwoPaddedImage {
    protected BufferedImage image;
    protected int width;
    protected int height;

    protected PowerOfTwoPaddedImage(BufferedImage bufferedImage, int n, int n2) {
        if (bufferedImage == null) {
            String string = Logging.getMessage((String)"nullValue.ImageIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n <= 0) {
            String string = Logging.getMessage((String)"Geom.WidthInvalid", (Object[])new Object[]{n});
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n2 <= 0) {
            String string = Logging.getMessage((String)"Geom.HeightInvalid", (Object[])new Object[]{n2});
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.image = bufferedImage;
        this.width = n;
        this.height = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PowerOfTwoPaddedImage fromBufferedImage(BufferedImage bufferedImage) {
        if (bufferedImage == null) {
            String string = Logging.getMessage((String)"nullValue.ImageIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        BufferedImage bufferedImage2 = bufferedImage;
        if (!WWMath.isPowerOfTwo((int)bufferedImage.getWidth()) || !WWMath.isPowerOfTwo((int)bufferedImage.getHeight()) || bufferedImage.getTransparency() == 1) {
            int n = WWMath.powerOfTwoCeiling((int)bufferedImage.getWidth());
            int n2 = WWMath.powerOfTwoCeiling((int)bufferedImage.getHeight());
            bufferedImage2 = ImageUtil.createCompatibleImage((int)n, (int)n2, (int)3);
            Graphics2D graphics2D = bufferedImage2.createGraphics();
            try {
                graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
            }
            finally {
                graphics2D.dispose();
            }
        }
        return new PowerOfTwoPaddedImage(bufferedImage2, bufferedImage.getWidth(), bufferedImage.getHeight());
    }

    public static PowerOfTwoPaddedImage fromPath(String string) {
        if (string == null) {
            String string2 = Logging.getMessage((String)"nullValue.PathIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        Object object = WWIO.getFileOrResourceAsStream((String)string, null);
        if (object == null || object instanceof Exception) {
            Logging.logger().log(Level.SEVERE, "generic.ExceptionAttemptingToReadImageFile", object != null ? object : string);
            return null;
        }
        try {
            BufferedImage bufferedImage = ImageIO.read((InputStream)object);
            return PowerOfTwoPaddedImage.fromBufferedImage(bufferedImage);
        }
        catch (Exception exception) {
            String string3 = Logging.getMessage((String)"generic.ExceptionAttemptingToReadImageFile", (String)string);
            Logging.logger().severe(string3);
            return null;
        }
    }

    public int getOriginalWidth() {
        return this.width;
    }

    public int getOriginalHeight() {
        return this.height;
    }

    public BufferedImage getPowerOfTwoImage() {
        return this.image;
    }

    public int getPowerOfTwoWidth() {
        return this.image.getWidth();
    }

    public int getPowerOfTwoHeight() {
        return this.image.getHeight();
    }
}

