/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.util;

import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.PointPlacemarkAttributes;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.util.WWUtil;
import java.awt.Color;

public class RandomShapeAttributes {
    protected int attrIndex = 0;
    protected PointPlacemarkAttributes[] pointAttrs;
    protected ShapeAttributes[] polylineAttrs;
    protected ShapeAttributes[] polygonAttrs;

    public RandomShapeAttributes() {
        this.initialize();
    }

    protected void initialize() {
        this.pointAttrs = new PointPlacemarkAttributes[]{this.createPointAttributes(Color.YELLOW), this.createPointAttributes(Color.BLUE), this.createPointAttributes(Color.RED), this.createPointAttributes(Color.GREEN), this.createPointAttributes(Color.CYAN), this.createPointAttributes(Color.ORANGE), this.createPointAttributes(Color.MAGENTA)};
        this.polylineAttrs = new ShapeAttributes[]{this.createPolylineAttributes(Color.YELLOW), this.createPolylineAttributes(Color.BLUE), this.createPolylineAttributes(Color.RED), this.createPolylineAttributes(Color.GREEN), this.createPolylineAttributes(Color.CYAN), this.createPolylineAttributes(Color.ORANGE), this.createPolylineAttributes(Color.MAGENTA)};
        this.polygonAttrs = new ShapeAttributes[]{this.createPolygonAttributes(Color.YELLOW), this.createPolygonAttributes(Color.BLUE), this.createPolygonAttributes(Color.RED), this.createPolygonAttributes(Color.GREEN), this.createPolygonAttributes(Color.CYAN), this.createPolygonAttributes(Color.ORANGE), this.createPolygonAttributes(Color.MAGENTA)};
    }

    public PointPlacemarkAttributes nextPointAttributes() {
        return this.pointAttrs[this.attrIndex++ % this.pointAttrs.length];
    }

    public ShapeAttributes nextPolylineAttributes() {
        return this.polylineAttrs[this.attrIndex++ % this.polylineAttrs.length];
    }

    public ShapeAttributes nextPolygonAttributes() {
        return this.polygonAttrs[this.attrIndex++ % this.polygonAttrs.length];
    }

    protected PointPlacemarkAttributes createPointAttributes(Color color) {
        PointPlacemarkAttributes pointPlacemarkAttributes = new PointPlacemarkAttributes();
        pointPlacemarkAttributes.setUsePointAsDefaultImage(true);
        pointPlacemarkAttributes.setLineMaterial(new Material(color));
        pointPlacemarkAttributes.setScale(Double.valueOf(7.0));
        return pointPlacemarkAttributes;
    }

    protected ShapeAttributes createPolylineAttributes(Color color) {
        BasicShapeAttributes basicShapeAttributes = new BasicShapeAttributes();
        basicShapeAttributes.setOutlineMaterial(new Material(color));
        basicShapeAttributes.setOutlineWidth(1.5);
        return basicShapeAttributes;
    }

    protected ShapeAttributes createPolygonAttributes(Color color) {
        BasicShapeAttributes basicShapeAttributes = new BasicShapeAttributes();
        basicShapeAttributes.setInteriorMaterial(new Material(color));
        basicShapeAttributes.setOutlineMaterial(new Material(WWUtil.makeColorBrighter((Color)color)));
        basicShapeAttributes.setInteriorOpacity(0.5);
        basicShapeAttributes.setOutlineWidth(3.0);
        return basicShapeAttributes;
    }
}

