/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.util;

import gov.nasa.worldwind.Movable;
import gov.nasa.worldwind.View;
import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.event.DragSelectEvent;
import gov.nasa.worldwind.event.RenderingEvent;
import gov.nasa.worldwind.event.RenderingListener;
import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Intersection;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.EllipsoidalGlobe;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.LayerList;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.pick.PickedObject;
import gov.nasa.worldwind.pick.PickedObjectList;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.render.SurfaceSector;
import gov.nasa.worldwind.util.Logging;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.logging.Level;

public class SectorSelector
extends WWObjectImpl
implements SelectListener,
MouseListener,
MouseMotionListener,
RenderingListener {
    public static final String SECTOR_PROPERTY = "gov.nasa.worldwind.SectorSelector";
    protected static final int NONE = 0;
    protected static final int MOVING = 1;
    protected static final int SIZING = 2;
    protected static final int NORTH = 1;
    protected static final int SOUTH = 2;
    protected static final int EAST = 4;
    protected static final int WEST = 8;
    protected static final int NORTHWEST = 9;
    protected static final int NORTHEAST = 5;
    protected static final int SOUTHWEST = 10;
    protected static final int SOUTHEAST = 6;
    private final WorldWindow wwd;
    private final Layer layer;
    private final RegionShape shape;
    private double edgeFactor = 0.1;
    private boolean armed = false;
    private int operation = 0;
    private int side = 0;
    private Position previousPosition = null;
    private Sector previousSector = null;

    public SectorSelector(WorldWindow worldWindow) {
        if (worldWindow == null) {
            String string = Logging.getMessage((String)"nullValue.WorldWindow");
            Logging.logger().log(Level.SEVERE, string);
            throw new IllegalArgumentException(string);
        }
        this.wwd = worldWindow;
        this.layer = new RenderableLayer();
        this.shape = new RegionShape(Sector.EMPTY_SECTOR);
        ((RenderableLayer)this.layer).addRenderable((Renderable)this.shape);
    }

    protected SectorSelector(WorldWindow worldWindow, RegionShape regionShape, RenderableLayer renderableLayer) {
        if (worldWindow == null) {
            String string = Logging.getMessage((String)"nullValue.WorldWindow");
            Logging.logger().log(Level.SEVERE, string);
            throw new IllegalArgumentException(string);
        }
        if (regionShape == null) {
            String string = Logging.getMessage((String)"nullValue.Shape");
            Logging.logger().log(Level.SEVERE, string);
            throw new IllegalArgumentException(string);
        }
        if (renderableLayer == null) {
            String string = Logging.getMessage((String)"nullValue.Layer");
            Logging.logger().log(Level.SEVERE, string);
            throw new IllegalArgumentException(string);
        }
        this.wwd = worldWindow;
        this.shape = regionShape;
        this.layer = renderableLayer;
        renderableLayer.addRenderable((Renderable)this.shape);
    }

    public WorldWindow getWwd() {
        return this.wwd;
    }

    public Layer getLayer() {
        return this.layer;
    }

    public void enable() {
        this.getShape().setStartPosition(null);
        LayerList layerList = this.getWwd().getModel().getLayers();
        if (!layerList.contains((Object)this.getLayer())) {
            layerList.add(this.getLayer());
        }
        if (!this.getLayer().isEnabled()) {
            this.getLayer().setEnabled(true);
        }
        this.setArmed(true);
        this.getWwd().addRenderingListener((RenderingListener)this);
        this.getWwd().addSelectListener((SelectListener)this);
        this.getWwd().getInputHandler().addMouseListener((MouseListener)this);
        this.getWwd().getInputHandler().addMouseMotionListener((MouseMotionListener)this);
        this.setCursor(Cursor.getPredefinedCursor(1));
    }

    public void disable() {
        this.getWwd().removeRenderingListener((RenderingListener)this);
        this.getWwd().removeSelectListener((SelectListener)this);
        this.getWwd().getInputHandler().removeMouseListener((MouseListener)this);
        this.getWwd().getInputHandler().removeMouseMotionListener((MouseMotionListener)this);
        this.getWwd().getModel().getLayers().remove(this.getLayer());
        this.getShape().clear();
    }

    public Sector getSector() {
        return this.getShape().hasSelection() ? this.getShape().getSector() : null;
    }

    public Color getInteriorColor() {
        return this.getShape().getInteriorColor();
    }

    public void setInteriorColor(Color color) {
        this.getShape().setInteriorColor(color);
    }

    public Color getBorderColor() {
        return this.getShape().getBorderColor();
    }

    public void setBorderColor(Color color) {
        this.getShape().setBorderColor(color);
    }

    public double getInteriorOpacity() {
        return this.getShape().getInteriorOpacity();
    }

    public void setInteriorOpacity(double d) {
        this.getShape().setInteriorOpacity(d);
    }

    public double getBorderOpacity() {
        return this.getShape().getBorderOpacity();
    }

    public void setBorderOpacity(double d) {
        this.getShape().setBorderOpacity(d);
    }

    public double getBorderWidth() {
        return this.getShape().getBorderWidth();
    }

    public void setBorderWidth(double d) {
        this.getShape().setBorderWidth(d);
    }

    protected RegionShape getShape() {
        return this.shape;
    }

    protected boolean isArmed() {
        return this.armed;
    }

    protected void setArmed(boolean bl) {
        this.armed = bl;
    }

    protected int getOperation() {
        return this.operation;
    }

    protected void setOperation(int n) {
        this.operation = n;
    }

    protected int getSide() {
        return this.side;
    }

    protected void setSide(int n) {
        this.side = n;
    }

    protected Position getPreviousPosition() {
        return this.previousPosition;
    }

    protected void setPreviousPosition(Position position) {
        this.previousPosition = position;
    }

    protected double getEdgeFactor() {
        return this.edgeFactor;
    }

    protected void setEdgeFactor(double d) {
        this.edgeFactor = d;
    }

    public void stageChanged(RenderingEvent renderingEvent) {
        if (!renderingEvent.getStage().equals("gov.nasa.worldwind.RenderingEvent.AfterBufferSwap")) {
            return;
        }
        this.notifySectorChanged();
    }

    protected void notifySectorChanged() {
        if (this.getShape().hasSelection() && this.getSector() != null && !this.getSector().equals((Object)this.previousSector)) {
            this.firePropertyChange(SECTOR_PROPERTY, this.previousSector, this.getShape().getSector());
            this.previousSector = this.getSector();
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (1024 != mouseEvent.getModifiersEx()) {
            return;
        }
        if (!this.isArmed()) {
            return;
        }
        this.getShape().setResizeable(true);
        this.getShape().setStartPosition(null);
        this.setArmed(false);
        mouseEvent.consume();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (1 != mouseEvent.getButton()) {
            return;
        }
        if (this.getShape().isResizeable()) {
            this.setCursor(null);
        }
        this.getShape().setResizeable(false);
        mouseEvent.consume();
        this.firePropertyChange(SECTOR_PROPERTY, this.previousSector, null);
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (1024 != mouseEvent.getModifiersEx()) {
            return;
        }
        if (this.getShape().isResizeable()) {
            mouseEvent.consume();
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void selected(SelectEvent selectEvent) {
        if (selectEvent == null) {
            String string = Logging.getMessage((String)"nullValue.EventIsNull");
            Logging.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        if (this.getOperation() == 0 && selectEvent.getTopObject() != null && selectEvent.getTopPickedObject().getParentLayer() != this.layer) {
            this.setCursor(null);
            return;
        }
        if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.LeftPress")) {
            this.setPreviousPosition(this.getWwd().getCurrentPosition());
        } else if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.Drag")) {
            DragSelectEvent dragSelectEvent = (DragSelectEvent)selectEvent;
            Object object = dragSelectEvent.getTopObject();
            if (object == null) {
                return;
            }
            RegionShape regionShape = this.getShape();
            if (this.getOperation() == 2) {
                Sector sector = this.resizeShape((Movable)regionShape, this.getSide());
                if (sector != null) {
                    regionShape.setSector(sector);
                }
                selectEvent.consume();
            } else {
                this.setSide(this.determineAdjustmentSide((Movable)regionShape, this.getEdgeFactor()));
                if (this.getSide() == 0 || this.getOperation() == 1) {
                    this.setOperation(1);
                    this.dragWholeShape(dragSelectEvent, (Movable)regionShape);
                } else {
                    Sector sector = this.resizeShape((Movable)regionShape, this.getSide());
                    if (sector != null) {
                        regionShape.setSector(sector);
                    }
                    this.setOperation(2);
                }
                selectEvent.consume();
            }
            this.setPreviousPosition(this.getWwd().getCurrentPosition());
            this.notifySectorChanged();
        } else if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.DragEnd")) {
            this.setOperation(0);
            this.setPreviousPosition(null);
        } else if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.Rollover") && this.getOperation() == 0) {
            if (!(this.getWwd() instanceof Component)) {
                return;
            }
            if (selectEvent.getTopObject() == null || selectEvent.getTopPickedObject().isTerrain()) {
                this.setCursor(null);
                return;
            }
            if (!(selectEvent.getTopObject() instanceof Movable)) {
                return;
            }
            this.setCursor(this.determineAdjustmentSide((Movable)selectEvent.getTopObject(), this.getEdgeFactor()));
        }
    }

    protected int determineAdjustmentSide(Movable movable, double d) {
        if (movable instanceof SurfaceSector) {
            SurfaceSector surfaceSector = (SurfaceSector)movable;
            Sector sector = surfaceSector.getSector();
            Position position = this.getWwd().getCurrentPosition();
            if (position == null) {
                return 0;
            }
            double d2 = SectorSelector.abs(sector.getMaxLatitude().subtract((Angle)position.getLatitude()).degrees);
            double d3 = SectorSelector.abs(sector.getMinLatitude().subtract((Angle)position.getLatitude()).degrees);
            double d4 = SectorSelector.abs(sector.getMinLongitude().subtract((Angle)position.getLongitude()).degrees);
            double d5 = SectorSelector.abs(sector.getMaxLongitude().subtract((Angle)position.getLongitude()).degrees);
            double d6 = d * sector.getDeltaLatDegrees();
            double d7 = d * sector.getDeltaLonDegrees();
            if (d2 < d6 && d4 < d7) {
                return 9;
            }
            if (d2 < d6 && d5 < d7) {
                return 5;
            }
            if (d3 < d6 && d4 < d7) {
                return 10;
            }
            if (d3 < d6 && d5 < d7) {
                return 6;
            }
            if (d2 < d6) {
                return 1;
            }
            if (d3 < d6) {
                return 2;
            }
            if (d4 < d7) {
                return 8;
            }
            if (d5 < d7) {
                return 4;
            }
        }
        return 0;
    }

    protected Sector resizeShape(Movable movable, int n) {
        if (movable instanceof SurfaceSector) {
            SurfaceSector surfaceSector = (SurfaceSector)movable;
            Sector sector = surfaceSector.getSector();
            Position position = this.getWwd().getCurrentPosition();
            if (position == null || this.getPreviousPosition() == null) {
                return null;
            }
            Angle angle = position.getLatitude().subtract(this.getPreviousPosition().getLatitude());
            Angle angle2 = position.getLongitude().subtract(this.getPreviousPosition().getLongitude());
            Angle angle3 = sector.getMinLatitude();
            Angle angle4 = sector.getMinLongitude();
            Angle angle5 = sector.getMaxLatitude();
            Angle angle6 = sector.getMaxLongitude();
            if (n == 1) {
                angle5 = sector.getMaxLatitude().add(angle);
            } else if (n == 2) {
                angle3 = sector.getMinLatitude().add(angle);
            } else if (n == 4) {
                angle6 = sector.getMaxLongitude().add(angle2);
            } else if (n == 8) {
                angle4 = sector.getMinLongitude().add(angle2);
            } else if (n == 9) {
                angle5 = sector.getMaxLatitude().add(angle);
                angle4 = sector.getMinLongitude().add(angle2);
            } else if (n == 5) {
                angle5 = sector.getMaxLatitude().add(angle);
                angle6 = sector.getMaxLongitude().add(angle2);
            } else if (n == 10) {
                angle3 = sector.getMinLatitude().add(angle);
                angle4 = sector.getMinLongitude().add(angle2);
            } else if (n == 6) {
                angle3 = sector.getMinLatitude().add(angle);
                angle6 = sector.getMaxLongitude().add(angle2);
            }
            return new Sector(angle3, angle5, angle4, angle6);
        }
        return null;
    }

    private static double abs(double d) {
        return d >= 0.0 ? d : -d;
    }

    protected void dragWholeShape(DragSelectEvent dragSelectEvent, Movable movable) {
        View view = this.getWwd().getView();
        EllipsoidalGlobe ellipsoidalGlobe = (EllipsoidalGlobe)this.getWwd().getModel().getGlobe();
        Position position = movable.getReferencePosition();
        if (position == null) {
            return;
        }
        Vec4 vec4 = ellipsoidalGlobe.computePointFromPosition(position);
        Vec4 vec42 = view.project(vec4);
        int n = dragSelectEvent.getPickPoint().x - dragSelectEvent.getPreviousPickPoint().x;
        double d = vec42.x + (double)n;
        int n2 = dragSelectEvent.getPickPoint().y - dragSelectEvent.getPreviousPickPoint().y;
        double d2 = (double)dragSelectEvent.getMouseEvent().getComponent().getSize().height - vec42.y + (double)n2 - 1.0;
        Line line = view.computeRayFromScreenPoint(d, d2);
        Intersection[] intersectionArray = ellipsoidalGlobe.intersect(line, position.getElevation());
        if (intersectionArray != null) {
            Position position2 = ellipsoidalGlobe.computePositionFromPoint(intersectionArray[0].getIntersectionPoint());
            movable.moveTo(position2);
        }
    }

    protected void setCursor(int n) {
        Cursor cursor = null;
        switch (n) {
            case 0: {
                cursor = Cursor.getPredefinedCursor(12);
                break;
            }
            case 1: {
                cursor = Cursor.getPredefinedCursor(8);
                break;
            }
            case 2: {
                cursor = Cursor.getPredefinedCursor(9);
                break;
            }
            case 4: {
                cursor = Cursor.getPredefinedCursor(11);
                break;
            }
            case 8: {
                cursor = Cursor.getPredefinedCursor(10);
                break;
            }
            case 9: {
                cursor = Cursor.getPredefinedCursor(6);
                break;
            }
            case 5: {
                cursor = Cursor.getPredefinedCursor(7);
                break;
            }
            case 10: {
                cursor = Cursor.getPredefinedCursor(4);
                break;
            }
            case 6: {
                cursor = Cursor.getPredefinedCursor(5);
            }
        }
        this.setCursor(cursor);
    }

    protected void setCursor(Cursor cursor) {
        ((Component)this.getWwd()).setCursor(cursor != null ? cursor : Cursor.getDefaultCursor());
    }

    protected static class RegionShape
    extends SurfaceSector {
        private boolean resizeable = false;
        private Position startPosition;
        private Position endPosition;
        private SurfaceSector borderShape;

        protected RegionShape(Sector sector) {
            super(sector);
            this.setBorder(new SurfaceSector(sector));
            this.setPathType("gov.nasa.worldwind.avkey.Linear");
            this.getBorder().setPathType("gov.nasa.worldwind.avkey.Linear");
            BasicShapeAttributes basicShapeAttributes = new BasicShapeAttributes();
            basicShapeAttributes.setDrawOutline(false);
            basicShapeAttributes.setInteriorMaterial(new Material(Color.WHITE));
            basicShapeAttributes.setInteriorOpacity(0.1);
            this.setAttributes((ShapeAttributes)basicShapeAttributes);
            this.setHighlightAttributes((ShapeAttributes)basicShapeAttributes);
            BasicShapeAttributes basicShapeAttributes2 = new BasicShapeAttributes();
            basicShapeAttributes2.setDrawInterior(false);
            basicShapeAttributes2.setOutlineMaterial(new Material(Color.RED));
            basicShapeAttributes2.setOutlineOpacity(0.7);
            basicShapeAttributes2.setOutlineWidth(3.0);
            this.getBorder().setAttributes((ShapeAttributes)basicShapeAttributes2);
            this.getBorder().setHighlightAttributes((ShapeAttributes)basicShapeAttributes2);
        }

        public Color getInteriorColor() {
            return this.getAttributes().getInteriorMaterial().getDiffuse();
        }

        public void setInteriorColor(Color color) {
            ShapeAttributes shapeAttributes = this.getAttributes();
            shapeAttributes.setInteriorMaterial(new Material(color));
            this.setAttributes(shapeAttributes);
        }

        public Color getBorderColor() {
            return this.getBorder().getAttributes().getOutlineMaterial().getDiffuse();
        }

        public void setBorderColor(Color color) {
            ShapeAttributes shapeAttributes = this.getBorder().getAttributes();
            shapeAttributes.setOutlineMaterial(new Material(color));
            this.getBorder().setAttributes(shapeAttributes);
        }

        public double getInteriorOpacity() {
            return this.getAttributes().getInteriorOpacity();
        }

        public void setInteriorOpacity(double d) {
            ShapeAttributes shapeAttributes = this.getAttributes();
            shapeAttributes.setInteriorOpacity(d);
            this.setAttributes(shapeAttributes);
        }

        public double getBorderOpacity() {
            return this.getBorder().getAttributes().getOutlineOpacity();
        }

        public void setBorderOpacity(double d) {
            ShapeAttributes shapeAttributes = this.getBorder().getAttributes();
            shapeAttributes.setOutlineOpacity(d);
            this.getBorder().setAttributes(shapeAttributes);
        }

        public double getBorderWidth() {
            return this.getBorder().getAttributes().getOutlineWidth();
        }

        public void setBorderWidth(double d) {
            ShapeAttributes shapeAttributes = this.getBorder().getAttributes();
            shapeAttributes.setOutlineWidth(d);
            this.getBorder().setAttributes(shapeAttributes);
        }

        public void setSector(Sector sector) {
            super.setSector(sector);
            this.getBorder().setSector(sector);
        }

        protected boolean isResizeable() {
            return this.resizeable;
        }

        protected void setResizeable(boolean bl) {
            this.resizeable = bl;
        }

        protected Position getStartPosition() {
            return this.startPosition;
        }

        protected void setStartPosition(Position position) {
            this.startPosition = position;
        }

        protected Position getEndPosition() {
            return this.endPosition;
        }

        protected void setEndPosition(Position position) {
            this.endPosition = position;
        }

        protected SurfaceSector getBorder() {
            return this.borderShape;
        }

        protected void setBorder(SurfaceSector surfaceSector) {
            if (surfaceSector == null) {
                String string = Logging.getMessage((String)"nullValue.Shape");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            this.borderShape = surfaceSector;
        }

        protected boolean hasSelection() {
            return this.getStartPosition() != null && this.getEndPosition() != null;
        }

        protected void clear() {
            this.setStartPosition(null);
            this.setEndPosition(null);
            this.setSector(Sector.EMPTY_SECTOR);
        }

        public void preRender(DrawContext drawContext) {
            if (drawContext.isOrderedRenderingMode()) {
                super.preRender(drawContext);
                return;
            }
            this.doPreRender(drawContext);
        }

        public void render(DrawContext drawContext) {
            PickedObject pickedObject;
            if (drawContext.isPickingMode() && this.isResizeable()) {
                return;
            }
            if (drawContext.isOrderedRenderingMode()) {
                super.render(drawContext);
                return;
            }
            if (!this.isResizeable()) {
                if (this.hasSelection()) {
                    this.doRender(drawContext);
                }
                return;
            }
            PickedObjectList pickedObjectList = drawContext.getPickedObjects();
            PickedObject pickedObject2 = pickedObject = pickedObjectList != null ? pickedObjectList.getTerrainObject() : null;
            if (pickedObject == null) {
                return;
            }
            if (this.getStartPosition() != null) {
                Position position = pickedObject.getPosition();
                if (!this.getStartPosition().equals((Object)position)) {
                    this.setEndPosition(position);
                    this.setSector(Sector.boundingSector((LatLon)this.getStartPosition(), (LatLon)this.getEndPosition()));
                    this.doRender(drawContext);
                }
            } else {
                this.setStartPosition(pickedObjectList.getTerrainObject().getPosition());
            }
        }

        protected void doPreRender(DrawContext drawContext) {
            this.doPreRenderInterior(drawContext);
            this.doPreRenderBorder(drawContext);
        }

        protected void doPreRenderInterior(DrawContext drawContext) {
            super.preRender(drawContext);
        }

        protected void doPreRenderBorder(DrawContext drawContext) {
            this.getBorder().preRender(drawContext);
        }

        protected void doRender(DrawContext drawContext) {
            this.doRenderInterior(drawContext);
            this.doRenderBorder(drawContext);
        }

        protected void doRenderInterior(DrawContext drawContext) {
            super.render(drawContext);
        }

        protected void doRenderBorder(DrawContext drawContext) {
            this.getBorder().render(drawContext);
        }
    }
}

