/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.util;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.View;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.LayerList;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwind.util.WWUtil;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Comparator;
import java.util.logging.Level;

public class SessionState {
    protected static final String VIEW_STATE_PATH = "SessionState/ViewState.xml";
    protected static final String LAYER_STATE_PATH = "SessionState/LayerState";
    protected static final String LAYER_STATE_FILENAME_DELIMITER = "-";
    protected static final Comparator<String> LAYER_STATE_FILENAME_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String string, String string2) {
            LayerStateFilename layerStateFilename = SessionState.parseLayerStateFilename(string);
            LayerStateFilename layerStateFilename2 = SessionState.parseLayerStateFilename(string2);
            if (layerStateFilename == null || layerStateFilename2 == null) {
                return layerStateFilename2 != null ? -1 : (layerStateFilename != null ? 1 : 0);
            }
            return layerStateFilename.index < layerStateFilename2.index ? -1 : (layerStateFilename.index > layerStateFilename2.index ? 1 : 0);
        }
    };
    protected String sessionKey;

    public SessionState(String string) {
        if (WWUtil.isEmpty((Object)string)) {
            String string2 = Logging.getMessage((String)"nullValue.KeyIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.sessionKey = string;
    }

    public String getSessionKey() {
        return this.sessionKey;
    }

    public void saveSessionState(WorldWindow worldWindow) {
        if (worldWindow == null) {
            String string = Logging.getMessage((String)"nullValue.WorldWindow");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.saveViewState(worldWindow);
        this.saveLayerListState(worldWindow);
    }

    public void restoreSessionState(WorldWindow worldWindow) {
        if (worldWindow == null) {
            String string = Logging.getMessage((String)"nullValue.WorldWindow");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.restoreViewState(worldWindow);
        this.restoreLayerListState(worldWindow);
    }

    protected void saveViewState(WorldWindow worldWindow) {
        View view = worldWindow.getView();
        if (view == null) {
            return;
        }
        try {
            String string = view.getRestorableState();
            if (WWUtil.isEmpty((Object)string)) {
                return;
            }
            WWIO.makeParentDirs((String)this.getViewStatePath());
            WWIO.writeTextFile((String)string, (File)new File(this.getViewStatePath()));
        }
        catch (Exception exception) {
            Logging.logger().log(Level.SEVERE, "Unable to save view state: " + view, exception);
        }
    }

    protected void restoreViewState(WorldWindow worldWindow) {
        View view = worldWindow.getView();
        if (view == null) {
            return;
        }
        File file = new File(this.getViewStatePath());
        if (!file.exists()) {
            return;
        }
        try {
            String string = WWIO.readTextFile((File)file);
            if (WWUtil.isEmpty((Object)string)) {
                String string2 = Logging.getMessage((String)"nullValue.RestorableStateIsNull");
                Logging.logger().warning(string2);
                return;
            }
            worldWindow.getView().restoreState(string);
        }
        catch (Exception exception) {
            Logging.logger().log(Level.SEVERE, "Unable to restore view state: " + file, exception);
        }
    }

    protected void saveLayerListState(WorldWindow worldWindow) {
        if (worldWindow.getModel() == null || worldWindow.getModel().getLayers() == null) {
            return;
        }
        File file = new File(this.getLayerStatePath());
        try {
            if (file.exists()) {
                WWIO.deleteDirectory((File)file);
            } else {
                file.mkdirs();
            }
            int n = 0;
            for (Layer layer : worldWindow.getModel().getLayers()) {
                if (layer == null) continue;
                String string = SessionState.composeLayerStateFilename(layer.getClass().getName(), n);
                this.saveLayerState(layer, new File(file, string));
                ++n;
            }
        }
        catch (Exception exception) {
            Logging.logger().log(Level.SEVERE, "Unable to save layer list state: " + file, exception);
        }
    }

    protected void restoreLayerListState(WorldWindow worldWindow) {
        if (worldWindow.getModel() == null || worldWindow.getModel().getLayers() == null) {
            return;
        }
        File file = new File(this.getLayerStatePath());
        String[] stringArray = file.list();
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        try {
            Arrays.sort(stringArray, LAYER_STATE_FILENAME_COMPARATOR);
            LayerList layerList = worldWindow.getModel().getLayers();
            for (String string : stringArray) {
                LayerStateFilename layerStateFilename;
                Layer layer = this.restoreLayerState(new File(file, string));
                if (layer == null) continue;
                Layer layer2 = this.findLayer(layerList, layer.getName());
                if (layer2 != null) {
                    layerList.remove(layer2);
                }
                if ((layerStateFilename = SessionState.parseLayerStateFilename(string)) != null && layerStateFilename.index < layerList.size()) {
                    layerList.add(layerStateFilename.index, layer);
                    continue;
                }
                layerList.add(layer);
            }
        }
        catch (Exception exception) {
            Logging.logger().log(Level.SEVERE, "Unable to restore layer list state: " + file, exception);
        }
    }

    protected void saveLayerState(Layer layer, File file) {
        try {
            if (!this.isLayerRestorable(layer)) {
                return;
            }
            String string = layer.getRestorableState();
            if (WWUtil.isEmpty((Object)string)) {
                return;
            }
            WWIO.writeTextFile((String)string, (File)file);
        }
        catch (Exception exception) {
            Logging.logger().log(Level.SEVERE, "Unable to save layer state: " + layer, exception);
        }
    }

    protected Layer restoreLayerState(File file) {
        try {
            String string = WWIO.readTextFile((File)file);
            if (WWUtil.isEmpty((Object)string)) {
                String string2 = Logging.getMessage((String)"nullValue.RestorableStateIsNull");
                Logging.logger().warning(string2);
                return null;
            }
            LayerStateFilename layerStateFilename = SessionState.parseLayerStateFilename(file.getName());
            if (layerStateFilename == null) {
                Logging.logger().warning("Invalid layer state filename: " + file.getName());
                return null;
            }
            Class<?> clazz = Class.forName(layerStateFilename.className);
            Constructor<?> constructor = clazz.getConstructor(String.class);
            Object obj = constructor.newInstance(string);
            return obj != null && obj instanceof Layer ? (Layer)obj : null;
        }
        catch (Exception exception) {
            Logging.logger().log(Level.SEVERE, "Unable to restore layer state: " + file, exception);
            return null;
        }
    }

    protected boolean isLayerRestorable(Layer layer) {
        try {
            if (layer.getClass().getConstructor(String.class) != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    protected Layer findLayer(LayerList layerList, String string) {
        if (string == null) {
            return null;
        }
        for (Layer layer : layerList) {
            if (layer.getName() == null || !layer.getName().equals(string)) continue;
            return layer;
        }
        return null;
    }

    protected String getSessionStatePath() {
        String string = Configuration.getCurrentUserAppDataDirectory();
        String string2 = this.getSessionKey();
        if ((Configuration.isLinuxOS() || Configuration.isUnixOS() || Configuration.isSolarisOS()) && !string2.startsWith(".")) {
            string2 = "." + string2;
        }
        return WWIO.appendPathPart((String)string, (String)string2);
    }

    protected String getViewStatePath() {
        return WWIO.appendPathPart((String)this.getSessionStatePath(), (String)VIEW_STATE_PATH);
    }

    protected String getLayerStatePath() {
        return WWIO.appendPathPart((String)this.getSessionStatePath(), (String)LAYER_STATE_PATH);
    }

    protected static LayerStateFilename parseLayerStateFilename(String string) {
        String string2 = WWIO.replaceSuffix((String)string, (String)"");
        String[] stringArray = string2.split(LAYER_STATE_FILENAME_DELIMITER);
        if (stringArray == null || stringArray.length < 2) {
            return null;
        }
        Integer n = WWUtil.makeInteger((String)stringArray[0]);
        if (n == null) {
            return null;
        }
        String string3 = stringArray[1].trim();
        return new LayerStateFilename(string3, n);
    }

    protected static String composeLayerStateFilename(String string, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(n);
        stringBuilder.append(LAYER_STATE_FILENAME_DELIMITER);
        stringBuilder.append(string);
        stringBuilder.append(".xml");
        return stringBuilder.toString();
    }

    protected static class LayerStateFilename {
        protected String className;
        protected int index;

        public LayerStateFilename(String string, int n) {
            this.className = string;
            this.index = n;
        }
    }
}

