/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.util;

import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.render.Annotation;
import gov.nasa.worldwind.render.AnnotationAttributes;
import gov.nasa.worldwind.render.AnnotationFlowLayout;
import gov.nasa.worldwind.render.AnnotationLayoutManager;
import gov.nasa.worldwind.render.AnnotationNullLayout;
import gov.nasa.worldwind.render.ScreenAnnotation;
import gov.nasa.worldwindx.examples.util.ButtonAnnotation;
import gov.nasa.worldwindx.examples.util.DialogAnnotation;
import gov.nasa.worldwindx.examples.util.ImageAnnotation;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;

public class SlideShowAnnotation
extends DialogAnnotation {
    public static final String INCREASE = "SlideShowAnnotation.Increase";
    public static final String DECREASE = "SlideShowAnnotation.Decrease";
    protected static final String PLAY_IMAGE_PATH = "gov/nasa/worldwindx/examples/images/16x16-button-play.png";
    protected static final String PAUSE_IMAGE_PATH = "gov/nasa/worldwindx/examples/images/16x16-button-pause.png";
    protected static final String PREVIOUS_IMAGE_PATH = "gov/nasa/worldwindx/examples/images/16x16-button-previous.png";
    protected static final String NEXT_IMAGE_PATH = "gov/nasa/worldwindx/examples/images/16x16-button-next.png";
    protected static final String BEGIN_IMAGE_PATH = "gov/nasa/worldwindx/examples/images/16x16-button-start.png";
    protected static final String END_IMAGE_PATH = "gov/nasa/worldwindx/examples/images/16x16-button-end.png";
    protected static final String INCREASE_IMAGE_PATH = "gov/nasa/worldwindx/examples/images/16x16-button-window-increase.png";
    protected static final String DECREASE_IMAGE_PATH = "gov/nasa/worldwindx/examples/images/16x16-button-window-decrease.png";
    protected static final String BUSY_IMAGE_PATH = "images/indicator-32.gif";
    protected static final String PLAY_TOOLTIP_TEXT = "Play slide show";
    protected static final String PAUSE_TOOLTIP_TEXT = "Pause slide show";
    protected static final String PREVIOUS_TOOLTIP_TEXT = "Previous image";
    protected static final String NEXT_TOOLTIP_TEXT = "Next image";
    protected static final String BEGIN_TOOLTIP_TEXT = "First image";
    protected static final String END_TOOLTIP_TEXT = "Last image";
    protected static final String INCREASE_TOOLTIP_TEXT = "Increase slide show size";
    protected static final String DECREASE_TOOLTIP_TEXT = "Decrease slide show size";
    protected Annotation titleLabel;
    protected Annotation positionLabel;
    protected ImageAnnotation imageAnnotation;
    protected ButtonAnnotation playButton;
    protected ButtonAnnotation previousButton;
    protected ButtonAnnotation nextButton;
    protected ButtonAnnotation beginButton;
    protected ButtonAnnotation endButton;
    protected ButtonAnnotation sizeButton;

    public SlideShowAnnotation(Position position) {
        super(position);
    }

    public Annotation getTitleLabel() {
        return this.titleLabel;
    }

    public Annotation getPositionLabel() {
        return this.positionLabel;
    }

    public ImageAnnotation getImageAnnotation() {
        return this.imageAnnotation;
    }

    public ButtonAnnotation getPlayButton() {
        return this.playButton;
    }

    public ButtonAnnotation getPreviousButton() {
        return this.previousButton;
    }

    public ButtonAnnotation getNextButton() {
        return this.nextButton;
    }

    public ButtonAnnotation getBeginButton() {
        return this.beginButton;
    }

    public ButtonAnnotation getEndButton() {
        return this.endButton;
    }

    public ButtonAnnotation getSizeButton() {
        return this.sizeButton;
    }

    public void setPlayButtonState(String string) {
        if (string == "gov.nasa.worldwind.avkey.Play") {
            this.playButton.setImageSource(PLAY_IMAGE_PATH);
            this.playButton.setToolTipText(PLAY_TOOLTIP_TEXT);
        } else if (string == "gov.nasa.worldwind.avkey.Pause") {
            this.playButton.setImageSource(PAUSE_IMAGE_PATH);
            this.playButton.setToolTipText(PAUSE_TOOLTIP_TEXT);
        }
    }

    public void setSizeButtonState(String string) {
        if (string == INCREASE) {
            this.sizeButton.setImageSource(INCREASE_IMAGE_PATH);
            this.sizeButton.setToolTipText(INCREASE_TOOLTIP_TEXT);
        } else if (string == DECREASE) {
            this.sizeButton.setImageSource(DECREASE_IMAGE_PATH);
            this.sizeButton.setToolTipText(DECREASE_TOOLTIP_TEXT);
        }
    }

    @Override
    protected void initComponents() {
        super.initComponents();
        this.titleLabel = new ScreenAnnotation("", new Point());
        this.positionLabel = new ScreenAnnotation("", new Point());
        this.imageAnnotation = new ImageAnnotation();
        this.playButton = new ButtonAnnotation(PLAY_IMAGE_PATH, "gov/nasa/worldwindx/examples/images/16x16-button-depressed-mask.png");
        this.previousButton = new ButtonAnnotation(PREVIOUS_IMAGE_PATH, "gov/nasa/worldwindx/examples/images/16x16-button-depressed-mask.png");
        this.nextButton = new ButtonAnnotation(NEXT_IMAGE_PATH, "gov/nasa/worldwindx/examples/images/16x16-button-depressed-mask.png");
        this.beginButton = new ButtonAnnotation(BEGIN_IMAGE_PATH, "gov/nasa/worldwindx/examples/images/16x16-button-depressed-mask.png");
        this.endButton = new ButtonAnnotation(END_IMAGE_PATH, "gov/nasa/worldwindx/examples/images/16x16-button-depressed-mask.png");
        this.sizeButton = new ButtonAnnotation(INCREASE_IMAGE_PATH, "gov/nasa/worldwindx/examples/images/16x16-button-depressed-mask.png");
        this.getBusyImage().setImageSource(BUSY_IMAGE_PATH);
        this.setupTitle(this.titleLabel);
        this.setupPositionLabel(this.positionLabel);
        this.setupImage(this.imageAnnotation);
        this.playButton.setActionCommand("gov.nasa.worldwind.avkey.Play");
        this.previousButton.setActionCommand("gov.nasa.worldwind.avkey.Previous");
        this.nextButton.setActionCommand("gov.nasa.worldwind.avkey.Next");
        this.beginButton.setActionCommand("gov.nasa.worldwind.avkey.Begin");
        this.endButton.setActionCommand("gov.nasa.worldwind.avkey.End");
        this.sizeButton.setActionCommand("gov.nasa.worldwind.avkey.Resize");
        this.playButton.addActionListener(this);
        this.previousButton.addActionListener(this);
        this.nextButton.addActionListener(this);
        this.beginButton.addActionListener(this);
        this.endButton.addActionListener(this);
        this.sizeButton.addActionListener(this);
        this.playButton.setToolTipText(PLAY_TOOLTIP_TEXT);
        this.previousButton.setToolTipText(PREVIOUS_TOOLTIP_TEXT);
        this.nextButton.setToolTipText(NEXT_TOOLTIP_TEXT);
        this.beginButton.setToolTipText(BEGIN_TOOLTIP_TEXT);
        this.endButton.setToolTipText(END_TOOLTIP_TEXT);
        this.sizeButton.setToolTipText(INCREASE_TOOLTIP_TEXT);
    }

    @Override
    protected void layoutComponents() {
        super.layoutComponents();
        ScreenAnnotation screenAnnotation = new ScreenAnnotation("", new Point());
        this.setupContainer((Annotation)screenAnnotation);
        screenAnnotation.setLayout((AnnotationLayoutManager)new AnnotationFlowLayout("gov.nasa.worldwind.avkey.Horizontal", "gov.nasa.worldwind.avkey.Center", 6, 0));
        screenAnnotation.addChild((Annotation)this.beginButton);
        screenAnnotation.addChild((Annotation)this.previousButton);
        screenAnnotation.addChild((Annotation)this.playButton);
        screenAnnotation.addChild((Annotation)this.nextButton);
        screenAnnotation.addChild((Annotation)this.endButton);
        ScreenAnnotation screenAnnotation2 = new ScreenAnnotation("", new Point());
        this.setupContainer((Annotation)screenAnnotation2);
        screenAnnotation2.setLayout((AnnotationLayoutManager)new AnnotationFlowLayout("gov.nasa.worldwind.avkey.Vertical", "gov.nasa.worldwind.avkey.Center", 0, 16));
        screenAnnotation2.addChild(this.titleLabel);
        screenAnnotation2.addChild((Annotation)this.imageAnnotation);
        screenAnnotation2.addChild((Annotation)screenAnnotation);
        AnnotationNullLayout annotationNullLayout = (AnnotationNullLayout)this.getLayout();
        this.addChild((Annotation)screenAnnotation2);
        this.addChild(this.positionLabel);
        this.addChild((Annotation)this.sizeButton);
        this.removeChild((Annotation)this.getBusyImage());
        this.addChild((Annotation)this.getBusyImage());
        annotationNullLayout.setConstraint(this.positionLabel, (Object)"gov.nasa.worldwind.layers.ViewControlsLayer.SouthWest");
        annotationNullLayout.setConstraint((Annotation)this.sizeButton, (Object)"gov.nasa.worldwind.layers.ViewControlsLayer.SouthEast");
        annotationNullLayout.setConstraint((Annotation)this.getBusyImage(), (Object)"gov.nasa.worldwind.avkey.Center");
    }

    protected void setupTitle(Annotation annotation) {
        this.setupLabel(annotation);
        AnnotationAttributes annotationAttributes = annotation.getAttributes();
        annotationAttributes.setFont(Font.decode("Arial-BOLD-14"));
        annotationAttributes.setSize(new Dimension(260, 0));
        annotationAttributes.setTextAlign("gov.nasa.worldwind.avkey.Center");
    }

    protected void setupPositionLabel(Annotation annotation) {
        this.setupLabel(annotation);
        AnnotationAttributes annotationAttributes = annotation.getAttributes();
        annotationAttributes.setFont(Font.decode("Arial-BOLD-12"));
    }

    protected void setupImage(ImageAnnotation imageAnnotation) {
        AnnotationAttributes annotationAttributes = imageAnnotation.getAttributes();
        annotationAttributes.setBorderWidth(2.0);
        annotationAttributes.setBorderColor(new Color(60, 60, 60));
        imageAnnotation.setFitSizeToImage(false);
        imageAnnotation.setUseImageAspectRatio(true);
    }
}

