/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.util;

import gov.nasa.worldwind.Disposable;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.layers.AnnotationLayer;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.render.Annotation;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import gov.nasa.worldwindx.examples.util.ToolTipAnnotation;

public class ToolTipController
implements SelectListener,
Disposable {
    protected WorldWindow wwd;
    protected String hoverKey = "gov.nasa.worldwind.avkey.HoverText";
    protected String rolloverKey = "gov.nasa.worldwind.avkey.RolloverText";
    protected Object lastRolloverObject;
    protected Object lastHoverObject;
    protected AnnotationLayer layer;
    protected ToolTipAnnotation annotation;

    public ToolTipController(WorldWindow worldWindow, String string, String string2) {
        this.wwd = worldWindow;
        this.hoverKey = string2;
        this.rolloverKey = string;
        this.wwd.addSelectListener((SelectListener)this);
    }

    public ToolTipController(WorldWindow worldWindow) {
        this.wwd = worldWindow;
        this.rolloverKey = "gov.nasa.worldwind.avkey.DisplayName";
        this.wwd.addSelectListener((SelectListener)this);
    }

    public void dispose() {
        this.wwd.removeSelectListener((SelectListener)this);
    }

    protected String getHoverText(SelectEvent selectEvent) {
        return selectEvent.getTopObject() != null && selectEvent.getTopObject() instanceof AVList ? ((AVList)selectEvent.getTopObject()).getStringValue(this.hoverKey) : null;
    }

    protected String getRolloverText(SelectEvent selectEvent) {
        return selectEvent.getTopObject() != null && selectEvent.getTopObject() instanceof AVList ? ((AVList)selectEvent.getTopObject()).getStringValue(this.rolloverKey) : null;
    }

    public void selected(SelectEvent selectEvent) {
        try {
            if (selectEvent.isRollover() && this.rolloverKey != null) {
                this.handleRollover(selectEvent);
            } else if (selectEvent.isHover() && this.hoverKey != null) {
                this.handleHover(selectEvent);
            }
        }
        catch (Exception exception) {
            Logging.logger().warning(exception.getMessage() != null ? exception.getMessage() : exception.toString());
        }
    }

    protected void handleRollover(SelectEvent selectEvent) {
        if (this.lastRolloverObject != null) {
            if (this.lastRolloverObject == selectEvent.getTopObject() && !WWUtil.isEmpty((Object)this.getRolloverText(selectEvent))) {
                return;
            }
            this.hideToolTip();
            this.lastRolloverObject = null;
            this.wwd.redraw();
        }
        if (this.getRolloverText(selectEvent) != null) {
            this.lastRolloverObject = selectEvent.getTopObject();
            this.showToolTip(selectEvent, this.getRolloverText(selectEvent).replace("\\n", "\n"));
            this.wwd.redraw();
        }
    }

    protected void handleHover(SelectEvent selectEvent) {
        if (this.lastHoverObject != null) {
            if (this.lastHoverObject == selectEvent.getTopObject()) {
                return;
            }
            this.hideToolTip();
            this.lastHoverObject = null;
            this.wwd.redraw();
        }
        if (this.getHoverText(selectEvent) != null) {
            this.lastHoverObject = selectEvent.getTopObject();
            this.showToolTip(selectEvent, this.getHoverText(selectEvent).replace("\\n", "\n"));
            this.wwd.redraw();
        }
    }

    protected void showToolTip(SelectEvent selectEvent, String string) {
        if (this.annotation != null) {
            this.annotation.setText(string);
            this.annotation.setScreenPoint(selectEvent.getPickPoint());
        } else {
            this.annotation = new ToolTipAnnotation(string);
        }
        if (this.layer == null) {
            this.layer = new AnnotationLayer();
            this.layer.setPickEnabled(false);
        }
        this.layer.removeAllAnnotations();
        this.layer.addAnnotation((Annotation)this.annotation);
        this.addLayer((Layer)this.layer);
    }

    protected void hideToolTip() {
        if (this.layer != null) {
            this.layer.removeAllAnnotations();
            this.removeLayer((Layer)this.layer);
            this.layer.dispose();
            this.layer = null;
        }
        if (this.annotation != null) {
            this.annotation.dispose();
            this.annotation = null;
        }
    }

    protected void addLayer(Layer layer) {
        if (!this.wwd.getModel().getLayers().contains((Object)layer)) {
            ApplicationTemplate.insertBeforeCompass(this.wwd, layer);
        }
    }

    protected void removeLayer(Layer layer) {
        this.wwd.getModel().getLayers().remove(layer);
    }
}

