/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.util;

import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.util.tree.BasicTree;
import gov.nasa.worldwind.util.tree.BasicTreeLayout;
import gov.nasa.worldwind.util.tree.BasicTreeModel;
import gov.nasa.worldwind.util.tree.BasicTreeNode;
import gov.nasa.worldwind.util.tree.Tree;
import gov.nasa.worldwind.util.tree.TreeLayout;
import gov.nasa.worldwind.util.tree.TreeModel;
import gov.nasa.worldwind.util.tree.TreeNode;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import gov.nasa.worldwindx.examples.util.HotSpotController;

public class TreeControl
extends ApplicationTemplate {
    private static final String ICON_PATH = "images/16x16-icon-nasa.png";

    public static void main(String[] stringArray) {
        ApplicationTemplate.start("Tree Control", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        HotSpotController controller;

        public AppFrame() {
            super(true, true, false);
            RenderableLayer renderableLayer = new RenderableLayer();
            BasicTree basicTree = new BasicTree();
            BasicTreeLayout basicTreeLayout = new BasicTreeLayout((Tree)basicTree, 100, 200);
            basicTreeLayout.getFrame().setFrameTitle("TreeControl");
            basicTree.setLayout((TreeLayout)basicTreeLayout);
            BasicTreeModel basicTreeModel = new BasicTreeModel();
            BasicTreeNode basicTreeNode = new BasicTreeNode("Root", (Object)TreeControl.ICON_PATH);
            basicTreeModel.setRoot((TreeNode)basicTreeNode);
            BasicTreeNode basicTreeNode2 = new BasicTreeNode("Child 1", (Object)TreeControl.ICON_PATH);
            basicTreeNode2.setDescription("This is a child node");
            basicTreeNode2.addChild((TreeNode)new BasicTreeNode("Subchild 1,1"));
            basicTreeNode2.addChild((TreeNode)new BasicTreeNode("Subchild 1,2"));
            basicTreeNode2.addChild((TreeNode)new BasicTreeNode("Subchild 1,3", (Object)TreeControl.ICON_PATH));
            basicTreeNode.addChild((TreeNode)basicTreeNode2);
            basicTreeNode2 = new BasicTreeNode("Child 2", (Object)TreeControl.ICON_PATH);
            basicTreeNode2.addChild((TreeNode)new BasicTreeNode("Subchild 2,1"));
            basicTreeNode2.addChild((TreeNode)new BasicTreeNode("Subchild 2,2"));
            basicTreeNode2.addChild((TreeNode)new BasicTreeNode("Subchild 2,3"));
            basicTreeNode.addChild((TreeNode)basicTreeNode2);
            basicTreeNode2 = new BasicTreeNode("Child 3");
            basicTreeNode2.addChild((TreeNode)new BasicTreeNode("Subchild 3,1"));
            basicTreeNode2.addChild((TreeNode)new BasicTreeNode("Subchild 3,2"));
            basicTreeNode2.addChild((TreeNode)new BasicTreeNode("Subchild 3,3"));
            basicTreeNode.addChild((TreeNode)basicTreeNode2);
            basicTree.setModel((TreeModel)basicTreeModel);
            basicTree.expandPath(basicTreeNode.getPath());
            this.controller = new HotSpotController(this.getWwd());
            renderableLayer.addRenderable((Renderable)basicTree);
            ApplicationTemplate.insertBeforeCompass(this.getWwd(), (Layer)renderableLayer);
            this.getLayerPanel().update(this.getWwd());
        }
    }
}

