/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.util;

import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.OrderedRenderable;
import gov.nasa.worldwind.util.OGLStackHandler;
import gov.nasa.worldwind.util.OGLUtil;
import java.awt.Point;
import java.awt.Rectangle;
import javax.media.opengl.GL2;

public class ViewVolumeRenderer {
    protected double size = 1.0;

    public double getSize() {
        return this.size;
    }

    public void setSize(double d) {
        this.size = d;
    }

    public void render(DrawContext drawContext, Matrix matrix, Matrix matrix2, Rectangle rectangle) {
        if (drawContext.isPickingMode()) {
            return;
        }
        drawContext.addOrderedRenderable((OrderedRenderable)new OrderedViewVolume(matrix, matrix2, rectangle));
    }

    protected void draw(DrawContext drawContext, Matrix matrix, Matrix matrix2, Rectangle rectangle) {
        this.drawClipVolume(drawContext, matrix, matrix2, rectangle);
        this.drawAxes(drawContext, matrix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawAxes(DrawContext drawContext, Matrix matrix) {
        Matrix matrix2 = matrix.getInverse();
        Vec4 vec4 = Vec4.UNIT_W.transformBy4(matrix2);
        Vec4 vec42 = vec4.add3(Vec4.UNIT_X.transformBy4(matrix2).multiply3(this.getSize()));
        Vec4 vec43 = vec4.add3(Vec4.UNIT_Y.transformBy4(matrix2).multiply3(this.getSize()));
        Vec4 vec44 = vec4.add3(Vec4.UNIT_Z.transformBy4(matrix2).multiply3(this.getSize()));
        GL2 gL2 = drawContext.getGL().getGL2();
        OGLStackHandler oGLStackHandler = new OGLStackHandler();
        oGLStackHandler.pushAttrib(gL2, 7);
        try {
            gL2.glEnable(3042);
            gL2.glLineWidth(1.0f);
            gL2.glPointSize(5.0f);
            OGLUtil.applyBlending((GL2)gL2, (boolean)false);
            gL2.glColor3ub((byte)-1, (byte)-1, (byte)-1);
            gL2.glBegin(0);
            gL2.glVertex3d(vec4.x, vec4.y, vec4.z);
            gL2.glEnd();
            gL2.glColor3ub((byte)-1, (byte)0, (byte)0);
            ViewVolumeRenderer.drawLine(drawContext, vec4, vec42);
            gL2.glColor3ub((byte)0, (byte)-1, (byte)0);
            ViewVolumeRenderer.drawLine(drawContext, vec4, vec43);
            gL2.glColor3ub((byte)0, (byte)0, (byte)-1);
            ViewVolumeRenderer.drawLine(drawContext, vec4, vec44);
        }
        finally {
            oGLStackHandler.pop(gL2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawClipVolume(DrawContext drawContext, Matrix matrix, Matrix matrix2, Rectangle rectangle) {
        GL2 gL2 = drawContext.getGL().getGL2();
        OGLStackHandler oGLStackHandler = new OGLStackHandler();
        oGLStackHandler.pushAttrib(gL2, 24837);
        try {
            gL2.glLineWidth(1.0f);
            gL2.glEnable(3042);
            OGLUtil.applyBlending((GL2)gL2, (boolean)false);
            ViewVolumeRenderer.drawVolume(drawContext, matrix, matrix2, rectangle);
        }
        finally {
            oGLStackHandler.pop(gL2);
        }
    }

    protected static void drawVolume(DrawContext drawContext, Matrix matrix, Matrix matrix2, Rectangle rectangle) {
        Vec4 vec4 = Vec4.UNIT_W.transformBy4(matrix.getInverse());
        Vec4 vec42 = ViewVolumeRenderer.worldPointFromScreenPoint(drawContext, rectangle, matrix, matrix2, new Vec4(0.0, 0.0, 0.0));
        Vec4 vec43 = ViewVolumeRenderer.worldPointFromScreenPoint(drawContext, rectangle, matrix, matrix2, new Vec4((double)rectangle.width, 0.0, 0.0));
        Vec4 vec44 = ViewVolumeRenderer.worldPointFromScreenPoint(drawContext, rectangle, matrix, matrix2, new Vec4((double)rectangle.width, (double)rectangle.height, 0.0));
        Vec4 vec45 = ViewVolumeRenderer.worldPointFromScreenPoint(drawContext, rectangle, matrix, matrix2, new Vec4(0.0, (double)rectangle.height, 0.0));
        Vec4 vec46 = ViewVolumeRenderer.worldPointFromScreenPoint(drawContext, rectangle, matrix, matrix2, new Vec4(0.0, 0.0, 1.0));
        Vec4 vec47 = ViewVolumeRenderer.worldPointFromScreenPoint(drawContext, rectangle, matrix, matrix2, new Vec4((double)rectangle.width, 0.0, 1.0));
        Vec4 vec48 = ViewVolumeRenderer.worldPointFromScreenPoint(drawContext, rectangle, matrix, matrix2, new Vec4((double)rectangle.width, (double)rectangle.height, 1.0));
        Vec4 vec49 = ViewVolumeRenderer.worldPointFromScreenPoint(drawContext, rectangle, matrix, matrix2, new Vec4(0.0, (double)rectangle.height, 1.0));
        GL2 gL2 = drawContext.getGL().getGL2();
        gL2.glColor4ub((byte)-1, (byte)-1, (byte)0, (byte)-128);
        ViewVolumeRenderer.drawQuad(drawContext, vec45, vec44, vec48, vec49);
        ViewVolumeRenderer.drawQuad(drawContext, vec46, vec42, vec45, vec49);
        ViewVolumeRenderer.drawQuad(drawContext, vec46, vec47, vec43, vec42);
        ViewVolumeRenderer.drawQuad(drawContext, vec43, vec47, vec48, vec44);
        ViewVolumeRenderer.drawQuad(drawContext, vec42, vec43, vec44, vec45);
        ViewVolumeRenderer.drawQuad(drawContext, vec46, vec47, vec48, vec49);
        gL2.glPushAttrib(256);
        gL2.glDepthFunc(516);
        gL2.glColor4ub((byte)-1, (byte)-1, (byte)0, (byte)51);
        ViewVolumeRenderer.drawQuad(drawContext, vec45, vec44, vec48, vec49);
        ViewVolumeRenderer.drawQuad(drawContext, vec46, vec42, vec45, vec49);
        ViewVolumeRenderer.drawQuad(drawContext, vec46, vec47, vec43, vec42);
        ViewVolumeRenderer.drawQuad(drawContext, vec43, vec47, vec48, vec44);
        ViewVolumeRenderer.drawQuad(drawContext, vec42, vec43, vec44, vec45);
        ViewVolumeRenderer.drawQuad(drawContext, vec46, vec47, vec48, vec49);
        gL2.glPopAttrib();
        gL2.glColor4ub((byte)-1, (byte)-1, (byte)-1, (byte)26);
        ViewVolumeRenderer.drawTriangle(drawContext, vec4, vec44, vec45);
        ViewVolumeRenderer.drawTriangle(drawContext, vec4, vec45, vec42);
        ViewVolumeRenderer.drawTriangle(drawContext, vec4, vec42, vec43);
        ViewVolumeRenderer.drawTriangle(drawContext, vec4, vec43, vec44);
        gL2.glColor3ub((byte)0, (byte)0, (byte)0);
        ViewVolumeRenderer.drawLine(drawContext, vec42, vec43);
        ViewVolumeRenderer.drawLine(drawContext, vec43, vec44);
        ViewVolumeRenderer.drawLine(drawContext, vec44, vec45);
        ViewVolumeRenderer.drawLine(drawContext, vec45, vec42);
        ViewVolumeRenderer.drawLine(drawContext, vec46, vec47);
        ViewVolumeRenderer.drawLine(drawContext, vec47, vec48);
        ViewVolumeRenderer.drawLine(drawContext, vec48, vec49);
        ViewVolumeRenderer.drawLine(drawContext, vec49, vec46);
        ViewVolumeRenderer.drawLine(drawContext, vec42, vec46);
        ViewVolumeRenderer.drawLine(drawContext, vec43, vec47);
        ViewVolumeRenderer.drawLine(drawContext, vec44, vec48);
        ViewVolumeRenderer.drawLine(drawContext, vec45, vec49);
        gL2.glColor3ub((byte)-128, (byte)-128, (byte)-128);
        ViewVolumeRenderer.drawLine(drawContext, vec4, vec42);
        ViewVolumeRenderer.drawLine(drawContext, vec4, vec43);
        ViewVolumeRenderer.drawLine(drawContext, vec4, vec44);
        ViewVolumeRenderer.drawLine(drawContext, vec4, vec45);
    }

    protected static void drawLine(DrawContext drawContext, Vec4 vec4, Vec4 vec42) {
        GL2 gL2 = drawContext.getGL().getGL2();
        gL2.glBegin(1);
        gL2.glVertex3d(vec4.x, vec4.y, vec4.z);
        gL2.glVertex3d(vec42.x, vec42.y, vec42.z);
        gL2.glEnd();
    }

    protected static void drawQuad(DrawContext drawContext, Vec4 vec4, Vec4 vec42, Vec4 vec43, Vec4 vec44) {
        GL2 gL2 = drawContext.getGL().getGL2();
        gL2.glBegin(7);
        gL2.glVertex3d(vec4.x, vec4.y, vec4.z);
        gL2.glVertex3d(vec42.x, vec42.y, vec42.z);
        gL2.glVertex3d(vec43.x, vec43.y, vec43.z);
        gL2.glVertex3d(vec44.x, vec44.y, vec44.z);
        gL2.glEnd();
    }

    protected static void drawTriangle(DrawContext drawContext, Vec4 vec4, Vec4 vec42, Vec4 vec43) {
        GL2 gL2 = drawContext.getGL().getGL2();
        gL2.glBegin(4);
        gL2.glVertex3d(vec4.x, vec4.y, vec4.z);
        gL2.glVertex3d(vec42.x, vec42.y, vec42.z);
        gL2.glVertex3d(vec43.x, vec43.y, vec43.z);
        gL2.glEnd();
    }

    protected static Vec4 worldPointFromScreenPoint(DrawContext drawContext, Rectangle rectangle, Matrix matrix, Matrix matrix2, Vec4 vec4) {
        double[] dArray = new double[16];
        double[] dArray2 = new double[16];
        matrix.toArray(dArray, 0, false);
        matrix2.toArray(dArray2, 0, false);
        int[] nArray = new int[]{rectangle.x, rectangle.y, rectangle.width, rectangle.height};
        double[] dArray3 = new double[3];
        if (!drawContext.getGLU().gluUnProject(vec4.x, vec4.y, vec4.z, dArray, 0, dArray2, 0, nArray, 0, dArray3, 0)) {
            return null;
        }
        return Vec4.fromArray3((double[])dArray3, (int)0);
    }

    protected class OrderedViewVolume
    implements OrderedRenderable {
        protected Matrix modelview;
        protected Matrix projection;
        protected Rectangle viewport;

        public OrderedViewVolume(Matrix matrix, Matrix matrix2, Rectangle rectangle) {
            this.modelview = matrix;
            this.projection = matrix2;
            this.viewport = new Rectangle(rectangle);
        }

        public double getDistanceFromEye() {
            return 0.0;
        }

        public void render(DrawContext drawContext) {
            ViewVolumeRenderer.this.draw(drawContext, this.modelview, this.projection, this.viewport);
        }

        public void pick(DrawContext drawContext, Point point) {
        }
    }
}

