/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.view;

import gov.nasa.worldwind.View;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.animation.Animator;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.poi.PointOfInterest;
import gov.nasa.worldwind.view.firstperson.BasicFlyView;
import gov.nasa.worldwind.view.firstperson.FlyToFlyViewAnimator;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import gov.nasa.worldwindx.examples.GazetteerPanel;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;

public class AddAnimator
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        ApplicationTemplate.start("World Wind View Animator", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        public BasicFlyView view;
        ViewDisplay viewDisplay;

        public AppFrame() {
            super(true, true, true);
            this.getLayerPanel().add((Component)this.makeControlPanel(), "South");
            WorldWindow worldWindow = this.getWwd();
            this.view = new BasicFlyView();
            worldWindow.setView((View)this.view);
        }

        private JPanel makeControlPanel() {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            jPanel.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(9, 9, 9, 9), new TitledBorder("View Controls")));
            jPanel.setToolTipText("Proved a location");
            this.viewDisplay = new ViewDisplay();
            jPanel.add(this.viewDisplay);
            return jPanel;
        }

        public class ViewDisplay
        extends JPanel {
            public ViewDisplay() {
                super(new GridLayout(0, 1));
                try {
                    this.add((Component)new FlyViewGazetteerPanel(AppFrame.this.getWwd(), "gov.nasa.worldwind.poi.YahooGazetteer"), 0);
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(this, "Error creating Gazetteer");
                }
            }

            public class FlyViewGazetteerPanel
            extends GazetteerPanel {
                FlyViewGazetteerPanel(WorldWindow worldWindow, String string) throws IllegalAccessException, InstantiationException, ClassNotFoundException {
                    super(worldWindow, string);
                }

                @Override
                public void moveToLocation(PointOfInterest pointOfInterest) {
                    if (pointOfInterest == null) {
                        return;
                    }
                    double d = AppFrame.this.view.getGlobe().getElevation(pointOfInterest.getLatlon().getLatitude(), pointOfInterest.getLatlon().getLongitude());
                    FlyToFlyViewAnimator flyToFlyViewAnimator = FlyToFlyViewAnimator.createFlyToFlyViewAnimator((BasicFlyView)AppFrame.this.view, (Position)AppFrame.this.view.getEyePosition(), (Position)new Position(pointOfInterest.getLatlon(), d), (Angle)AppFrame.this.view.getHeading(), (Angle)AppFrame.this.view.getHeading(), (Angle)AppFrame.this.view.getPitch(), (Angle)AppFrame.this.view.getPitch(), (double)AppFrame.this.view.getEyePosition().getElevation(), (double)AppFrame.this.view.getEyePosition().getElevation(), (long)10000L, (int)0);
                    AppFrame.this.view.addAnimator((Animator)flyToFlyViewAnimator);
                    flyToFlyViewAnimator.start();
                    AppFrame.this.view.firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, (Object)AppFrame.this.view);
                }
            }
        }
    }
}

