/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.view;

import gov.nasa.worldwind.View;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.awt.ViewInputHandler;
import gov.nasa.worldwind.event.PositionEvent;
import gov.nasa.worldwind.event.PositionListener;
import gov.nasa.worldwind.event.RenderingEvent;
import gov.nasa.worldwind.event.RenderingListener;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import gov.nasa.worldwindx.examples.GazetteerPanel;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;

public class ViewSwitch
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        ApplicationTemplate.start("World Wind Switch Views", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame
    implements ActionListener {
        ViewDisplay viewDisplay;

        public AppFrame() {
            super(true, true, true);
            this.getLayerPanel().add((Component)this.makeControlPanel(), "South");
            this.viewDisplay.setEventSource(this.getWwd());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
        }

        private JPanel makeControlPanel() {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            jPanel.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(9, 9, 9, 9), new TitledBorder("View Controls")));
            jPanel.setToolTipText("Select active view controls");
            this.viewDisplay = new ViewDisplay();
            jPanel.add(this.viewDisplay);
            return jPanel;
        }

        public class ViewDisplay
        extends JPanel
        implements PositionListener,
        RenderingListener,
        ActionListener {
            public static final String UNIT_METRIC = "gov.nasa.worldwind.StatusBar.Metric";
            public static final String UNIT_IMPERIAL = "gov.nasa.worldwind.StatusBar.Imperial";
            private static final double METER_TO_MILE = 6.21371192E-4;
            private WorldWindow eventSource;
            protected final JLabel latDisplay;
            protected final JLabel lonDisplay;
            protected final JLabel eleDisplay;
            protected final JLabel headingDisplay;
            protected final JLabel pitchDisplay;
            private String elevationUnit;
            private String angleFormat;
            public ViewerClassMap classNameList;
            public ViewerClass orbitViewer;
            public ViewerClass flyViewer;
            ViewerClass[] viewerClasses;
            String[] viewerNames;
            String currentName;
            DefaultComboBoxModel viewerClassNames;
            JComboBox viewList;
            ViewerClass currentViewer;

            public ViewDisplay() {
                super(new GridLayout(0, 1));
                this.latDisplay = new JLabel("");
                this.lonDisplay = new JLabel(Logging.getMessage((String)"term.OffGlobe"));
                this.eleDisplay = new JLabel("");
                this.headingDisplay = new JLabel("");
                this.pitchDisplay = new JLabel("");
                this.elevationUnit = UNIT_METRIC;
                this.angleFormat = "gov.nasa.worldwind.Geom.AngleDD";
                this.classNameList = new ViewerClassMap();
                this.orbitViewer = new ViewerClass("gov.nasa.worldwind.view.orbit.BasicOrbitView", "gov.nasa.worldwind.view.orbit.OrbitViewInputHandler");
                this.flyViewer = new ViewerClass("gov.nasa.worldwind.view.firstperson.BasicFlyView", "gov.nasa.worldwind.view.firstperson.FlyViewInputHandler");
                this.viewerClasses = new ViewerClass[]{this.flyViewer, this.orbitViewer};
                this.viewerNames = new String[]{"Fly", "Orbit"};
                this.currentViewer = null;
                for (int i = 0; i < 2; ++i) {
                    this.classNameList.put(this.viewerNames[i], this.viewerClasses[i]);
                }
                this.setViewer(this.viewerClasses[0], false);
                this.currentName = this.viewerNames[0];
                this.currentViewer = this.viewerClasses[0];
                this.viewerClassNames = new DefaultComboBoxModel();
                this.viewList = new JComboBox<String>(this.viewerNames);
                this.viewList.addActionListener(this);
                this.headingDisplay.setHorizontalAlignment(0);
                this.pitchDisplay.setHorizontalAlignment(0);
                this.latDisplay.setHorizontalAlignment(0);
                this.lonDisplay.setHorizontalAlignment(0);
                this.eleDisplay.setHorizontalAlignment(0);
                this.add(this.viewList);
                try {
                    this.add((Component)new GazetteerPanel(AppFrame.this.getWwd(), "gov.nasa.worldwind.poi.YahooGazetteer"), 0);
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(this, "Error creating Gazetteer");
                }
                this.add(this.latDisplay);
                this.add(this.lonDisplay);
                this.add(this.eleDisplay);
                this.add(this.headingDisplay);
                this.add(this.pitchDisplay);
            }

            public void setViewer(ViewerClass viewerClass, boolean bl) {
                if (viewerClass.view == null) {
                    viewerClass.view = (View)WorldWind.createComponent((String)viewerClass.viewClassName);
                    viewerClass.viewInputHandler = viewerClass.view.getViewInputHandler();
                }
                if (bl) {
                    View view = AppFrame.this.getWwd().getView();
                    try {
                        viewerClass.view.copyViewState(view);
                        AppFrame.this.getWwd().setView(viewerClass.view);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        JOptionPane.showMessageDialog(this, "Cannot switch to new view from this position/orientation");
                        this.viewList.setSelectedItem(this.currentName);
                    }
                } else {
                    AppFrame.this.getWwd().setView(viewerClass.view);
                }
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() == this.viewList) {
                    String string = (String)this.viewList.getSelectedItem();
                    ViewerClass viewerClass = (ViewerClass)this.classNameList.get(string);
                    this.setViewer(viewerClass, true);
                }
            }

            public void moved(PositionEvent positionEvent) {
            }

            public void setEventSource(WorldWindow worldWindow) {
                if (this.eventSource != null) {
                    this.eventSource.removePositionListener((PositionListener)this);
                    this.eventSource.removeRenderingListener((RenderingListener)this);
                }
                if (worldWindow != null) {
                    worldWindow.addPositionListener((PositionListener)this);
                    worldWindow.addRenderingListener((RenderingListener)this);
                }
                this.eventSource = worldWindow;
            }

            protected String makeEyeAltitudeDescription(double d) {
                String string = Logging.getMessage((String)"term.Altitude");
                String string2 = UNIT_IMPERIAL.equals(this.elevationUnit) ? String.format(string + " %,7d mi", (int)Math.round(d * 6.21371192E-4)) : String.format(string + " %,7d m", (int)Math.round(d));
                return string2;
            }

            protected String makeAngleDescription(String string, Angle angle) {
                String string2 = "gov.nasa.worldwind.Geom.AngleDMS".equals(this.angleFormat) ? String.format("%s %s", string, angle.toDMSString()) : String.format("%s %7.4f\u00b0", string, angle.degrees);
                return string2;
            }

            public void stageChanged(RenderingEvent renderingEvent) {
                if (!renderingEvent.getStage().equals("gov.nasa.worldwind.RenderingEvent.BeforeBufferSwap")) {
                    return;
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (ViewDisplay.this.eventSource.getView() != null && ViewDisplay.this.eventSource.getView().getEyePosition() != null) {
                            Position position = ViewDisplay.this.eventSource.getView().getEyePosition();
                            if (position != null) {
                                String string = ViewDisplay.this.makeAngleDescription("Lat", position.getLatitude());
                                String string2 = ViewDisplay.this.makeAngleDescription("Lon", position.getLongitude());
                                String string3 = ViewDisplay.this.makeAngleDescription("Heading", ViewDisplay.this.eventSource.getView().getHeading());
                                String string4 = ViewDisplay.this.makeAngleDescription("Pitch", ViewDisplay.this.eventSource.getView().getPitch());
                                ViewDisplay.this.latDisplay.setText(string);
                                ViewDisplay.this.lonDisplay.setText(string2);
                                ViewDisplay.this.eleDisplay.setText(ViewDisplay.this.makeEyeAltitudeDescription(position.getElevation()));
                                ViewDisplay.this.headingDisplay.setText(string3);
                                ViewDisplay.this.pitchDisplay.setText(string4);
                            } else {
                                ViewDisplay.this.latDisplay.setText("");
                                ViewDisplay.this.lonDisplay.setText(Logging.getMessage((String)"term.OffGlobe"));
                                ViewDisplay.this.eleDisplay.setText("");
                                ViewDisplay.this.pitchDisplay.setText("");
                                ViewDisplay.this.headingDisplay.setText("");
                            }
                        } else {
                            ViewDisplay.this.eleDisplay.setText(Logging.getMessage((String)"term.Altitude"));
                        }
                    }
                });
            }

            public class ViewerClassMap
            extends HashMap<String, ViewerClass> {
            }

            public class ViewerClass {
                protected String viewClassName;
                protected String inputHandlerClassName;
                protected View view;
                protected ViewInputHandler viewInputHandler;

                ViewerClass(String string, String string2) {
                    this.viewClassName = string;
                    this.inputHandlerClassName = string2;
                    this.view = null;
                    this.viewInputHandler = null;
                }
            }
        }
    }
}

