/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.performance;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Path;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import java.util.ArrayList;
import java.util.List;

public class VeryManyPaths
extends ApplicationTemplate {
    protected static final int NUM_PATHS = 2000;
    protected static final int NUM_POSITIONS = 300;
    protected static final Angle PATH_LENGTH = Angle.fromDegrees((double)5.0);
    protected static final double PATH_HEIGHT = 1000.0;
    protected static final LatLon START_LOCATION = LatLon.fromDegrees((double)48.86, (double)2.33);
    protected static final int ALTITUDE_MODE = 0;
    protected static final double LINE_WIDTH = 1.0;

    public static void main(String[] stringArray) {
        ApplicationTemplate.start("World Wind Paths", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        protected List<Path> paths;

        public AppFrame() {
            super(true, true, false);
            RenderableLayer renderableLayer = new RenderableLayer();
            this.makePaths(renderableLayer, new Position(START_LOCATION, 1000.0), 2000, PATH_LENGTH, 300);
            ApplicationTemplate.insertBeforeCompass(this.getWwd(), (Layer)renderableLayer);
            this.getWwd().getView().setEyePosition(new Position(START_LOCATION, 3000000.0));
            this.getLayerPanel().update(this.getWwd());
        }

        protected void makePaths(RenderableLayer renderableLayer, Position position, int n, Angle angle, int n2) {
            double d = 360.0 / (double)n;
            for (int i = 0; i < n; ++i) {
                Angle angle2 = Angle.fromDegrees((double)((double)i * d));
                renderableLayer.addRenderable((Renderable)this.makePath(position, angle2, angle, n2));
            }
            System.out.printf("%d paths, each with %d positions\n", 2000, 300);
        }

        protected Path makePath(Position position, Angle angle, Angle angle2, int n) {
            LatLon latLon;
            double d = angle2.radians / (double)(n - 1);
            ArrayList<Position> arrayList = new ArrayList<Position>(n);
            for (int i = 0; i < n - 1; ++i) {
                latLon = Position.greatCircleEndPosition((LatLon)position, (Angle)angle, (Angle)Angle.fromRadians((double)((double)i * d)));
                arrayList.add(new Position(latLon, 1000.0));
            }
            LatLon latLon2 = Position.greatCircleEndPosition((LatLon)position, (Angle)angle, (Angle)angle2);
            arrayList.add(new Position(latLon2, 1000.0));
            latLon = new Path(arrayList);
            latLon.setAltitudeMode(0);
            latLon.setExtrude(true);
            latLon.setDrawVerticals(true);
            BasicShapeAttributes basicShapeAttributes = new BasicShapeAttributes();
            basicShapeAttributes.setOutlineMaterial(new Material(WWUtil.makeRandomColor(null)));
            basicShapeAttributes.setInteriorMaterial(basicShapeAttributes.getOutlineMaterial());
            basicShapeAttributes.setInteriorOpacity(0.5);
            basicShapeAttributes.setDrawOutline(true);
            basicShapeAttributes.setDrawInterior(true);
            basicShapeAttributes.setOutlineWidth(1.0);
            latLon.setAttributes((ShapeAttributes)basicShapeAttributes);
            return latLon;
        }
    }
}

