/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.ncbi.ngs;

import gov.nih.nlm.ncbi.ngs.FileCreator;
import gov.nih.nlm.ncbi.ngs.HttpException;
import gov.nih.nlm.ncbi.ngs.HttpManager;
import gov.nih.nlm.ncbi.ngs.LMProperties;
import gov.nih.nlm.ncbi.ngs.LibManager;
import gov.nih.nlm.ncbi.ngs.Logger;
import gov.nih.nlm.ncbi.ngs.Version;

class DownloadManager {
    private LMProperties properties;

    DownloadManager(LMProperties lMProperties) {
        this.properties = lMProperties;
    }

    String getLatestVersion(String string) {
        String string2;
        Logger.finest(">> Checking the latest version of " + string + " library...");
        String string3 = "cmd=vers&libname=" + string;
        SratoolkitCgis sratoolkitCgis = new SratoolkitCgis(this.properties);
        while ((string2 = sratoolkitCgis.nextSpec()) != null) {
            try {
                String string4 = HttpManager.post(string2, string3);
                string4 = string4.trim();
                Logger.info("The latest version of " + string + " = " + string4);
                return string4;
            }
            catch (HttpException httpException) {
                Logger.finest(httpException);
            }
        }
        Logger.info("Cannot check the latest version of " + string);
        return null;
    }

    DownloadResult downloadLib(FileCreator fileCreator, String string, Version version) {
        String string2;
        String string3 = "cmd=lib&version=1.0&libname=" + string;
        try {
            string3 = string3 + "&" + this.osProperties();
        }
        catch (Exception exception) {
            Logger.warning("Cannot download library: " + exception.getMessage());
            return DownloadResult.FAILED;
        }
        SratoolkitCgis sratoolkitCgis = new SratoolkitCgis(this.properties);
        while ((string2 = sratoolkitCgis.nextSpec()) != null) {
            int n = HttpManager.post(string2, string3, fileCreator, string);
            if (n == 200) {
                return DownloadResult.SUCCESS;
            }
            if (n == 412) {
                Logger.warning("Cannot download library: " + n);
                return DownloadResult.UNSUPPORTED_OS;
            }
            Logger.warning("Cannot download library: " + n);
        }
        return DownloadResult.FAILED;
    }

    private String osProperties() throws Exception {
        String string;
        String string2 = "os_name=";
        String string3 = System.getProperty("os.name");
        if (string3 == null) {
            throw new Exception("Cannot detect OS");
        }
        string2 = string2 + string3 + "&bits=" + LibManager.detectJVM().intString();
        String string4 = System.getProperty("os.arch");
        if (string4 != null) {
            string2 = string2 + "&os_arch=" + string4;
        }
        if ((string = System.getProperty("os.version")) != null) {
            string2 = string2 + "&os_version=" + string;
        }
        return string2;
    }

    private static class SratoolkitCgis {
        private String spec;
        private boolean done;

        private SratoolkitCgis(LMProperties lMProperties) {
            this.spec = lMProperties.getProperty("/servers/sratookit-cgi");
            if (this.spec != null) {
                Logger.warning("Use " + this.spec + " from " + lMProperties.cfgFilePath());
            } else {
                this.spec = "http://trace.ncbi.nlm.nih.gov/Traces/sratoolkit/sratoolkit.cgi";
            }
            this.done = false;
        }

        private String nextSpec() {
            if (!this.done) {
                this.done = true;
                return this.spec;
            }
            return null;
        }
    }

    static enum DownloadResult {
        SUCCESS,
        FAILED,
        UNSUPPORTED_OS;

    }
}

