/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.ncbi.ngs;

import gov.nih.nlm.ncbi.ngs.LibManager;
import ngs.ErrorMsg;
import ngs.ReadCollection;
import ngs.ReferenceSequence;
import ngs.itf.ReadCollectionItf;
import ngs.itf.ReferenceSequenceItf;

class Manager {
    ExceptionInInitializerError invalid;

    void setAppVersionString(String string) {
        this.checkSelf();
        Manager.SetAppVersionString(string);
    }

    ReadCollection openReadCollection(String string) throws ErrorMsg {
        this.checkSelf();
        long l = Manager.OpenReadCollection(string);
        try {
            return new ReadCollectionItf(l);
        }
        catch (Exception exception) {
            Manager.release(l);
            throw new ErrorMsg(exception.toString());
        }
    }

    ReferenceSequence openReferenceSequence(String string) throws ErrorMsg {
        this.checkSelf();
        long l = Manager.OpenReferenceSequence(string);
        try {
            return new ReferenceSequenceItf(l);
        }
        catch (Exception exception) {
            Manager.release(l);
            throw new ErrorMsg(exception.toString());
        }
    }

    Manager() {
        try {
            LibManager libManager = new LibManager(new String[]{"ngs-sdk", "ncbi-vdb"}, new String[]{"1.2.4", "2.6.2"});
            libManager.loadLibrary("ngs-sdk");
            libManager.loadLibrary("ncbi-vdb");
            String string = Manager.Initialize();
            if (string != null) {
                throw new ExceptionInInitializerError(string);
            }
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    Manager.Shutdown();
                }
            });
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            this.invalid = exceptionInInitializerError;
        }
        catch (Throwable throwable) {
            this.invalid = new ExceptionInInitializerError(throwable);
        }
    }

    static String getPackageVersion() {
        try {
            return Manager.Version();
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    boolean isValid(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.checkSelf();
        return Manager.IsValid(string);
    }

    boolean isSupported() {
        return this.invalid == null;
    }

    private void checkSelf() {
        if (this.invalid != null) {
            throw this.invalid;
        }
    }

    private static native String Version();

    private static native String Initialize();

    private static native void Shutdown();

    private static native void SetAppVersionString(String var0);

    private static native long OpenReadCollection(String var0) throws ErrorMsg;

    private static native long OpenReferenceSequence(String var0) throws ErrorMsg;

    private static native boolean IsValid(String var0);

    private static native void release(long var0);
}

