/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.binding;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import gov.nist.secauto.metaschema.binding.IBindingContext;
import gov.nist.secauto.metaschema.binding.IMetaschemaLoaderStrategy;
import gov.nist.secauto.metaschema.binding.model.AbstractBoundMetaschema;
import gov.nist.secauto.metaschema.binding.model.AbstractClassBinding;
import gov.nist.secauto.metaschema.binding.model.DefaultAssemblyClassBinding;
import gov.nist.secauto.metaschema.binding.model.DefaultFieldClassBinding;
import gov.nist.secauto.metaschema.binding.model.IClassBinding;
import gov.nist.secauto.metaschema.binding.model.annotations.MetaschemaAssembly;
import gov.nist.secauto.metaschema.binding.model.annotations.MetaschemaField;
import gov.nist.secauto.metaschema.model.common.IMetaschema;
import gov.nist.secauto.metaschema.model.common.util.CollectionUtil;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import java.util.HashMap;
import java.util.Map;

class AbstractMetaschemaLoaderStrategy
implements IMetaschemaLoaderStrategy {
    @NonNull
    private final IBindingContext bindingContext;
    @NonNull
    private final Map<Class<?>, IMetaschema> metaschemasByClass = new HashMap();
    @NonNull
    private final Map<Class<?>, IClassBinding> classBindingsByClass = new HashMap();

    protected AbstractMetaschemaLoaderStrategy(@NonNull IBindingContext bindingContext) {
        this.bindingContext = bindingContext;
    }

    @NonNull
    public IBindingContext getBindingContext() {
        return this.bindingContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IMetaschema getMetaschemaInstanceByClass(@NonNull Class<? extends IMetaschema> clazz) {
        IMetaschema retval;
        AbstractMetaschemaLoaderStrategy abstractMetaschemaLoaderStrategy = this;
        synchronized (abstractMetaschemaLoaderStrategy) {
            retval = this.metaschemasByClass.get(clazz);
            if (retval == null) {
                retval = this.newMetaschema(clazz);
                this.metaschemasByClass.put(clazz, retval);
            }
        }
        return (IMetaschema)ObjectUtils.notNull((Object)retval);
    }

    @NonNull
    protected IMetaschema newMetaschema(@NonNull Class<? extends IMetaschema> clazz) {
        return AbstractBoundMetaschema.createInstance(clazz, this.getBindingContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IClassBinding getClassBinding(@NonNull Class<?> clazz) {
        IClassBinding retval;
        AbstractMetaschemaLoaderStrategy abstractMetaschemaLoaderStrategy = this;
        synchronized (abstractMetaschemaLoaderStrategy) {
            retval = this.classBindingsByClass.get(clazz);
            if (retval == null && (retval = this.newClassBinding(clazz)) != null) {
                this.classBindingsByClass.put(clazz, retval);
            }
        }
        return retval;
    }

    @Nullable
    protected IClassBinding newClassBinding(@NonNull Class<?> clazz) {
        AbstractClassBinding retval = null;
        if (clazz.isAnnotationPresent(MetaschemaAssembly.class)) {
            retval = DefaultAssemblyClassBinding.createInstance(clazz, this.getBindingContext());
        } else if (clazz.isAnnotationPresent(MetaschemaField.class)) {
            retval = DefaultFieldClassBinding.createInstance(clazz, this.getBindingContext());
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Class<?>, IClassBinding> getClassBindingsByClass() {
        AbstractMetaschemaLoaderStrategy abstractMetaschemaLoaderStrategy = this;
        synchronized (abstractMetaschemaLoaderStrategy) {
            return CollectionUtil.unmodifiableMap(this.classBindingsByClass);
        }
    }
}

