/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.binding;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.binding.ExternalConstraintsMetaschemaLoaderStrategy;
import gov.nist.secauto.metaschema.binding.IBindingContext;
import gov.nist.secauto.metaschema.binding.IBindingMatcher;
import gov.nist.secauto.metaschema.binding.IMetaschemaLoaderStrategy;
import gov.nist.secauto.metaschema.binding.SimpleMetaschemaLoaderStrategy;
import gov.nist.secauto.metaschema.binding.io.AbstractDeserializer;
import gov.nist.secauto.metaschema.binding.io.AbstractSerializer;
import gov.nist.secauto.metaschema.binding.io.BindingException;
import gov.nist.secauto.metaschema.binding.io.DefaultBoundLoader;
import gov.nist.secauto.metaschema.binding.io.Format;
import gov.nist.secauto.metaschema.binding.io.IBoundLoader;
import gov.nist.secauto.metaschema.binding.io.IDeserializer;
import gov.nist.secauto.metaschema.binding.io.ISerializer;
import gov.nist.secauto.metaschema.binding.io.json.DefaultJsonDeserializer;
import gov.nist.secauto.metaschema.binding.io.json.DefaultJsonSerializer;
import gov.nist.secauto.metaschema.binding.io.xml.DefaultXmlDeserializer;
import gov.nist.secauto.metaschema.binding.io.xml.DefaultXmlSerializer;
import gov.nist.secauto.metaschema.binding.io.yaml.DefaultYamlDeserializer;
import gov.nist.secauto.metaschema.binding.io.yaml.DefaultYamlSerializer;
import gov.nist.secauto.metaschema.binding.model.IAssemblyClassBinding;
import gov.nist.secauto.metaschema.binding.model.IClassBinding;
import gov.nist.secauto.metaschema.model.common.IDefinition;
import gov.nist.secauto.metaschema.model.common.IMetaschema;
import gov.nist.secauto.metaschema.model.common.constraint.IConstraintSet;
import gov.nist.secauto.metaschema.model.common.datatype.DataTypeService;
import gov.nist.secauto.metaschema.model.common.datatype.IDataTypeAdapter;
import gov.nist.secauto.metaschema.model.common.metapath.item.DefaultNodeItemFactory;
import gov.nist.secauto.metaschema.model.common.metapath.item.INodeItem;
import gov.nist.secauto.metaschema.model.common.util.CollectionUtil;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import java.net.URI;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.xml.namespace.QName;

public class DefaultBindingContext
implements IBindingContext {
    private static DefaultBindingContext singleton;
    @NonNull
    private final IMetaschemaLoaderStrategy metaschemaLoaderStrategy;
    @NonNull
    private final List<IBindingMatcher> bindingMatchers = new LinkedList<IBindingMatcher>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static DefaultBindingContext instance() {
        Class<DefaultBindingContext> clazz = DefaultBindingContext.class;
        synchronized (DefaultBindingContext.class) {
            if (singleton == null) {
                singleton = new DefaultBindingContext();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return (DefaultBindingContext)ObjectUtils.notNull((Object)singleton);
        }
    }

    public DefaultBindingContext(@NonNull Set<IConstraintSet> externalConstraintSets) {
        this.metaschemaLoaderStrategy = new ExternalConstraintsMetaschemaLoaderStrategy(this, externalConstraintSets);
    }

    protected DefaultBindingContext() {
        this.metaschemaLoaderStrategy = new SimpleMetaschemaLoaderStrategy(this);
    }

    @Override
    public IMetaschema getMetaschemaInstanceByClass(@NonNull Class<? extends IMetaschema> clazz) {
        return this.metaschemaLoaderStrategy.getMetaschemaInstanceByClass(clazz);
    }

    @Override
    public IClassBinding getClassBinding(@NonNull Class<?> clazz) {
        return this.metaschemaLoaderStrategy.getClassBinding(clazz);
    }

    @Override
    public Map<Class<?>, IClassBinding> getClassBindingsByClass() {
        return this.metaschemaLoaderStrategy.getClassBindingsByClass();
    }

    @Override
    public <TYPE extends IDataTypeAdapter<?>> TYPE getJavaTypeAdapterInstance(@NonNull Class<TYPE> clazz) {
        return (TYPE)DataTypeService.getInstance().getJavaTypeAdapterByClass(clazz);
    }

    @Override
    public <CLASS> ISerializer<CLASS> newSerializer(@NonNull Format format, @NonNull Class<CLASS> clazz) {
        AbstractSerializer retval;
        Objects.requireNonNull(format, "format");
        IAssemblyClassBinding classBinding = (IAssemblyClassBinding)this.getClassBinding(clazz);
        if (classBinding == null) {
            throw new IllegalStateException(String.format("Class '%s' is not bound", clazz.getClass().getName()));
        }
        switch (format) {
            case JSON: {
                retval = new DefaultJsonSerializer(this, classBinding);
                break;
            }
            case XML: {
                retval = new DefaultXmlSerializer(this, classBinding);
                break;
            }
            case YAML: {
                retval = new DefaultYamlSerializer(this, classBinding);
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unsupported format '%s'", new Object[]{format}));
            }
        }
        return retval;
    }

    @Override
    public <CLASS> IDeserializer<CLASS> newDeserializer(@NonNull Format format, @NonNull Class<CLASS> clazz) {
        AbstractDeserializer retval;
        IAssemblyClassBinding classBinding = (IAssemblyClassBinding)this.getClassBinding(clazz);
        if (classBinding == null) {
            throw new IllegalStateException(String.format("Class '%s' is not bound", clazz.getClass().getName()));
        }
        switch (format) {
            case JSON: {
                retval = new DefaultJsonDeserializer(this, classBinding);
                break;
            }
            case XML: {
                retval = new DefaultXmlDeserializer(this, classBinding);
                break;
            }
            case YAML: {
                retval = new DefaultYamlDeserializer(this, classBinding);
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unsupported format '%s'", new Object[]{format}));
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerBindingMatcher(@NonNull IBindingMatcher matcher) {
        DefaultBindingContext defaultBindingContext = this;
        synchronized (defaultBindingContext) {
            this.bindingMatchers.add(matcher);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    protected List<? extends IBindingMatcher> getBindingMatchers() {
        DefaultBindingContext defaultBindingContext = this;
        synchronized (defaultBindingContext) {
            return CollectionUtil.unmodifiableList(this.bindingMatchers);
        }
    }

    @Override
    public Class<?> getBoundClassForXmlQName(@NonNull QName rootQName) {
        IBindingMatcher matcher;
        Class<?> retval = null;
        Iterator<? extends IBindingMatcher> iterator = this.getBindingMatchers().iterator();
        while (iterator.hasNext() && (retval = (matcher = iterator.next()).getBoundClassForXmlQName(rootQName)) == null) {
        }
        return retval;
    }

    @Override
    public Class<?> getBoundClassForJsonName(@NonNull String rootName) {
        IBindingMatcher matcher;
        Class<?> retval = null;
        Iterator<? extends IBindingMatcher> iterator = this.getBindingMatchers().iterator();
        while (iterator.hasNext() && (retval = (matcher = iterator.next()).getBoundClassForJsonName(rootName)) == null) {
        }
        return retval;
    }

    @Override
    public IBoundLoader newBoundLoader() {
        return new DefaultBoundLoader(this);
    }

    @Override
    public <CLASS> CLASS copyBoundObject(@NonNull CLASS other, Object parentInstance) throws BindingException {
        IClassBinding classBinding = this.getClassBinding(other.getClass());
        if (classBinding == null) {
            throw new IllegalStateException(String.format("Class '%s' is not bound", other.getClass().getName()));
        }
        Object retval = classBinding.copyBoundObject(other, parentInstance);
        return (CLASS)retval;
    }

    @Override
    public INodeItem toNodeItem(@NonNull Object boundObject, URI baseUri, boolean rootNode) {
        IClassBinding classBinding = this.getClassBinding(boundObject.getClass());
        if (classBinding == null) {
            throw new IllegalStateException(String.format("Class '%s' is not bound", boundObject.getClass().getName()));
        }
        return DefaultNodeItemFactory.instance().newNodeItem((IDefinition)classBinding, boundObject, baseUri, rootNode);
    }
}

