/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.binding;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.binding.AbstractMetaschemaLoaderStrategy;
import gov.nist.secauto.metaschema.binding.IBindingContext;
import gov.nist.secauto.metaschema.binding.model.IClassBinding;
import gov.nist.secauto.metaschema.model.common.IMetaschema;
import gov.nist.secauto.metaschema.model.common.MetaschemaException;
import gov.nist.secauto.metaschema.model.common.constraint.IConstraintSet;
import java.util.HashSet;
import java.util.Set;

class ExternalConstraintsMetaschemaLoaderStrategy
extends AbstractMetaschemaLoaderStrategy {
    @NonNull
    private final Set<IConstraintSet> externalConstraintSets;
    private final Set<IMetaschema> resolvedMetaschemas = new HashSet<IMetaschema>();

    protected ExternalConstraintsMetaschemaLoaderStrategy(@NonNull IBindingContext bindingContext, @NonNull Set<IConstraintSet> externalConstraintSets) {
        super(bindingContext);
        this.externalConstraintSets = externalConstraintSets;
    }

    @NonNull
    protected Set<IConstraintSet> getExternalConstraintSets() {
        return this.externalConstraintSets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IClassBinding getClassBinding(@NonNull Class<?> clazz) {
        IClassBinding retval = super.getClassBinding(clazz);
        if (retval != null) {
            IMetaschema metaschema = retval.getContainingMetaschema();
            Set<IMetaschema> set = this.resolvedMetaschemas;
            synchronized (set) {
                if (!this.resolvedMetaschemas.contains(metaschema)) {
                    this.resolvedMetaschemas.add(metaschema);
                    try {
                        IConstraintSet.applyConstraintSetToMetaschema(this.getExternalConstraintSets(), (IMetaschema)metaschema);
                    }
                    catch (MetaschemaException ex) {
                        throw new IllegalStateException(ex);
                    }
                }
            }
        }
        return retval;
    }
}

