/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.binding;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import gov.nist.secauto.metaschema.binding.DefaultBindingContext;
import gov.nist.secauto.metaschema.binding.IBindingMatcher;
import gov.nist.secauto.metaschema.binding.IMetaschemaLoaderStrategy;
import gov.nist.secauto.metaschema.binding.io.BindingException;
import gov.nist.secauto.metaschema.binding.io.DeserializationFeature;
import gov.nist.secauto.metaschema.binding.io.Format;
import gov.nist.secauto.metaschema.binding.io.IBoundLoader;
import gov.nist.secauto.metaschema.binding.io.IDeserializer;
import gov.nist.secauto.metaschema.binding.io.ISerializer;
import gov.nist.secauto.metaschema.binding.io.yaml.YamlOperations;
import gov.nist.secauto.metaschema.model.common.constraint.DefaultConstraintValidator;
import gov.nist.secauto.metaschema.model.common.constraint.FindingCollectingConstraintValidationHandler;
import gov.nist.secauto.metaschema.model.common.constraint.IConstraintValidationHandler;
import gov.nist.secauto.metaschema.model.common.constraint.IConstraintValidator;
import gov.nist.secauto.metaschema.model.common.datatype.IDataTypeAdapter;
import gov.nist.secauto.metaschema.model.common.metapath.DynamicContext;
import gov.nist.secauto.metaschema.model.common.metapath.IDocumentLoader;
import gov.nist.secauto.metaschema.model.common.metapath.StaticContext;
import gov.nist.secauto.metaschema.model.common.metapath.item.IDocumentNodeItem;
import gov.nist.secauto.metaschema.model.common.metapath.item.INodeItem;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import gov.nist.secauto.metaschema.model.common.validation.AggregateValidationResult;
import gov.nist.secauto.metaschema.model.common.validation.IValidationResult;
import gov.nist.secauto.metaschema.model.common.validation.JsonSchemaContentValidator;
import gov.nist.secauto.metaschema.model.common.validation.XmlSchemaContentValidator;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.json.JSONObject;
import org.xml.sax.SAXException;

public interface IBindingContext
extends IMetaschemaLoaderStrategy {
    @NonNull
    public static IBindingContext instance() {
        return DefaultBindingContext.instance();
    }

    public void registerBindingMatcher(@NonNull IBindingMatcher var1);

    @Nullable
    public Class<?> getBoundClassForXmlQName(@NonNull QName var1);

    @Nullable
    public Class<?> getBoundClassForJsonName(@NonNull String var1);

    @Nullable
    public <TYPE extends IDataTypeAdapter<?>> TYPE getJavaTypeAdapterInstance(@NonNull Class<TYPE> var1);

    @NonNull
    public <CLASS> ISerializer<CLASS> newSerializer(@NonNull Format var1, @NonNull Class<CLASS> var2);

    @NonNull
    public <CLASS> IDeserializer<CLASS> newDeserializer(@NonNull Format var1, @NonNull Class<CLASS> var2);

    @NonNull
    public IBoundLoader newBoundLoader();

    @NonNull
    public <CLASS> CLASS copyBoundObject(@NonNull CLASS var1, Object var2) throws BindingException;

    default public INodeItem toNodeItem(@NonNull Object boundObject, @NonNull URI baseUri) {
        return this.toNodeItem(boundObject, baseUri, false);
    }

    public INodeItem toNodeItem(@NonNull Object var1, @NonNull URI var2, boolean var3);

    default public IConstraintValidator newValidator(@NonNull IConstraintValidationHandler handler) {
        IBoundLoader loader = this.newBoundLoader();
        loader.disableFeature(DeserializationFeature.DESERIALIZE_VALIDATE_CONSTRAINTS);
        DynamicContext context = new StaticContext().newDynamicContext();
        context.setDocumentLoader((IDocumentLoader)loader);
        return new DefaultConstraintValidator(context, handler);
    }

    default public IValidationResult validate(@NonNull INodeItem nodeItem) {
        FindingCollectingConstraintValidationHandler handler = new FindingCollectingConstraintValidationHandler();
        IConstraintValidator validator = this.newValidator((IConstraintValidationHandler)handler);
        validator.validate(nodeItem);
        validator.finalizeValidation();
        return handler;
    }

    default public IValidationResult validate(@NonNull Path target, @NonNull Format asFormat, @NonNull IValidationSchemaProvider schemaProvider) throws IOException, SAXException {
        IValidationResult retval;
        switch (asFormat) {
            case JSON: {
                retval = new JsonSchemaContentValidator(schemaProvider.getJsonSchema()).validate(target);
                break;
            }
            case XML: {
                List<Source> schemaSources = schemaProvider.getXmlSchemas();
                retval = new XmlSchemaContentValidator(schemaSources).validate(target);
                break;
            }
            case YAML: {
                JSONObject json = YamlOperations.yamlToJson(YamlOperations.parseYaml(target));
                if (!1.$assertionsDisabled && json == null) {
                    throw new AssertionError();
                }
                retval = new JsonSchemaContentValidator(schemaProvider.getJsonSchema()).validate(json, (URI)ObjectUtils.notNull((Object)target.toUri()));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported format: " + asFormat.name());
            }
        }
        if (retval.isPassing()) {
            IValidationResult constraintValidationResult = this.validateWithConstraints(target);
            retval = AggregateValidationResult.aggregate((IValidationResult[])new IValidationResult[]{retval, constraintValidationResult});
        }
        return retval;
    }

    default public IValidationResult validateWithConstraints(@NonNull Path target) throws IOException {
        IBoundLoader loader = this.newBoundLoader();
        loader.disableFeature(DeserializationFeature.DESERIALIZE_VALIDATE_CONSTRAINTS);
        DynamicContext dynamicContext = new StaticContext().newDynamicContext();
        dynamicContext.setDocumentLoader((IDocumentLoader)loader);
        IDocumentNodeItem nodeItem = loader.loadAsNodeItem(target);
        return this.validate((INodeItem)nodeItem);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    public static interface IValidationSchemaProvider {
        @NonNull
        public JSONObject getJsonSchema() throws IOException;

        @NonNull
        public List<Source> getXmlSchemas() throws IOException;
    }
}

