/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.binding.io;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.binding.IBindingContext;
import gov.nist.secauto.metaschema.binding.io.AbstractSerializationBase;
import gov.nist.secauto.metaschema.binding.io.DeserializationFeature;
import gov.nist.secauto.metaschema.binding.io.IDeserializer;
import gov.nist.secauto.metaschema.binding.model.IAssemblyClassBinding;
import gov.nist.secauto.metaschema.model.common.configuration.IConfiguration;
import gov.nist.secauto.metaschema.model.common.configuration.IMutableConfiguration;
import gov.nist.secauto.metaschema.model.common.constraint.DefaultConstraintValidator;
import gov.nist.secauto.metaschema.model.common.constraint.IConstraintValidationHandler;
import gov.nist.secauto.metaschema.model.common.constraint.LoggingConstraintValidationHandler;
import gov.nist.secauto.metaschema.model.common.metapath.DynamicContext;
import gov.nist.secauto.metaschema.model.common.metapath.IDocumentLoader;
import gov.nist.secauto.metaschema.model.common.metapath.StaticContext;
import gov.nist.secauto.metaschema.model.common.metapath.item.INodeItem;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;

public abstract class AbstractDeserializer<CLASS>
extends AbstractSerializationBase<DeserializationFeature<?>>
implements IDeserializer<CLASS> {
    private IConstraintValidationHandler constraintValidationHandler;

    protected AbstractDeserializer(@NonNull IBindingContext bindingContext, @NonNull IAssemblyClassBinding classBinding) {
        super(bindingContext, classBinding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IConstraintValidationHandler getConstraintValidationHandler() {
        AbstractDeserializer abstractDeserializer = this;
        synchronized (abstractDeserializer) {
            if (this.constraintValidationHandler == null) {
                this.constraintValidationHandler = new LoggingConstraintValidationHandler();
            }
            return (IConstraintValidationHandler)ObjectUtils.notNull((Object)this.constraintValidationHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setConstraintValidationHandler(@NonNull IConstraintValidationHandler constraintValidationHandler) {
        AbstractDeserializer abstractDeserializer = this;
        synchronized (abstractDeserializer) {
            this.constraintValidationHandler = constraintValidationHandler;
        }
    }

    @Override
    public INodeItem deserializeToNodeItem(Reader reader, URI documentUri) throws IOException {
        INodeItem nodeItem;
        try {
            nodeItem = this.deserializeToNodeItemInternal(reader, documentUri);
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
        if (this.isValidating()) {
            StaticContext staticContext = new StaticContext();
            DynamicContext dynamicContext = staticContext.newDynamicContext();
            dynamicContext.setDocumentLoader((IDocumentLoader)this.getBindingContext().newBoundLoader());
            DefaultConstraintValidator validator = new DefaultConstraintValidator(dynamicContext, this.getConstraintValidationHandler());
            validator.validate(nodeItem);
            validator.finalizeValidation();
        }
        return nodeItem;
    }

    @NonNull
    protected abstract INodeItem deserializeToNodeItemInternal(@NonNull Reader var1, @NonNull URI var2) throws IOException;

    @Override
    public IDeserializer<CLASS> enableFeature(DeserializationFeature<?> feature) {
        return this.set(feature, (Object)true);
    }

    @Override
    public IDeserializer<CLASS> disableFeature(DeserializationFeature<?> feature) {
        return this.set(feature, (Object)false);
    }

    @Override
    public IDeserializer<CLASS> applyConfiguration(@NonNull IConfiguration<DeserializationFeature<?>> other) {
        IMutableConfiguration config = this.getConfiguration();
        config.applyConfiguration(other);
        this.configurationChanged(config);
        return this;
    }

    @Override
    public IDeserializer<CLASS> set(DeserializationFeature<?> feature, Object value) {
        IMutableConfiguration config = this.getConfiguration();
        config.set(feature, value);
        this.configurationChanged(config);
        return this;
    }
}

