/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.binding.io;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.binding.IBindingContext;
import gov.nist.secauto.metaschema.binding.model.IAssemblyClassBinding;
import gov.nist.secauto.metaschema.model.common.configuration.DefaultConfiguration;
import gov.nist.secauto.metaschema.model.common.configuration.IConfigurationFeature;
import gov.nist.secauto.metaschema.model.common.configuration.IMutableConfiguration;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import java.util.Map;

abstract class AbstractSerializationBase<T extends IConfigurationFeature<?>>
implements IMutableConfiguration<T> {
    @NonNull
    private final IBindingContext bindingContext;
    @NonNull
    private final IAssemblyClassBinding classBinding;
    @NonNull
    private final DefaultConfiguration<T> configuration;

    protected AbstractSerializationBase(@NonNull IBindingContext bindingContext, @NonNull IAssemblyClassBinding classBinding) {
        this.bindingContext = (IBindingContext)ObjectUtils.requireNonNull((Object)bindingContext, (String)"bindingContext");
        this.classBinding = (IAssemblyClassBinding)ObjectUtils.requireNonNull((Object)classBinding, (String)"classBinding");
        this.configuration = new DefaultConfiguration();
    }

    @NonNull
    protected IBindingContext getBindingContext() {
        return this.bindingContext;
    }

    @NonNull
    protected IAssemblyClassBinding getClassBinding() {
        return this.classBinding;
    }

    protected void configurationChanged(@NonNull IMutableConfiguration<T> config) {
    }

    @NonNull
    protected IMutableConfiguration<T> getConfiguration() {
        return this.configuration;
    }

    public boolean isFeatureEnabled(T feature) {
        return this.configuration.isFeatureEnabled(feature);
    }

    public Map<T, Object> getFeatureValues() {
        return this.configuration.getFeatureValues();
    }

    public <V> V get(T feature) {
        return (V)this.configuration.get(feature);
    }
}

