/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.binding.io;

import com.ctc.wstx.stax.WstxInputFactory;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.format.DataFormatDetector;
import com.fasterxml.jackson.core.format.DataFormatMatcher;
import com.fasterxml.jackson.core.format.MatchStrength;
import com.fasterxml.jackson.dataformat.xml.XmlFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import gov.nist.secauto.metaschema.binding.IBindingContext;
import gov.nist.secauto.metaschema.binding.io.DeserializationFeature;
import gov.nist.secauto.metaschema.binding.io.Format;
import gov.nist.secauto.metaschema.binding.io.IBoundLoader;
import gov.nist.secauto.metaschema.binding.io.IDeserializer;
import gov.nist.secauto.metaschema.binding.io.json.JsonFactoryFactory;
import gov.nist.secauto.metaschema.binding.io.json.JsonUtil;
import gov.nist.secauto.metaschema.binding.io.yaml.YamlFactoryFactory;
import gov.nist.secauto.metaschema.model.common.configuration.DefaultConfiguration;
import gov.nist.secauto.metaschema.model.common.configuration.IConfiguration;
import gov.nist.secauto.metaschema.model.common.configuration.IMutableConfiguration;
import gov.nist.secauto.metaschema.model.common.metapath.item.IDocumentNodeItem;
import gov.nist.secauto.metaschema.model.common.metapath.item.INodeItem;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import org.codehaus.stax2.XMLEventReader2;
import org.codehaus.stax2.XMLInputFactory2;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class DefaultBoundLoader
implements IBoundLoader {
    public static final int LOOK_AHEAD_BYTES = 32768;
    private JsonFactory[] detectorFactory;
    @NonNull
    private final IBindingContext bindingContext;
    @NonNull
    private final IMutableConfiguration<DeserializationFeature<?>> configuration;
    @Nullable
    private EntityResolver entityResolver;

    public DefaultBoundLoader(@NonNull IBindingContext bindingContext) {
        this.bindingContext = bindingContext;
        this.configuration = new DefaultConfiguration();
    }

    @Override
    public IBoundLoader enableFeature(DeserializationFeature<?> feature) {
        return this.set(feature, (Object)true);
    }

    @Override
    public IBoundLoader disableFeature(DeserializationFeature<?> feature) {
        return this.set(feature, (Object)false);
    }

    public boolean isFeatureEnabled(DeserializationFeature<?> feature) {
        return this.getConfiguration().isFeatureEnabled(feature);
    }

    public Map<DeserializationFeature<?>, Object> getFeatureValues() {
        return this.getConfiguration().getFeatureValues();
    }

    @Override
    public IBoundLoader applyConfiguration(@NonNull IConfiguration<DeserializationFeature<?>> other) {
        this.getConfiguration().applyConfiguration(other);
        this.resetDetector();
        return this;
    }

    private void resetDetector() {
        this.detectorFactory = null;
    }

    @NonNull
    protected IMutableConfiguration<DeserializationFeature<?>> getConfiguration() {
        return this.configuration;
    }

    @Override
    public IBoundLoader set(DeserializationFeature<?> feature, Object value) {
        this.getConfiguration().set(feature, value);
        this.resetDetector();
        return this;
    }

    public <V> V get(DeserializationFeature<?> feature) {
        return (V)this.getConfiguration().get(feature);
    }

    @Override
    public IBindingContext getBindingContext() {
        return this.bindingContext;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public void setEntityResolver(@NonNull EntityResolver resolver) {
        this.entityResolver = resolver;
    }

    @Override
    public Format detectFormat(InputSource source) throws IOException {
        Format retval;
        if (source.getCharacterStream() != null) {
            throw new UnsupportedOperationException("Character streams are not supported");
        }
        if (source.getByteStream() != null) {
            retval = this.detectFormatInternal((InputStream)ObjectUtils.notNull((Object)source.getByteStream()));
        } else {
            URI uri = (URI)ObjectUtils.notNull((Object)URI.create(source.getSystemId()));
            URL url = uri.toURL();
            try (InputStream is = url.openStream();){
                retval = this.detectFormatInternal((InputStream)ObjectUtils.notNull((Object)is));
            }
        }
        return retval;
    }

    @NonNull
    protected Format detectFormatInternal(@NonNull InputStream is) throws IOException {
        return this.detectFormatInternal(is, Short.MAX_VALUE);
    }

    @NonNull
    protected Format detectFormatInternal(@NonNull InputStream is, int lookAheadBytes) throws IOException {
        DataFormatMatcher matcher = this.matchFormat(is, lookAheadBytes);
        return this.formatFromMatcher(matcher);
    }

    private JsonFactory[] getDetectorFactory() {
        if (this.detectorFactory == null) {
            this.detectorFactory = new JsonFactory[3];
            this.detectorFactory[0] = YamlFactoryFactory.newParserFactoryInstance(this.getConfiguration());
            this.detectorFactory[1] = JsonFactoryFactory.instance();
            this.detectorFactory[2] = new XmlFactory();
        }
        return this.detectorFactory;
    }

    @NonNull
    protected DataFormatMatcher matchFormat(@NonNull InputStream is, int lookAheadBytes) throws IOException {
        DataFormatDetector det = new DataFormatDetector(this.getDetectorFactory());
        det = det.withMinimalMatch(MatchStrength.INCONCLUSIVE).withOptimalMatch(MatchStrength.SOLID_MATCH).withMaxInputLookahead(lookAheadBytes);
        DataFormatMatcher matcher = det.findFormat(is);
        switch (matcher.getMatchStrength()) {
            case FULL_MATCH: 
            case SOLID_MATCH: 
            case WEAK_MATCH: 
            case INCONCLUSIVE: {
                return matcher;
            }
        }
        throw new UnsupportedOperationException("Unable to identify format");
    }

    @NonNull
    protected Format formatFromMatcher(@NonNull DataFormatMatcher matcher) {
        Format retval;
        String formatName = matcher.getMatchedFormatName();
        if ("YAML".equals(formatName)) {
            retval = Format.YAML;
        } else if ("JSON".equals(formatName)) {
            retval = Format.JSON;
        } else if ("XML".equals(formatName)) {
            retval = Format.XML;
        } else {
            throw new UnsupportedOperationException(String.format("The detected format '%s' is not supported", formatName));
        }
        return retval;
    }

    @NonNull
    private static BufferedInputStream toBufferedInputStream(@NonNull InputStream is) {
        BufferedInputStream bis = new BufferedInputStream(is, 32768);
        bis.mark(32768);
        return bis;
    }

    public IDocumentNodeItem loadAsNodeItem(InputSource source) throws IOException {
        IDocumentNodeItem retval;
        URI uri = (URI)ObjectUtils.notNull((Object)URI.create(source.getSystemId()));
        if (source.getByteStream() != null) {
            try (BufferedInputStream bis = DefaultBoundLoader.toBufferedInputStream((InputStream)ObjectUtils.notNull((Object)source.getByteStream()));){
                retval = this.loadAsNodeItemInternal(bis, uri);
            }
        }
        URL url = uri.toURL();
        try (InputStream is = url.openStream();
             BufferedInputStream bis = DefaultBoundLoader.toBufferedInputStream((InputStream)ObjectUtils.notNull((Object)is));){
            retval = this.loadAsNodeItemInternal(bis, uri);
        }
        return retval;
    }

    @Override
    public IDocumentNodeItem loadAsNodeItem(@NonNull Format format, @NonNull InputSource source) throws IOException {
        IDocumentNodeItem retval;
        URI uri = (URI)ObjectUtils.notNull((Object)URI.create(source.getSystemId()));
        if (source.getByteStream() != null) {
            try (BufferedInputStream bis = DefaultBoundLoader.toBufferedInputStream((InputStream)ObjectUtils.requireNonNull((Object)source.getByteStream()));){
                Class<?> clazz = this.detectModel(bis, format);
                retval = this.deserializeToNodeItem(clazz, format, bis, uri);
            }
        }
        URL url = uri.toURL();
        try (InputStream is = url.openStream();
             BufferedInputStream bis = DefaultBoundLoader.toBufferedInputStream((InputStream)ObjectUtils.notNull((Object)is));){
            Class<?> clazz = this.detectModel(bis, format);
            retval = this.deserializeToNodeItem(clazz, format, bis, uri);
        }
        return retval;
    }

    @NonNull
    protected IDocumentNodeItem loadAsNodeItemInternal(@NonNull BufferedInputStream bis, @NonNull URI documentUri) throws IOException {
        DataFormatMatcher matcher = this.matchFormat(bis, Short.MAX_VALUE);
        Format format = this.formatFromMatcher(matcher);
        Class<?> clazz = this.detectModel(matcher, format);
        return this.deserializeToNodeItem(clazz, format, bis, documentUri);
    }

    @NonNull
    protected IDocumentNodeItem deserializeToNodeItem(@NonNull Class<?> clazz, @NonNull Format format, @NonNull BufferedInputStream bis, @NonNull URI documentUri) throws IOException {
        try {
            bis.reset();
        }
        catch (IOException ex) {
            throw new IOException("Unable to reset input stream before parsing", ex);
        }
        IDeserializer<?> deserializer = this.getDeserializer((Class)clazz, format, (IConfiguration<DeserializationFeature<?>>)this.getConfiguration());
        return (IDocumentNodeItem)deserializer.deserializeToNodeItem(bis, documentUri);
    }

    @NonNull
    protected Class<?> detectModel(@NonNull BufferedInputStream bis, @NonNull Format format) throws IOException {
        Class<?> clazz;
        switch (format) {
            case JSON: {
                clazz = this.detectModelJsonClass((JsonParser)ObjectUtils.notNull((Object)JsonFactoryFactory.instance().createParser((InputStream)bis)));
                if (clazz != null) break;
                throw new IllegalStateException(String.format("Detected format '%s', but unable to detect the bound data type", format.name()));
            }
            case YAML: {
                YAMLFactory factory = YamlFactoryFactory.newParserFactoryInstance(this.getConfiguration());
                clazz = this.detectModelJsonClass((JsonParser)ObjectUtils.notNull((Object)factory.createParser((InputStream)bis)));
                if (clazz != null) break;
                throw new IllegalStateException(String.format("Detected format '%s', but unable to detect the bound data type", format.name()));
            }
            case XML: {
                clazz = this.detectModelXmlClass((InputStream)ObjectUtils.notNull((Object)bis));
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("The format '%s' is not supported", new Object[]{format}));
            }
        }
        try {
            bis.reset();
        }
        catch (IOException ex) {
            throw new IOException("Unable to reset input stream before parsing", ex);
        }
        return clazz;
    }

    @NonNull
    protected Class<?> detectModel(@NonNull DataFormatMatcher matcher, @NonNull Format format) throws IOException {
        Class<?> clazz;
        switch (format) {
            case JSON: 
            case YAML: {
                clazz = this.detectModelJsonClass((JsonParser)ObjectUtils.notNull((Object)matcher.createParserWithMatch()));
                if (clazz != null) break;
                throw new IllegalStateException(String.format("Detected format '%s', but unable to detect the bound data type", format.name()));
            }
            case XML: {
                clazz = this.detectModelXmlClass((InputStream)ObjectUtils.notNull((Object)matcher.getDataStream()));
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("The detected format '%s' is not supported", matcher.getMatchedFormatName()));
            }
        }
        return clazz;
    }

    @NonNull
    protected Class<?> detectModelXmlClass(@NonNull InputStream is) throws IOException {
        QName startElementQName;
        try {
            XMLInputFactory2 xmlInputFactory = (XMLInputFactory2)XMLInputFactory.newInstance();
            assert (xmlInputFactory instanceof WstxInputFactory);
            xmlInputFactory.configureForXmlConformance();
            xmlInputFactory.setProperty("javax.xml.stream.isCoalescing", (Object)false);
            InputStreamReader reader = new InputStreamReader(is, Charset.forName("UTF8"));
            XMLEventReader2 eventReader = (XMLEventReader2)xmlInputFactory.createXMLEventReader((Reader)reader);
            if (eventReader.peek().isStartDocument()) {
                while (eventReader.hasNext() && !eventReader.peek().isStartElement()) {
                    eventReader.nextEvent();
                }
            }
            if (!eventReader.peek().isStartElement()) {
                throw new UnsupportedOperationException("Unable to detect a start element");
            }
            StartElement start = eventReader.nextEvent().asStartElement();
            startElementQName = (QName)ObjectUtils.notNull((Object)start.getName());
        }
        catch (XMLStreamException ex) {
            throw new IOException(ex);
        }
        Class<?> clazz = this.getBoundClassForXmlQName(startElementQName);
        if (clazz == null) {
            throw new UnsupportedOperationException("Unrecognized element name: " + startElementQName.toString());
        }
        return clazz;
    }

    protected Class<?> getBoundClassForXmlQName(@NonNull QName rootQName) {
        return this.getBindingContext().getBoundClassForXmlQName(rootQName);
    }

    @Nullable
    protected Class<?> detectModelJsonClass(@NonNull JsonParser parser) throws IOException {
        Class<?> retval = null;
        JsonUtil.advanceAndAssert(parser, JsonToken.START_OBJECT);
        while (JsonToken.FIELD_NAME.equals((Object)parser.nextToken())) {
            String name = (String)ObjectUtils.notNull((Object)parser.getCurrentName());
            if ("$schema".equals(name)) {
                parser.nextToken();
                continue;
            }
            retval = this.getBoundClassForJsonName(name);
            break;
        }
        return retval;
    }

    protected Class<?> getBoundClassForJsonName(@NonNull String rootName) {
        return this.getBindingContext().getBoundClassForJsonName(rootName);
    }

    @Override
    public <CLASS> CLASS load(Class<CLASS> clazz, InputSource source) throws IOException {
        CLASS retval;
        URI uri = (URI)ObjectUtils.notNull((Object)URI.create(source.getSystemId()));
        if (source.getCharacterStream() != null) {
            throw new UnsupportedOperationException("Character streams are not supported");
        }
        if (source.getByteStream() != null) {
            try (BufferedInputStream bis = new BufferedInputStream(source.getByteStream(), 32768);){
                retval = this.loadInternal(clazz, bis, uri);
            }
        }
        URL url = uri.toURL();
        try (InputStream is = url.openStream();
             BufferedInputStream bis = new BufferedInputStream(is, 32768);){
            retval = this.loadInternal(clazz, bis, uri);
        }
        return retval;
    }

    @NonNull
    protected <CLASS> CLASS loadInternal(@NonNull Class<CLASS> clazz, @NonNull BufferedInputStream bis, @NonNull URI documentUri) throws IOException {
        bis.mark(32768);
        Format format = this.detectFormatInternal(bis);
        bis.reset();
        IDeserializer<CLASS> deserializer = this.getDeserializer(clazz, format, (IConfiguration<DeserializationFeature<?>>)this.getConfiguration());
        INodeItem nodeItem = deserializer.deserializeToNodeItem(bis, documentUri);
        return (CLASS)ObjectUtils.requireNonNull((Object)nodeItem.getValue());
    }

    @NonNull
    protected <CLASS> IDeserializer<CLASS> getDeserializer(@NonNull Class<CLASS> clazz, @NonNull Format format, @NonNull IConfiguration<DeserializationFeature<?>> config) {
        IDeserializer<CLASS> retval = this.getBindingContext().newDeserializer(format, clazz);
        retval.applyConfiguration((IConfiguration)config);
        return retval;
    }
}

