/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.binding.io;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;

public enum Format {
    XML(".xml"),
    JSON(".json"),
    YAML(".yml");

    private static final List<String> NAMES;
    @NonNull
    private final String defaultExtension;

    @SuppressFBWarnings(value={"MS_EXPOSE_REP"}, justification="Exposes names provided by the enum")
    public static List<String> names() {
        return NAMES;
    }

    private Format(String defaultExtension) {
        this.defaultExtension = defaultExtension;
    }

    @NonNull
    public String getDefaultExtension() {
        return this.defaultExtension;
    }

    static {
        NAMES = Arrays.stream(Format.values()).map(format -> format.name().toLowerCase(Locale.ROOT)).collect(Collectors.toUnmodifiableList());
    }
}

