/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.binding.io;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.binding.IBindingContext;
import gov.nist.secauto.metaschema.binding.io.DeserializationFeature;
import gov.nist.secauto.metaschema.binding.io.Format;
import gov.nist.secauto.metaschema.binding.io.ISerializer;
import gov.nist.secauto.metaschema.model.common.configuration.IConfiguration;
import gov.nist.secauto.metaschema.model.common.configuration.IMutableConfiguration;
import gov.nist.secauto.metaschema.model.common.metapath.IDocumentLoader;
import gov.nist.secauto.metaschema.model.common.metapath.item.IDocumentNodeItem;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.xml.sax.InputSource;

public interface IBoundLoader
extends IDocumentLoader,
IMutableConfiguration<DeserializationFeature<?>> {
    public IBoundLoader enableFeature(DeserializationFeature<?> var1);

    public IBoundLoader disableFeature(DeserializationFeature<?> var1);

    public IBoundLoader applyConfiguration(IConfiguration<DeserializationFeature<?>> var1);

    public IBoundLoader set(DeserializationFeature<?> var1, Object var2);

    @NonNull
    default public Format detectFormat(@NonNull URL url) throws IOException, URISyntaxException {
        return this.detectFormat(this.toInputSource((URI)ObjectUtils.notNull((Object)url.toURI())));
    }

    @NonNull
    default public Format detectFormat(@NonNull Path path) throws IOException {
        return this.detectFormat(this.toInputSource((URI)ObjectUtils.notNull((Object)path.toUri())));
    }

    @NonNull
    default public Format detectFormat(@NonNull File file) throws IOException {
        return this.detectFormat((Path)ObjectUtils.notNull((Object)file.toPath()));
    }

    @NonNull
    default public Format detectFormat(@NonNull InputStream is) throws IOException {
        return this.detectFormat(new InputSource(is));
    }

    @NonNull
    public Format detectFormat(@NonNull InputSource var1) throws IOException;

    @NonNull
    default public <CLASS> CLASS load(@NonNull URL url) throws IOException, URISyntaxException {
        return (CLASS)this.loadAsNodeItem(url).getValue();
    }

    @NonNull
    default public <CLASS> CLASS load(@NonNull Path path) throws IOException {
        return (CLASS)this.loadAsNodeItem(path).getValue();
    }

    @NonNull
    default public <CLASS> CLASS load(@NonNull File file) throws IOException {
        return (CLASS)this.loadAsNodeItem(file).getValue();
    }

    @NonNull
    default public <CLASS> CLASS load(@NonNull InputStream is, @NonNull URI documentUri) throws IOException {
        return (CLASS)this.loadAsNodeItem(is, documentUri).getValue();
    }

    @NonNull
    default public <CLASS> CLASS load(@NonNull InputSource source) throws IOException {
        return (CLASS)this.loadAsNodeItem(source).getValue();
    }

    @NonNull
    default public <CLASS> CLASS load(@NonNull Class<CLASS> clazz, @NonNull Path path) throws IOException {
        try {
            return this.load(clazz, (URI)ObjectUtils.notNull((Object)path.toUri()));
        }
        catch (URISyntaxException ex) {
            throw new IOException(ex);
        }
    }

    @NonNull
    default public <CLASS> CLASS load(@NonNull Class<CLASS> clazz, @NonNull File file) throws IOException {
        return this.load(clazz, (Path)ObjectUtils.notNull((Object)file.toPath()));
    }

    @NonNull
    default public <CLASS> CLASS load(@NonNull Class<CLASS> clazz, @NonNull URL url) throws IOException, URISyntaxException {
        return this.load(clazz, (URI)ObjectUtils.notNull((Object)url.toURI()));
    }

    @NonNull
    default public <CLASS> CLASS load(@NonNull Class<CLASS> clazz, @NonNull URI uri) throws IOException, URISyntaxException {
        return this.load(clazz, this.toInputSource((URI)ObjectUtils.requireNonNull((Object)uri)));
    }

    @NonNull
    public <CLASS> CLASS load(@NonNull Class<CLASS> var1, @NonNull InputSource var2) throws IOException;

    public IDocumentNodeItem loadAsNodeItem(@NonNull Format var1, @NonNull InputSource var2) throws IOException;

    public IBindingContext getBindingContext();

    default public <CLASS> void convert(@NonNull Path source, @NonNull Path destination, @NonNull Format toFormat, @NonNull Class<CLASS> rootClass) throws FileNotFoundException, IOException {
        CLASS object = this.load(rootClass, source);
        ISerializer<CLASS> serializer = this.getBindingContext().newSerializer(toFormat, rootClass);
        serializer.serialize(object, destination, new OpenOption[0]);
    }

    default public <CLASS> void convert(@NonNull Path source, @NonNull OutputStream os, @NonNull Format toFormat, @NonNull Class<CLASS> rootClass) throws FileNotFoundException, IOException {
        CLASS object = this.load(rootClass, source);
        ISerializer<CLASS> serializer = this.getBindingContext().newSerializer(toFormat, rootClass);
        serializer.serialize(object, os);
    }
}

