/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.binding.io;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.binding.io.DeserializationFeature;
import gov.nist.secauto.metaschema.model.common.configuration.IConfiguration;
import gov.nist.secauto.metaschema.model.common.configuration.IConfigurationFeature;
import gov.nist.secauto.metaschema.model.common.configuration.IMutableConfiguration;
import gov.nist.secauto.metaschema.model.common.constraint.IConstraintValidationHandler;
import gov.nist.secauto.metaschema.model.common.metapath.item.INodeItem;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;

public interface IDeserializer<CLASS>
extends IMutableConfiguration<DeserializationFeature<?>> {
    public IDeserializer<CLASS> enableFeature(DeserializationFeature<?> var1);

    public IDeserializer<CLASS> disableFeature(DeserializationFeature<?> var1);

    public IDeserializer<CLASS> applyConfiguration(IConfiguration<DeserializationFeature<?>> var1);

    public IDeserializer<CLASS> set(DeserializationFeature<?> var1, Object var2);

    default public boolean isValidating() {
        return this.isFeatureEnabled((IConfigurationFeature)DeserializationFeature.DESERIALIZE_VALIDATE_CONSTRAINTS);
    }

    @NonNull
    public IConstraintValidationHandler getConstraintValidationHandler();

    public void setConstraintValidationHandler(@NonNull IConstraintValidationHandler var1);

    @NonNull
    default public CLASS deserialize(@NonNull InputStream is, @NonNull URI documentUri) throws IOException {
        return this.deserialize(new InputStreamReader(is, StandardCharsets.UTF_8), documentUri);
    }

    @NonNull
    default public CLASS deserialize(@NonNull Path path) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(path, StandardCharsets.UTF_8);){
            CLASS CLASS = this.deserialize((Reader)ObjectUtils.notNull((Object)reader), (URI)ObjectUtils.notNull((Object)path.toUri()));
            return CLASS;
        }
    }

    @NonNull
    default public CLASS deserialize(@NonNull File file) throws IOException {
        return this.deserialize((Path)ObjectUtils.notNull((Object)file.toPath()));
    }

    @NonNull
    default public CLASS deserialize(@NonNull URL url) throws IOException, URISyntaxException {
        try (InputStream in = url.openStream();){
            CLASS CLASS = this.deserialize((InputStream)ObjectUtils.notNull((Object)in), (URI)ObjectUtils.notNull((Object)url.toURI()));
            return CLASS;
        }
    }

    @NonNull
    default public CLASS deserialize(@NonNull Reader reader, @NonNull URI documentUri) throws IOException {
        INodeItem nodeItem = this.deserializeToNodeItem(reader, documentUri);
        return (CLASS)ObjectUtils.requireNonNull((Object)nodeItem.getValue());
    }

    @NonNull
    default public INodeItem deserializeToNodeItem(@NonNull InputStream is, @NonNull URI documentUri) throws IOException {
        return this.deserializeToNodeItem(new InputStreamReader(is, StandardCharsets.UTF_8), documentUri);
    }

    @NonNull
    public INodeItem deserializeToNodeItem(@NonNull Reader var1, @NonNull URI var2) throws IOException;
}

