/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.binding.io.json;

import com.fasterxml.jackson.core.JsonGenerator;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import gov.nist.secauto.metaschema.binding.io.json.IJsonWritingContext;
import gov.nist.secauto.metaschema.binding.model.IBoundFieldValueInstance;
import gov.nist.secauto.metaschema.binding.model.IBoundFlagInstance;
import gov.nist.secauto.metaschema.binding.model.IFieldClassBinding;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class CollapseKeyBuilder {
    @NonNull
    private final IFieldClassBinding classBinding;
    @NonNull
    private final List<IBoundFlagInstance> flagProperties;
    @NonNull
    private final Map<CollapseKey, List<Object>> keyToValuesMap;

    public CollapseKeyBuilder(@NonNull IFieldClassBinding classBinding) {
        this.classBinding = classBinding;
        this.flagProperties = new ArrayList<IBoundFlagInstance>(classBinding.getFlagInstances());
        this.keyToValuesMap = new LinkedHashMap<CollapseKey, List<Object>>();
    }

    @NonNull
    protected IFieldClassBinding getClassBinding() {
        return this.classBinding;
    }

    @NonNull
    protected List<IBoundFlagInstance> getFlagProperties() {
        return this.flagProperties;
    }

    public void addAll(@NonNull Collection<? extends Object> instances) {
        for (Object object : instances) {
            this.add(ObjectUtils.notNull((Object)object));
        }
    }

    public void add(@NonNull Object instance) {
        int size = this.getFlagProperties().size();
        Object[] flagValues = new Object[size];
        int index = 0;
        for (IBoundFlagInstance flag : this.getFlagProperties()) {
            flagValues[index++] = flag.getValue(instance);
        }
        CollapseKey key = new CollapseKey(flagValues);
        List<Object> values = this.keyToValuesMap.get(key);
        if (values == null) {
            values = new LinkedList<Object>();
            this.keyToValuesMap.put(key, values);
        }
        Object value = this.getClassBinding().getFieldValueInstance().getValue(instance);
        values.add(value);
    }

    public void write(boolean writeObjectWrapper, @NonNull IJsonWritingContext context) throws IOException {
        List flagIndex;
        IFieldClassBinding classBinding = this.getClassBinding();
        IBoundFlagInstance jsonKey = classBinding.getJsonKeyFlagInstance();
        IBoundFlagInstance jsonValueKey = classBinding.getJsonValueKeyFlagInstance();
        IBoundFieldValueInstance fieldValue = classBinding.getFieldValueInstance();
        List<IBoundFlagInstance> flagProperties = this.getFlagProperties();
        Integer jsonKeyIndex = null;
        Integer jsonValueKeyIndex = null;
        if (flagProperties.isEmpty()) {
            flagIndex = Collections.emptyList();
        } else {
            flagIndex = new ArrayList(flagProperties.size());
            int index = 0;
            for (IBoundFlagInstance iBoundFlagInstance : flagProperties) {
                if (jsonKey != null && jsonKey.equals(iBoundFlagInstance)) {
                    jsonKeyIndex = index++;
                    continue;
                }
                if (jsonValueKey != null && jsonValueKey.equals(iBoundFlagInstance)) {
                    jsonValueKeyIndex = index++;
                    continue;
                }
                flagIndex.add(index++);
            }
        }
        JsonGenerator writer = (JsonGenerator)context.getWriter();
        for (Map.Entry entry : this.keyToValuesMap.entrySet()) {
            CollapseKey key = (CollapseKey)entry.getKey();
            Object[] flagValues = key.getFlagValues();
            if (writeObjectWrapper) {
                writer.writeStartObject();
            }
            if (jsonKey != null && jsonKeyIndex != null) {
                writer.writeFieldName(jsonKey.getValueAsString(flagValues[jsonKeyIndex]));
                writer.writeStartObject();
            }
            Iterator iterator = flagIndex.iterator();
            while (iterator.hasNext()) {
                int index = (Integer)iterator.next();
                IBoundFlagInstance flag = flagProperties.get(index);
                Object flagValue = flagValues[index];
                if (flagValue == null) continue;
                writer.writeFieldName(flag.getJsonName());
                flag.writeValue(flagValue, context);
            }
            List fieldValues = (List)entry.getValue();
            if (!fieldValues.isEmpty()) {
                String valueKeyName = jsonValueKey == null || jsonValueKeyIndex == null ? fieldValue.getJsonValueKeyName() : jsonValueKey.getValueAsString(flagValues[jsonValueKeyIndex]);
                writer.writeFieldName(valueKeyName);
                if (fieldValues.size() > 1) {
                    writer.writeStartArray();
                }
                for (Object value : fieldValues) {
                    fieldValue.writeValue(value, context);
                }
                if (fieldValues.size() > 1) {
                    writer.writeEndArray();
                }
            }
            if (jsonKey != null) {
                writer.writeEndObject();
            }
            if (!writeObjectWrapper) continue;
            writer.writeEndObject();
        }
    }

    public class CollapseKey {
        private final Object[] flagValues;
        private Integer cachedHashCode;

        @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="access is restricted")
        public CollapseKey(Object ... values) {
            this.flagValues = Arrays.copyOf(values, values.length);
        }

        protected Object[] getFlagValues() {
            return Arrays.copyOf(this.flagValues, this.flagValues.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int hashCode() {
            CollapseKey collapseKey = this;
            synchronized (collapseKey) {
                if (this.cachedHashCode == null) {
                    int prime = 31;
                    this.cachedHashCode = 1;
                    this.cachedHashCode = 31 * this.cachedHashCode + this.getEnclosingInstance().hashCode();
                    this.cachedHashCode = 31 * this.cachedHashCode + Arrays.hashCode(this.flagValues);
                }
                return this.cachedHashCode;
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof CollapseKey)) {
                return false;
            }
            CollapseKey other = (CollapseKey)obj;
            if (!this.getEnclosingInstance().equals(other.getEnclosingInstance())) {
                return false;
            }
            return Arrays.equals(this.flagValues, other.flagValues);
        }

        private CollapseKeyBuilder getEnclosingInstance() {
            return CollapseKeyBuilder.this;
        }
    }
}

