/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.binding.io.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.binding.IBindingContext;
import gov.nist.secauto.metaschema.binding.io.AbstractDeserializer;
import gov.nist.secauto.metaschema.binding.io.DeserializationFeature;
import gov.nist.secauto.metaschema.binding.io.json.DefaultJsonParsingContext;
import gov.nist.secauto.metaschema.binding.io.json.DefaultJsonProblemHandler;
import gov.nist.secauto.metaschema.binding.io.json.JsonFactoryFactory;
import gov.nist.secauto.metaschema.binding.model.IAssemblyClassBinding;
import gov.nist.secauto.metaschema.binding.model.RootAssemblyDefinition;
import gov.nist.secauto.metaschema.model.common.IAssemblyDefinition;
import gov.nist.secauto.metaschema.model.common.IRootAssemblyDefinition;
import gov.nist.secauto.metaschema.model.common.configuration.IMutableConfiguration;
import gov.nist.secauto.metaschema.model.common.metapath.item.DefaultNodeItemFactory;
import gov.nist.secauto.metaschema.model.common.metapath.item.IAssemblyNodeItem;
import gov.nist.secauto.metaschema.model.common.metapath.item.INodeItem;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;

public class DefaultJsonDeserializer<CLASS>
extends AbstractDeserializer<CLASS> {
    private JsonFactory jsonFactory;

    public DefaultJsonDeserializer(@NonNull IBindingContext bindingContext, @NonNull IAssemblyClassBinding classBinding) {
        super(bindingContext, classBinding);
    }

    @NonNull
    protected JsonFactory getJsonFactoryInstance() {
        return JsonFactoryFactory.instance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    protected JsonFactory getJsonFactory() {
        DefaultJsonDeserializer defaultJsonDeserializer = this;
        synchronized (defaultJsonDeserializer) {
            if (this.jsonFactory == null) {
                this.jsonFactory = this.getJsonFactoryInstance();
            }
            assert (this.jsonFactory != null);
            return this.jsonFactory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setJsonFactory(@NonNull JsonFactory jsonFactory) {
        DefaultJsonDeserializer defaultJsonDeserializer = this;
        synchronized (defaultJsonDeserializer) {
            this.jsonFactory = jsonFactory;
        }
    }

    @NonNull
    protected JsonParser newJsonParser(@NonNull Reader reader) throws IOException {
        return (JsonParser)ObjectUtils.notNull((Object)this.getJsonFactory().createParser(reader));
    }

    @Override
    protected INodeItem deserializeToNodeItemInternal(@NonNull Reader reader, @NonNull URI documentUri) throws IOException {
        try (JsonParser parser = this.newJsonParser(reader);){
            IAssemblyNodeItem retval;
            DefaultJsonParsingContext parsingContext = new DefaultJsonParsingContext(parser, new DefaultJsonProblemHandler());
            IAssemblyClassBinding classBinding = this.getClassBinding();
            IMutableConfiguration configuration = this.getConfiguration();
            if (classBinding.isRoot() && configuration.isFeatureEnabled(DeserializationFeature.DESERIALIZE_JSON_ROOT_PROPERTY)) {
                RootAssemblyDefinition root = new RootAssemblyDefinition(classBinding);
                Object value = ObjectUtils.requireNonNull((Object)root.readRoot(parsingContext));
                retval = DefaultNodeItemFactory.instance().newDocumentNodeItem((IRootAssemblyDefinition)root, value, documentUri);
            } else {
                Object value = ObjectUtils.requireNonNull((Object)classBinding.readObject(parsingContext));
                retval = DefaultNodeItemFactory.instance().newAssemblyNodeItem((IAssemblyDefinition)classBinding, value, documentUri);
            }
            IAssemblyNodeItem iAssemblyNodeItem = retval;
            return iAssemblyNodeItem;
        }
    }
}

