/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.binding.io.json;

import com.fasterxml.jackson.core.JsonParser;
import gov.nist.secauto.metaschema.binding.io.BindingException;
import gov.nist.secauto.metaschema.binding.io.json.IJsonParsingContext;
import gov.nist.secauto.metaschema.binding.io.json.IJsonProblemHandler;
import gov.nist.secauto.metaschema.binding.io.json.JsonUtil;
import gov.nist.secauto.metaschema.binding.model.IAssemblyClassBinding;
import gov.nist.secauto.metaschema.binding.model.IBoundNamedInstance;
import gov.nist.secauto.metaschema.binding.model.IClassBinding;
import gov.nist.secauto.metaschema.binding.model.IJsonBindingSupplier;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DefaultJsonProblemHandler
implements IJsonProblemHandler {
    private static final String JSON_SCHEMA_ROOT_FIELD_NAME = "$schema";
    private static final Set<String> IGNORED_ROOT_FIELD_NAMES = new HashSet<String>();

    @Override
    public boolean handleUnknownRootProperty(IAssemblyClassBinding classBinding, String fieldName, IJsonParsingContext context) throws IOException {
        boolean retval = false;
        if (IGNORED_ROOT_FIELD_NAMES.contains(fieldName)) {
            JsonParser parser = (JsonParser)context.getReader();
            JsonUtil.skipNextValue(parser);
            retval = true;
        }
        return retval;
    }

    @Override
    public boolean canHandleUnknownProperty(IClassBinding classBinding, String propertyName, IJsonParsingContext parsingContext) throws IOException {
        return false;
    }

    @Override
    public boolean handleUnknownProperty(IClassBinding classBinding, String propertyName, IJsonParsingContext parsingContext) throws IOException {
        return false;
    }

    @Override
    public Map<IBoundNamedInstance, IJsonBindingSupplier> handleMissingFields(IClassBinding classBinding, Map<String, IBoundNamedInstance> missingPropertyBindings, IJsonParsingContext context) throws BindingException {
        return Collections.emptyMap();
    }

    static {
        IGNORED_ROOT_FIELD_NAMES.add(JSON_SCHEMA_ROOT_FIELD_NAME);
    }
}

