/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.binding.io.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.binding.IBindingContext;
import gov.nist.secauto.metaschema.binding.io.AbstractSerializer;
import gov.nist.secauto.metaschema.binding.io.SerializationFeature;
import gov.nist.secauto.metaschema.binding.io.json.DefaultJsonWritingContext;
import gov.nist.secauto.metaschema.binding.io.json.JsonFactoryFactory;
import gov.nist.secauto.metaschema.binding.model.IAssemblyClassBinding;
import gov.nist.secauto.metaschema.binding.model.RootAssemblyDefinition;
import gov.nist.secauto.metaschema.model.common.configuration.IMutableConfiguration;
import java.io.IOException;
import java.io.Writer;

public class DefaultJsonSerializer<CLASS>
extends AbstractSerializer<CLASS> {
    private JsonFactory jsonFactory;

    public DefaultJsonSerializer(@NonNull IBindingContext bindingContext, @NonNull IAssemblyClassBinding classBinding) {
        super(bindingContext, classBinding);
    }

    @NonNull
    protected JsonFactory getJsonFactoryInstance() {
        return JsonFactoryFactory.instance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void configurationChanged(IMutableConfiguration<SerializationFeature<?>> config) {
        DefaultJsonSerializer defaultJsonSerializer = this;
        synchronized (defaultJsonSerializer) {
            this.jsonFactory = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    protected JsonFactory getJsonFactory() {
        DefaultJsonSerializer defaultJsonSerializer = this;
        synchronized (defaultJsonSerializer) {
            if (this.jsonFactory == null) {
                this.jsonFactory = this.getJsonFactoryInstance();
            }
            assert (this.jsonFactory != null);
            return this.jsonFactory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setJsonFactory(@NonNull JsonFactory jsonFactory) {
        DefaultJsonSerializer defaultJsonSerializer = this;
        synchronized (defaultJsonSerializer) {
            this.jsonFactory = jsonFactory;
        }
    }

    @NonNull
    protected JsonGenerator newJsonGenerator(@NonNull Writer writer) throws IOException {
        JsonFactory factory = this.getJsonFactory();
        JsonGenerator retval = factory.createGenerator(writer);
        retval.setPrettyPrinter((PrettyPrinter)new DefaultPrettyPrinter());
        return retval;
    }

    @Override
    public void serialize(CLASS data, Writer writer) throws IOException {
        try (JsonGenerator generator = this.newJsonGenerator(writer);){
            IAssemblyClassBinding classBinding = this.getClassBinding();
            DefaultJsonWritingContext writingContext = new DefaultJsonWritingContext(generator);
            RootAssemblyDefinition root = new RootAssemblyDefinition(classBinding);
            root.writeRoot(data, writingContext);
        }
    }
}

