/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.binding.io.json;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.binding.model.IBoundNamedInstance;
import gov.nist.secauto.metaschema.binding.model.IClassBinding;
import gov.nist.secauto.metaschema.model.common.util.CustomCollectors;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class JsonUtil {
    private static final Logger LOGGER = LogManager.getLogger(JsonUtil.class);

    private JsonUtil() {
    }

    public static String toString(@NonNull JsonParser parser) throws IOException {
        StringBuilder builder = new StringBuilder(32);
        builder.append(parser.currentToken().name()).append(" '").append(parser.getText()).append("' at location '").append(JsonUtil.toString((JsonLocation)ObjectUtils.notNull((Object)parser.getCurrentLocation()))).append('\'');
        return builder.toString();
    }

    public static String toString(@NonNull JsonLocation location) {
        StringBuilder builder = new StringBuilder();
        builder.append(location.getLineNr()).append(':').append(location.getColumnNr());
        return builder.toString();
    }

    public static JsonToken advanceTo(@NonNull JsonParser parser, JsonToken token) throws IOException {
        JsonToken currentToken = null;
        while (parser.hasCurrentToken() && !token.equals((Object)(currentToken = parser.currentToken()))) {
            currentToken = parser.nextToken();
            if (!LOGGER.isWarnEnabled()) continue;
            LOGGER.warn("skipping over: {}", (Object)JsonUtil.toString(parser));
        }
        return currentToken;
    }

    public static JsonToken skipNextValue(@NonNull JsonParser parser) throws IOException {
        JsonToken currentToken = parser.currentToken();
        if (JsonToken.FIELD_NAME.equals((Object)currentToken)) {
            currentToken = parser.nextToken();
        }
        switch (currentToken) {
            case START_ARRAY: 
            case START_OBJECT: {
                parser.skipChildren();
                break;
            }
            case VALUE_FALSE: 
            case VALUE_NULL: 
            case VALUE_NUMBER_FLOAT: 
            case VALUE_NUMBER_INT: 
            case VALUE_STRING: 
            case VALUE_TRUE: {
                break;
            }
            default: {
                String msg = String.format("Unhandled JsonToken %s", JsonUtil.toString(parser));
                LOGGER.error(msg);
                throw new UnsupportedOperationException(msg);
            }
        }
        return parser.nextToken();
    }

    public static boolean checkEndOfValue(@NonNull JsonParser parser, @NonNull JsonToken startToken) {
        boolean retval;
        JsonToken currentToken = parser.getCurrentToken();
        switch (startToken) {
            case START_OBJECT: {
                retval = JsonToken.END_OBJECT.equals((Object)currentToken);
                break;
            }
            case START_ARRAY: {
                retval = JsonToken.END_ARRAY.equals((Object)currentToken);
                break;
            }
            case VALUE_FALSE: 
            case VALUE_NULL: 
            case VALUE_NUMBER_FLOAT: 
            case VALUE_NUMBER_INT: 
            case VALUE_STRING: 
            case VALUE_TRUE: 
            case VALUE_EMBEDDED_OBJECT: {
                retval = true;
                break;
            }
            default: {
                retval = false;
            }
        }
        return retval;
    }

    public static void assertCurrent(@NonNull JsonParser parser, JsonToken ... expectedTokens) {
        JsonToken current = parser.currentToken();
        assert (Arrays.stream(expectedTokens).anyMatch(expected -> expected.equals((Object)current))) : JsonUtil.getAssertMessage(expectedTokens, parser.currentToken(), (JsonLocation)ObjectUtils.notNull((Object)parser.getCurrentLocation()));
    }

    public static void assertCurrentIsFieldValue(@NonNull JsonParser parser) {
        JsonToken token = parser.currentToken();
        assert (token.isStructStart() || token.isScalarValue()) : String.format("Expected a START_OBJECT, START_ARRAY, or VALUE_xxx token, but found JsonToken '%s' at '%s'.", token, JsonUtil.toString((JsonLocation)ObjectUtils.notNull((Object)parser.getCurrentLocation())));
    }

    public static JsonToken assertAndAdvance(@NonNull JsonParser parser, @NonNull JsonToken expectedToken) throws IOException {
        JsonToken token = parser.currentToken();
        assert (expectedToken.equals((Object)token)) : JsonUtil.getAssertMessage(expectedToken, token, (JsonLocation)ObjectUtils.notNull((Object)parser.getCurrentLocation()));
        return parser.nextToken();
    }

    public static JsonToken advanceAndAssert(@NonNull JsonParser parser, @NonNull JsonToken expectedToken) throws IOException {
        JsonToken token = parser.nextToken();
        assert (expectedToken.equals((Object)token)) : JsonUtil.getAssertMessage(expectedToken, token, (JsonLocation)ObjectUtils.notNull((Object)parser.getCurrentLocation()));
        return token;
    }

    @NonNull
    public static String getAssertMessage(@NonNull JsonToken expected, JsonToken actual, @NonNull JsonLocation location) {
        return (String)ObjectUtils.notNull((Object)String.format("Expected JsonToken '%s', but found JsonToken '%s' at '%s'.", expected, actual, JsonUtil.toString(location)));
    }

    @NonNull
    public static String getAssertMessage(@NonNull JsonToken[] expected, JsonToken actual, @NonNull JsonLocation location) {
        List expectedTokens = (List)ObjectUtils.notNull(Arrays.asList(expected));
        return JsonUtil.getAssertMessage(expectedTokens, actual, location);
    }

    @NonNull
    public static String getAssertMessage(@NonNull Collection<JsonToken> expected, JsonToken actual, @NonNull JsonLocation location) {
        return (String)ObjectUtils.notNull((Object)String.format("Expected JsonToken(s) '%s', but found JsonToken '%s' at '%s'.", expected.stream().map(token -> token.name()).collect(CustomCollectors.joiningWithOxfordComma((String)"and")), actual, JsonUtil.toString(location)));
    }

    @NonNull
    public static String toLocationContext(@NonNull JsonParser parser, @NonNull IClassBinding classBinding, IBoundNamedInstance property) {
        StringBuilder builder = new StringBuilder(64);
        builder.append("property '").append(property.getEffectiveName()).append("' on class '").append(classBinding.getBoundClass().getName()).append("' at location '");
        JsonLocation location = parser.getCurrentLocation();
        builder.append(location.getLineNr()).append(':').append(location.getColumnNr()).append('\'');
        return (String)ObjectUtils.notNull((Object)builder.toString());
    }
}

