/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.binding.io.xml;

import com.ctc.wstx.stax.WstxInputFactory;
import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.binding.IBindingContext;
import gov.nist.secauto.metaschema.binding.io.AbstractDeserializer;
import gov.nist.secauto.metaschema.binding.io.xml.CommentFilter;
import gov.nist.secauto.metaschema.binding.io.xml.DefaultXmlParsingContext;
import gov.nist.secauto.metaschema.binding.io.xml.DefaultXmlProblemHandler;
import gov.nist.secauto.metaschema.binding.model.IAssemblyClassBinding;
import gov.nist.secauto.metaschema.binding.model.RootAssemblyDefinition;
import gov.nist.secauto.metaschema.model.common.IRootAssemblyDefinition;
import gov.nist.secauto.metaschema.model.common.metapath.item.DefaultNodeItemFactory;
import gov.nist.secauto.metaschema.model.common.metapath.item.IDocumentNodeItem;
import gov.nist.secauto.metaschema.model.common.util.AutoCloser;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import javax.xml.stream.EventFilter;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.XMLEventReader2;
import org.codehaus.stax2.XMLInputFactory2;

public class DefaultXmlDeserializer<CLASS>
extends AbstractDeserializer<CLASS> {
    private XMLInputFactory2 xmlInputFactory;

    public DefaultXmlDeserializer(@NonNull IBindingContext bindingContext, @NonNull IAssemblyClassBinding classBinding) {
        super(bindingContext, classBinding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    protected XMLInputFactory2 getXMLInputFactory() {
        DefaultXmlDeserializer defaultXmlDeserializer = this;
        synchronized (defaultXmlDeserializer) {
            if (this.xmlInputFactory == null) {
                this.xmlInputFactory = (XMLInputFactory2)XMLInputFactory.newInstance();
                assert (this.xmlInputFactory instanceof WstxInputFactory);
                this.xmlInputFactory.configureForXmlConformance();
                this.xmlInputFactory.setProperty("javax.xml.stream.isCoalescing", (Object)false);
            }
            return (XMLInputFactory2)ObjectUtils.notNull((Object)this.xmlInputFactory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setXMLInputFactory(@NonNull XMLInputFactory2 factory) {
        DefaultXmlDeserializer defaultXmlDeserializer = this;
        synchronized (defaultXmlDeserializer) {
            this.xmlInputFactory = factory;
        }
    }

    @NonNull
    protected XMLEventReader2 newXMLEventReader2(@NonNull Reader reader) throws XMLStreamException {
        XMLEventReader eventReader = this.getXMLInputFactory().createXMLEventReader(reader);
        CommentFilter filter = new CommentFilter();
        return (XMLEventReader2)ObjectUtils.notNull((Object)((XMLEventReader2)this.getXMLInputFactory().createFilteredReader(eventReader, (EventFilter)filter)));
    }

    protected IDocumentNodeItem deserializeToNodeItemInternal(Reader reader, URI documentUri) throws IOException {
        IDocumentNodeItem iDocumentNodeItem;
        AutoCloser closer = new AutoCloser((Object)this.newXMLEventReader2(reader), event -> event.close());
        try {
            iDocumentNodeItem = this.parseXmlInternal((XMLEventReader2)closer.getResource(), documentUri);
        }
        catch (Throwable throwable) {
            try {
                try {
                    closer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (XMLStreamException ex) {
                throw new IOException("Unable to create a new XMLEventReader2 instance.", ex);
            }
        }
        closer.close();
        return iDocumentNodeItem;
    }

    @NonNull
    protected IDocumentNodeItem parseXmlInternal(@NonNull XMLEventReader2 reader, @NonNull URI documentUri) throws IOException, XMLStreamException {
        IAssemblyClassBinding classBinding = this.getClassBinding();
        if (!classBinding.isRoot()) {
            throw new IOException(String.format("The assembly '%s' is not a root assembly.", classBinding.getBoundClass().getName()));
        }
        DefaultXmlParsingContext parsingContext = new DefaultXmlParsingContext(reader, new DefaultXmlProblemHandler());
        RootAssemblyDefinition root = new RootAssemblyDefinition(classBinding);
        return DefaultNodeItemFactory.instance().newDocumentNodeItem((IRootAssemblyDefinition)root, root.readRoot(parsingContext), documentUri);
    }
}

