/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.binding.io.xml;

import com.ctc.wstx.stax.WstxOutputFactory;
import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.binding.IBindingContext;
import gov.nist.secauto.metaschema.binding.io.AbstractSerializer;
import gov.nist.secauto.metaschema.binding.io.xml.DefaultXmlWritingContext;
import gov.nist.secauto.metaschema.binding.model.IAssemblyClassBinding;
import gov.nist.secauto.metaschema.binding.model.RootAssemblyDefinition;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import java.io.IOException;
import java.io.Writer;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.XMLOutputFactory2;
import org.codehaus.stax2.XMLStreamWriter2;

public class DefaultXmlSerializer<CLASS>
extends AbstractSerializer<CLASS> {
    private XMLOutputFactory2 xmlOutputFactory;

    public DefaultXmlSerializer(@NonNull IBindingContext bindingContext, @NonNull IAssemblyClassBinding classBinding) {
        super(bindingContext, classBinding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    protected XMLOutputFactory2 getXMLOutputFactory() {
        DefaultXmlSerializer defaultXmlSerializer = this;
        synchronized (defaultXmlSerializer) {
            if (this.xmlOutputFactory == null) {
                this.xmlOutputFactory = (XMLOutputFactory2)XMLOutputFactory.newInstance();
                assert (this.xmlOutputFactory instanceof WstxOutputFactory);
                this.xmlOutputFactory.configureForSpeed();
                this.xmlOutputFactory.setProperty("com.ctc.wstx.useDoubleQuotesInXmlDecl", (Object)true);
                this.xmlOutputFactory.setProperty("javax.xml.stream.isRepairingNamespaces", (Object)true);
            }
            assert (this.xmlOutputFactory != null);
            return this.xmlOutputFactory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setXMLOutputFactory(@NonNull XMLOutputFactory2 xmlOutputFactory) {
        DefaultXmlSerializer defaultXmlSerializer = this;
        synchronized (defaultXmlSerializer) {
            this.xmlOutputFactory = xmlOutputFactory;
        }
    }

    @NonNull
    protected XMLStreamWriter2 newXMLStreamWriter(@NonNull Writer writer) throws IOException {
        try {
            return (XMLStreamWriter2)ObjectUtils.notNull((Object)((XMLStreamWriter2)this.getXMLOutputFactory().createXMLStreamWriter(writer)));
        }
        catch (XMLStreamException ex) {
            throw new IOException(ex);
        }
    }

    @Override
    public void serialize(CLASS data, Writer writer) throws IOException {
        XMLStreamWriter2 streamWriter = this.newXMLStreamWriter(writer);
        IOException caughtException = null;
        IAssemblyClassBinding classBinding = this.getClassBinding();
        DefaultXmlWritingContext writingContext = new DefaultXmlWritingContext(streamWriter);
        RootAssemblyDefinition root = new RootAssemblyDefinition(classBinding);
        try {
            root.writeRoot(data, writingContext);
            streamWriter.flush();
        }
        catch (XMLStreamException ex) {
            caughtException = new IOException(ex);
            throw caughtException;
        }
        finally {
            try {
                streamWriter.close();
            }
            catch (XMLStreamException ex) {
                if (caughtException == null) {
                    throw new IOException(ex);
                }
                caughtException.addSuppressed(ex);
                throw caughtException;
            }
        }
    }
}

