/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.binding.io.xml;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.XMLStreamWriter2;
import org.codehaus.stax2.util.StreamWriter2Delegate;

public class IndentingXmlStreamWriter2
extends StreamWriter2Delegate {
    private String indentText = "  ";
    private String lineEndText = "\n";
    private int depth;
    private final Map<Integer, Boolean> depthWithChildMap = new HashMap<Integer, Boolean>();
    private static final String DEFAULT_INDENT_TEXT = "  ";
    private static final String DEFAULT_LINE_END_TEXT = "\n";

    public IndentingXmlStreamWriter2(XMLStreamWriter2 parent) {
        super(parent);
    }

    protected String getIndentText() {
        return this.indentText;
    }

    protected void setIndentText(String indentText) {
        Objects.requireNonNull(indentText, "indentText");
        this.indentText = indentText;
    }

    protected String getLineEndText() {
        return this.lineEndText;
    }

    protected void setLineEndText(String lineEndText) {
        Objects.requireNonNull(lineEndText, "lineEndText");
        this.lineEndText = lineEndText;
    }

    protected void handleStartElement() throws XMLStreamException {
        if (this.depth > 0) {
            this.depthWithChildMap.put(this.depth - 1, true);
        }
        this.depthWithChildMap.put(this.depth, false);
        this.getParent().writeCharacters(this.getLineEndText());
        this.getParent().writeCharacters(this.getIndentText().repeat(this.depth));
        ++this.depth;
    }

    public void writeStartElement(String localName) throws XMLStreamException {
        this.handleStartElement();
        super.writeStartElement(localName);
    }

    public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        this.handleStartElement();
        super.writeStartElement(namespaceURI, localName);
    }

    public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.handleStartElement();
        super.writeStartElement(prefix, localName, namespaceURI);
    }

    protected void handleEndElement() throws XMLStreamException {
        --this.depth;
        if (this.depthWithChildMap.get(this.depth).booleanValue()) {
            this.getParent().writeCharacters(this.getLineEndText());
            this.getParent().writeCharacters(this.getIndentText().repeat(this.depth));
        }
    }

    public void writeEndElement() throws XMLStreamException {
        this.handleEndElement();
        super.writeEndElement();
    }

    public void writeFullEndElement() throws XMLStreamException {
        this.handleEndElement();
        super.writeFullEndElement();
    }

    protected void handleEmptyElement() throws XMLStreamException {
        if (this.depth > 0) {
            this.depthWithChildMap.put(this.depth - 1, true);
        }
        this.getParent().writeCharacters(this.getLineEndText());
        this.getParent().writeCharacters(this.getIndentText().repeat(this.depth));
    }

    public void writeEmptyElement(String localName) throws XMLStreamException {
        this.handleEmptyElement();
        super.writeEmptyElement(localName);
    }

    public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
        this.handleEmptyElement();
        super.writeEmptyElement(namespaceURI, localName);
    }

    public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.handleEmptyElement();
        super.writeEmptyElement(prefix, localName, namespaceURI);
    }
}

