/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.binding.io.yaml;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactoryBuilder;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.binding.io.DeserializationFeature;
import gov.nist.secauto.metaschema.binding.io.SerializationFeature;
import gov.nist.secauto.metaschema.binding.io.json.JsonFactoryFactory;
import gov.nist.secauto.metaschema.model.common.configuration.IMutableConfiguration;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import org.yaml.snakeyaml.LoaderOptions;

public final class YamlFactoryFactory {
    private YamlFactoryFactory() {
    }

    @NonNull
    public static YAMLFactory newParserFactoryInstance(@NonNull IMutableConfiguration<DeserializationFeature<?>> config) {
        YAMLFactoryBuilder builder = YAMLFactory.builder();
        LoaderOptions loaderOptions = builder.loaderOptions();
        if (loaderOptions == null) {
            loaderOptions = new LoaderOptions();
        }
        int codePointLimit = (Integer)config.get(DeserializationFeature.YAML_CODEPOINT_LIMIT);
        loaderOptions.setCodePointLimit(codePointLimit);
        builder.loaderOptions(loaderOptions);
        YAMLFactory retval = (YAMLFactory)ObjectUtils.notNull((Object)builder.build());
        JsonFactoryFactory.configureJsonFactory((JsonFactory)retval);
        return retval;
    }

    @NonNull
    public static YAMLFactory newGeneratorFactoryInstance(@NonNull IMutableConfiguration<SerializationFeature<?>> config) {
        YAMLFactoryBuilder builder = YAMLFactory.builder();
        YAMLFactory retval = (YAMLFactory)ObjectUtils.notNull((Object)builder.enable(YAMLGenerator.Feature.MINIMIZE_QUOTES).enable(YAMLGenerator.Feature.WRITE_DOC_START_MARKER).enable(YAMLGenerator.Feature.ALWAYS_QUOTE_NUMBERS_AS_STRINGS).disable(YAMLGenerator.Feature.SPLIT_LINES).build());
        JsonFactoryFactory.configureJsonFactory((JsonFactory)retval);
        return retval;
    }
}

