/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.binding.model;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.binding.io.xml.IXmlParsingContext;
import gov.nist.secauto.metaschema.binding.io.xml.IXmlWritingContext;
import gov.nist.secauto.metaschema.binding.model.AbstractNamedModelProperty;
import gov.nist.secauto.metaschema.binding.model.ClassDataTypeHandler;
import gov.nist.secauto.metaschema.binding.model.IAssemblyClassBinding;
import gov.nist.secauto.metaschema.binding.model.IBoundAssemblyInstance;
import gov.nist.secauto.metaschema.binding.model.IClassBinding;
import gov.nist.secauto.metaschema.binding.model.IDataTypeHandler;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import gov.nist.secauto.metaschema.model.common.util.XmlEventUtil;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Locale;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.codehaus.stax2.XMLEventReader2;
import org.codehaus.stax2.XMLStreamWriter2;

abstract class AbstractAssemblyProperty
extends AbstractNamedModelProperty
implements IBoundAssemblyInstance {
    public AbstractAssemblyProperty(@NonNull Field field, @NonNull IAssemblyClassBinding parentClassBinding) {
        super(field, parentClassBinding);
    }

    @Override
    protected IDataTypeHandler newDataTypeHandler() {
        IClassBinding classBinding = ((IAssemblyClassBinding)this.getParentClassBinding()).getBindingContext().getClassBinding(this.getPropertyInfo().getItemType());
        if (classBinding == null) {
            throw new IllegalStateException(String.format("Class '%s' is not bound", this.getPropertyInfo().getItemType().getClass().getName()));
        }
        return new ClassDataTypeHandler(classBinding, this);
    }

    @Override
    public Object readItem(Object parentInstance, StartElement start, IXmlParsingContext context) throws XMLStreamException, IOException {
        XMLEventReader2 eventReader = (XMLEventReader2)context.getReader();
        XmlEventUtil.skipWhitespace((XMLEventReader2)eventReader);
        Object retval = null;
        XMLEvent event = eventReader.peek();
        if (event.isStartElement() && this.getXmlQName().equals(event.asStartElement().getName())) {
            event = eventReader.nextEvent();
            StartElement propertyStartElement = (StartElement)ObjectUtils.notNull((Object)event.asStartElement());
            retval = this.getDataTypeHandler().get(parentInstance, propertyStartElement, context);
            XmlEventUtil.consumeAndAssert((XMLEventReader2)eventReader, (int)2, (QName)propertyStartElement.getName());
        }
        return retval;
    }

    @Override
    public void writeItem(Object item, QName parentName, IXmlWritingContext context) throws XMLStreamException, IOException {
        XMLStreamWriter2 writer = (XMLStreamWriter2)context.getWriter();
        QName currentParentName = this.getXmlQName();
        writer.writeStartElement(currentParentName.getNamespaceURI(), currentParentName.getLocalPart());
        this.getDataTypeHandler().accept(item, currentParentName, context);
        writer.writeEndElement();
    }

    @Override
    public IAssemblyClassBinding getContainingDefinition() {
        return (IAssemblyClassBinding)this.getParentClassBinding();
    }

    public String toCoordinates() {
        return String.format("%s Instance(%s): %s", this.getModelType().name().toLowerCase(Locale.ROOT), ((IAssemblyClassBinding)this.getParentClassBinding()).getBoundClass().getName(), this.getName());
    }
}

