/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.binding.model;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.binding.IBindingContext;
import gov.nist.secauto.metaschema.binding.model.IAssemblyClassBinding;
import gov.nist.secauto.metaschema.binding.model.IFieldClassBinding;
import gov.nist.secauto.metaschema.binding.model.annotations.Metaschema;
import gov.nist.secauto.metaschema.model.common.AbstractMetaschema;
import gov.nist.secauto.metaschema.model.common.IAssemblyDefinition;
import gov.nist.secauto.metaschema.model.common.IFieldDefinition;
import gov.nist.secauto.metaschema.model.common.IFlagDefinition;
import gov.nist.secauto.metaschema.model.common.IMetaschema;
import gov.nist.secauto.metaschema.model.common.INamedModelElement;
import gov.nist.secauto.metaschema.model.common.util.CollectionUtil;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public abstract class AbstractBoundMetaschema
extends AbstractMetaschema {
    @NonNull
    private final IBindingContext bindingContext;
    private Map<String, IAssemblyClassBinding> assemblyDefinitions;
    private Map<String, IFieldClassBinding> fieldDefinitions;

    @NonNull
    public static IMetaschema createInstance(@NonNull Class<? extends IMetaschema> clazz, @NonNull IBindingContext bindingContext) {
        ArrayList<IMetaschema> importedMetaschemas;
        if (!clazz.isAnnotationPresent(Metaschema.class)) {
            throw new IllegalStateException(String.format("The class '%s' is missing the '%s' annotation", clazz.getCanonicalName(), Metaschema.class.getCanonicalName()));
        }
        Metaschema metaschemaAnnotation = clazz.getAnnotation(Metaschema.class);
        if (metaschemaAnnotation.imports().length > 0) {
            importedMetaschemas = new ArrayList<IMetaschema>(metaschemaAnnotation.imports().length);
            for (Class<? extends IMetaschema> importClass : metaschemaAnnotation.imports()) {
                assert (importClass != null);
                IMetaschema metaschemaImport = bindingContext.getMetaschemaInstanceByClass(importClass);
                importedMetaschemas.add(metaschemaImport);
            }
        } else {
            importedMetaschemas = CollectionUtil.emptyList();
        }
        return AbstractBoundMetaschema.createInstance(clazz, bindingContext, (List<? extends IMetaschema>)importedMetaschemas);
    }

    @NonNull
    private static IMetaschema createInstance(@NonNull Class<? extends IMetaschema> clazz, @NonNull IBindingContext bindingContext, @NonNull List<? extends IMetaschema> importedMetaschemas) {
        Constructor<? extends IMetaschema> constructor;
        try {
            constructor = clazz.getDeclaredConstructor(List.class, IBindingContext.class);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalArgumentException(ex);
        }
        try {
            return (IMetaschema)ObjectUtils.notNull((Object)constructor.newInstance(importedMetaschemas, bindingContext));
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    protected AbstractBoundMetaschema(@NonNull List<? extends IMetaschema> importedMetaschema, @NonNull IBindingContext bindingContext) {
        super(importedMetaschema);
        this.bindingContext = bindingContext;
    }

    @NonNull
    protected IBindingContext getBindingContext() {
        return this.bindingContext;
    }

    public URI getLocation() {
        return null;
    }

    @NonNull
    protected Class<?>[] getAssemblyClasses() {
        Class[] retval;
        if (((Object)((Object)this)).getClass().isAnnotationPresent(Metaschema.class)) {
            Metaschema metaschemaAnnotation = ((Object)((Object)this)).getClass().getAnnotation(Metaschema.class);
            retval = metaschemaAnnotation.assemblies();
        } else {
            retval = new Class[]{};
        }
        return retval;
    }

    @NonNull
    protected Class<?>[] getFieldClasses() {
        Class[] retval;
        if (((Object)((Object)this)).getClass().isAnnotationPresent(Metaschema.class)) {
            Metaschema metaschemaAnnotation = ((Object)((Object)this)).getClass().getAnnotation(Metaschema.class);
            retval = metaschemaAnnotation.fields();
        } else {
            retval = new Class[]{};
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initDefinitions() {
        AbstractBoundMetaschema abstractBoundMetaschema = this;
        synchronized (abstractBoundMetaschema) {
            if (this.assemblyDefinitions == null) {
                IBindingContext bindingContext = this.getBindingContext();
                this.assemblyDefinitions = Arrays.stream(this.getAssemblyClasses()).map(clazz -> {
                    assert (clazz != null);
                    return (IAssemblyClassBinding)ObjectUtils.requireNonNull((Object)bindingContext.getClassBinding((Class<?>)clazz));
                }).collect(Collectors.toUnmodifiableMap(INamedModelElement::getName, Function.identity()));
                this.fieldDefinitions = Arrays.stream(this.getFieldClasses()).map(clazz -> {
                    assert (clazz != null);
                    return (IFieldClassBinding)ObjectUtils.requireNonNull((Object)bindingContext.getClassBinding((Class<?>)clazz));
                }).collect(Collectors.toUnmodifiableMap(INamedModelElement::getName, Function.identity()));
            }
        }
    }

    @NonNull
    protected Map<String, ? extends IAssemblyDefinition> getAssemblyDefinitionMap() {
        this.initDefinitions();
        return this.assemblyDefinitions;
    }

    public Collection<? extends IAssemblyDefinition> getAssemblyDefinitions() {
        return this.getAssemblyDefinitionMap().values();
    }

    public IAssemblyDefinition getAssemblyDefinitionByName(@NonNull String name) {
        return this.getAssemblyDefinitionMap().get(name);
    }

    protected Map<String, ? extends IFieldDefinition> getFieldDefinitionMap() {
        this.initDefinitions();
        return this.fieldDefinitions;
    }

    public Collection<? extends IFieldDefinition> getFieldDefinitions() {
        return this.getFieldDefinitionMap().values();
    }

    public IFieldDefinition getFieldDefinitionByName(@NonNull String name) {
        return this.getFieldDefinitionMap().get(name);
    }

    @NonNull
    public Map<String, ? extends IFlagDefinition> getFlagDefinitionMap() {
        return CollectionUtil.emptyMap();
    }

    public Collection<? extends IFlagDefinition> getFlagDefinitions() {
        return Collections.emptyList();
    }

    public IFlagDefinition getFlagDefinitionByName(@NonNull String name) {
        return null;
    }
}

