/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.binding.model;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import gov.nist.secauto.metaschema.binding.IBindingContext;
import gov.nist.secauto.metaschema.binding.io.BindingException;
import gov.nist.secauto.metaschema.binding.io.xml.IXmlParsingContext;
import gov.nist.secauto.metaschema.binding.io.xml.IXmlWritingContext;
import gov.nist.secauto.metaschema.binding.model.ClassIntrospector;
import gov.nist.secauto.metaschema.binding.model.DefaultFlagProperty;
import gov.nist.secauto.metaschema.binding.model.IBoundFlagInstance;
import gov.nist.secauto.metaschema.binding.model.IBoundNamedInstance;
import gov.nist.secauto.metaschema.binding.model.IClassBinding;
import gov.nist.secauto.metaschema.binding.model.annotations.BoundFlag;
import gov.nist.secauto.metaschema.binding.model.annotations.Ignore;
import gov.nist.secauto.metaschema.model.common.IMetaschema;
import gov.nist.secauto.metaschema.model.common.INamedModelElement;
import gov.nist.secauto.metaschema.model.common.ModuleScopeEnum;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import gov.nist.secauto.metaschema.model.common.util.XmlEventUtil;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import org.codehaus.stax2.XMLEventReader2;

abstract class AbstractClassBinding
implements IClassBinding {
    @NonNull
    private final IBindingContext bindingContext;
    @NonNull
    private final Class<?> clazz;
    private final Method beforeDeserializeMethod;
    private final Method afterDeserializeMethod;
    private IMetaschema metaschema;
    private Map<String, IBoundFlagInstance> flagInstances;
    private IBoundFlagInstance jsonKeyFlag;

    public AbstractClassBinding(@NonNull Class<?> clazz, @NonNull IBindingContext bindingContext) {
        this.bindingContext = (IBindingContext)ObjectUtils.requireNonNull((Object)bindingContext, (String)"bindingContext");
        this.clazz = (Class)ObjectUtils.requireNonNull(clazz, (String)"clazz");
        this.beforeDeserializeMethod = ClassIntrospector.getMatchingMethod(clazz, "beforeDeserialize", Object.class);
        this.afterDeserializeMethod = ClassIntrospector.getMatchingMethod(clazz, "afterDeserialize", Object.class);
    }

    public boolean isInline() {
        return this.getBoundClass().getEnclosingClass() != null;
    }

    @Override
    public Class<?> getBoundClass() {
        return this.clazz;
    }

    @Override
    public IBindingContext getBindingContext() {
        return this.bindingContext;
    }

    public String getUseName() {
        return null;
    }

    public String toCoordinates() {
        return String.format("%s IClassBinding(%s): %s", this.getModelType().name().toLowerCase(Locale.ROOT), this.getName(), this.getBoundClass().getName());
    }

    @NonNull
    public ModuleScopeEnum getModuleScope() {
        return ModuleScopeEnum.INHERITED;
    }

    protected abstract Class<? extends IMetaschema> getMetaschemaClass();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    protected IMetaschema initMetaschema() {
        AbstractClassBinding abstractClassBinding = this;
        synchronized (abstractClassBinding) {
            if (this.metaschema == null) {
                Class<? extends IMetaschema> metaschemaClass = this.getMetaschemaClass();
                this.metaschema = this.getBindingContext().getMetaschemaInstanceByClass(metaschemaClass);
            }
            return this.metaschema;
        }
    }

    public IMetaschema getContainingMetaschema() {
        return this.initMetaschema();
    }

    @NonNull
    protected Collection<Field> getFlagInstanceFields(Class<?> clazz) {
        Field[] fields = clazz.getDeclaredFields();
        LinkedList<Field> retval = new LinkedList<Field>();
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null) {
            retval.addAll(this.getFlagInstanceFields(superClass));
        }
        for (Field field : fields) {
            if (!field.isAnnotationPresent(BoundFlag.class) || field.isAnnotationPresent(Ignore.class)) continue;
            retval.add(field);
        }
        return (Collection)ObjectUtils.notNull(Collections.unmodifiableCollection(retval));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    protected Map<String, IBoundFlagInstance> initalizeFlagInstances() {
        AbstractClassBinding abstractClassBinding = this;
        synchronized (abstractClassBinding) {
            if (this.flagInstances == null) {
                LinkedHashMap<String, DefaultFlagProperty> flags = new LinkedHashMap<String, DefaultFlagProperty>();
                for (Field field : this.getFlagInstanceFields(this.clazz)) {
                    if (!field.isAnnotationPresent(BoundFlag.class)) continue;
                    DefaultFlagProperty flagBinding = new DefaultFlagProperty(field, this);
                    this.initializeFlagInstance(flagBinding);
                    flags.put(flagBinding.getEffectiveName(), flagBinding);
                }
                this.flagInstances = flags.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(flags);
            }
            return (Map)ObjectUtils.notNull(this.flagInstances);
        }
    }

    protected void initializeFlagInstance(IBoundFlagInstance instance) {
        if (instance.isJsonKey()) {
            this.jsonKeyFlag = instance;
        }
    }

    @NonNull
    private Map<String, IBoundFlagInstance> getFlagInstanceMap() {
        return this.initalizeFlagInstances();
    }

    @Override
    @Nullable
    public IBoundFlagInstance getFlagInstanceByName(String name) {
        return this.getFlagInstanceMap().get(name);
    }

    @Override
    @NonNull
    public Collection<? extends IBoundFlagInstance> getFlagInstances() {
        return this.getFlagInstanceMap().values();
    }

    public boolean hasJsonKey() {
        return this.getJsonKeyFlagInstance() != null;
    }

    @Override
    public IBoundFlagInstance getJsonKeyFlagInstance() {
        this.initalizeFlagInstances();
        return this.jsonKeyFlag;
    }

    @Override
    public Map<String, ? extends IBoundNamedInstance> getNamedInstances(Predicate<IBoundFlagInstance> filter) {
        Map retval = filter == null ? this.getFlagInstanceMap() : (Map)ObjectUtils.notNull(this.getFlagInstances().stream().filter(filter).collect(Collectors.toMap(INamedModelElement::getJsonName, Function.identity())));
        return retval;
    }

    @NonNull
    protected <CLASS> CLASS newInstance() throws BindingException {
        Class<?> clazz = this.getBoundClass();
        try {
            Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
            return (CLASS)ObjectUtils.notNull(constructor.newInstance(new Object[0]));
        }
        catch (NoSuchMethodException ex) {
            String msg = String.format("Class '%s' does not have a required no-arg constructor.", clazz.getName());
            throw new BindingException(msg, ex);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException ex) {
            throw new BindingException(ex);
        }
    }

    protected void callBeforeDeserialize(Object objectInstance, Object parentInstance) throws BindingException {
        if (this.beforeDeserializeMethod != null) {
            try {
                this.beforeDeserializeMethod.invoke(objectInstance, parentInstance);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                throw new BindingException(ex);
            }
        }
    }

    protected void callAfterDeserialize(Object objectInstance, Object parentInstance) throws BindingException {
        if (this.afterDeserializeMethod != null) {
            try {
                this.afterDeserializeMethod.invoke(objectInstance, parentInstance);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                throw new BindingException(ex);
            }
        }
    }

    @Override
    public Object readItem(Object parentInstance, StartElement start, IXmlParsingContext context) throws IOException, XMLStreamException {
        try {
            Object instance = this.newInstance();
            this.callBeforeDeserialize(instance, parentInstance);
            this.readInternal(instance, start, context);
            this.callAfterDeserialize(instance, parentInstance);
            return instance;
        }
        catch (BindingException ex) {
            throw new IOException(ex);
        }
    }

    protected void readInternal(@NonNull Object instance, @NonNull StartElement start, @NonNull IXmlParsingContext context) throws IOException, XMLStreamException {
        for (IBoundFlagInstance iBoundFlagInstance : this.getFlagInstances()) {
            iBoundFlagInstance.read(instance, start, context);
        }
        this.readBody(instance, start, context);
        XmlEventUtil.skipWhitespace((XMLEventReader2)((XMLEventReader2)context.getReader()));
        XmlEventUtil.assertNext((XMLEventReader2)((XMLEventReader2)context.getReader()), (int)2, (QName)start.getName());
    }

    protected abstract void readBody(@NonNull Object var1, @NonNull StartElement var2, @NonNull IXmlParsingContext var3) throws IOException, XMLStreamException;

    @Override
    public void writeItem(Object instance, QName parentName, IXmlWritingContext context) throws IOException, XMLStreamException {
        this.writeInternal(instance, parentName, context);
    }

    protected void writeInternal(@NonNull Object instance, @NonNull QName parentName, @NonNull IXmlWritingContext context) throws IOException, XMLStreamException {
        for (IBoundFlagInstance iBoundFlagInstance : this.getFlagInstances()) {
            iBoundFlagInstance.write(instance, parentName, context);
        }
        this.writeBody(instance, parentName, context);
    }

    protected abstract void writeBody(@NonNull Object var1, @NonNull QName var2, @NonNull IXmlWritingContext var3) throws XMLStreamException, IOException;

    @Override
    public Object copyBoundObject(Object item, Object parentInstance) throws BindingException {
        Object instance = this.newInstance();
        this.callBeforeDeserialize(instance, parentInstance);
        this.copyBoundObjectInternal(item, instance);
        this.callAfterDeserialize(instance, parentInstance);
        return instance;
    }

    protected void copyBoundObjectInternal(@NonNull Object fromInstance, @NonNull Object toInstance) throws BindingException {
        for (IBoundFlagInstance iBoundFlagInstance : this.getFlagInstances()) {
            iBoundFlagInstance.copyBoundObject(fromInstance, toInstance);
        }
    }
}

