/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.binding.model;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.binding.io.xml.IXmlParsingContext;
import gov.nist.secauto.metaschema.binding.io.xml.IXmlWritingContext;
import gov.nist.secauto.metaschema.binding.model.AbstractNamedModelProperty;
import gov.nist.secauto.metaschema.binding.model.IAssemblyClassBinding;
import gov.nist.secauto.metaschema.binding.model.IBoundFieldInstance;
import gov.nist.secauto.metaschema.binding.model.IDataTypeHandler;
import gov.nist.secauto.metaschema.binding.model.ModelUtil;
import gov.nist.secauto.metaschema.binding.model.annotations.BoundField;
import gov.nist.secauto.metaschema.model.common.datatype.IDataTypeAdapter;
import gov.nist.secauto.metaschema.model.common.datatype.markup.MarkupLine;
import gov.nist.secauto.metaschema.model.common.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import gov.nist.secauto.metaschema.model.common.util.XmlEventUtil;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Locale;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.codehaus.stax2.XMLEventReader2;
import org.codehaus.stax2.XMLStreamWriter2;

public abstract class AbstractFieldProperty
extends AbstractNamedModelProperty
implements IBoundFieldInstance {
    @NonNull
    private final BoundField fieldAnnotation;

    public AbstractFieldProperty(@NonNull Field field, @NonNull IAssemblyClassBinding parentClassBinding) {
        super(field, parentClassBinding);
        BoundField fieldAnnotation = field.getAnnotation(BoundField.class);
        if (fieldAnnotation == null) {
            throw new IllegalStateException(String.format("Field '%s' on class '%s' is missing the '%s' annotation.", field.getName(), parentClassBinding.getBoundClass().getName(), BoundField.class.getName()));
        }
        this.fieldAnnotation = fieldAnnotation;
    }

    @NonNull
    protected BoundField getFieldAnnotation() {
        return this.fieldAnnotation;
    }

    public String getFormalName() {
        return ModelUtil.resolveToString(this.getFieldAnnotation().formalName());
    }

    public MarkupLine getDescription() {
        return ModelUtil.resolveToMarkupLine(this.getFieldAnnotation().description());
    }

    public String getUseName() {
        return ModelUtil.resolveToString(this.getFieldAnnotation().useName());
    }

    public boolean isInXmlWrapped() {
        return this.getFieldAnnotation().inXmlWrapped();
    }

    @Override
    public int getMinOccurs() {
        return this.getFieldAnnotation().minOccurs();
    }

    @Override
    public int getMaxOccurs() {
        return this.getFieldAnnotation().maxOccurs();
    }

    public MarkupMultiline getRemarks() {
        return ModelUtil.resolveToMarkupMultiline(this.getFieldAnnotation().remarks());
    }

    @Override
    public boolean isNextProperty(IXmlParsingContext context) throws XMLStreamException {
        XMLEventReader2 eventReader;
        XMLEvent event;
        boolean retval = super.isNextProperty(context);
        if (!retval && (event = (eventReader = (XMLEventReader2)context.getReader()).peek()).isStartElement()) {
            QName qname = (QName)ObjectUtils.notNull((Object)event.asStartElement().getName());
            IDataTypeAdapter adapter = this.getDefinition().getJavaTypeAdapter();
            retval = !this.isInXmlWrapped() && adapter.isUnrappedValueAllowedInXml() && adapter.canHandleQName(qname);
        }
        return retval;
    }

    @Override
    public Object readItem(Object parentInstance, StartElement start, IXmlParsingContext context) throws XMLStreamException, IOException {
        IDataTypeAdapter adapter = this.getDefinition().getJavaTypeAdapter();
        boolean parseWrapper = true;
        if (!this.isInXmlWrapped() && adapter.isUnrappedValueAllowedInXml()) {
            parseWrapper = false;
        }
        XMLEventReader2 eventReader = (XMLEventReader2)context.getReader();
        StartElement currentStart = start;
        if (parseWrapper) {
            XmlEventUtil.skipWhitespace((XMLEventReader2)eventReader);
            XMLEvent event = eventReader.peek();
            if (event.isStartElement() && this.getXmlQName().equals(event.asStartElement().getName())) {
                currentStart = (StartElement)ObjectUtils.notNull((Object)XmlEventUtil.consumeAndAssert((XMLEventReader2)eventReader, (int)1, (QName)this.getXmlQName()).asStartElement());
            } else {
                throw new IOException(String.format("Did not find expected element '%s'.", this.getXmlQName()));
            }
        }
        IDataTypeHandler supplier = this.getDataTypeHandler();
        Object retval = supplier.get(parentInstance, currentStart, context);
        if (parseWrapper) {
            XmlEventUtil.consumeAndAssert((XMLEventReader2)((XMLEventReader2)context.getReader()), (int)2, (QName)currentStart.getName());
        }
        return retval;
    }

    @Override
    public void writeItem(Object item, QName parentName, IXmlWritingContext context) throws XMLStreamException, IOException {
        QName currentParentName;
        IDataTypeHandler handler = this.getDataTypeHandler();
        boolean writeWrapper = this.isInXmlWrapped() || !handler.isUnwrappedValueAllowedInXml();
        XMLStreamWriter2 writer = (XMLStreamWriter2)context.getWriter();
        if (writeWrapper) {
            currentParentName = this.getXmlQName();
            writer.writeStartElement(currentParentName.getNamespaceURI(), currentParentName.getLocalPart());
        } else {
            currentParentName = parentName;
        }
        handler.accept(item, currentParentName, context);
        if (writeWrapper) {
            writer.writeEndElement();
        }
    }

    @Override
    public IAssemblyClassBinding getContainingDefinition() {
        return (IAssemblyClassBinding)this.getParentClassBinding();
    }

    public String toCoordinates() {
        return String.format("%s Instance(%s): %s", this.getModelType().name().toLowerCase(Locale.ROOT), ((IAssemblyClassBinding)this.getParentClassBinding()).getBoundClass().getName(), this.getName());
    }
}

