/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.binding.model;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.binding.io.json.IJsonParsingContext;
import gov.nist.secauto.metaschema.binding.io.json.IJsonWritingContext;
import gov.nist.secauto.metaschema.binding.io.xml.IXmlParsingContext;
import gov.nist.secauto.metaschema.binding.io.xml.IXmlWritingContext;
import gov.nist.secauto.metaschema.binding.model.AbstractNamedProperty;
import gov.nist.secauto.metaschema.binding.model.IBoundFlagInstance;
import gov.nist.secauto.metaschema.binding.model.IClassBinding;
import gov.nist.secauto.metaschema.binding.model.IPropertyCollector;
import gov.nist.secauto.metaschema.binding.model.SingletonPropertyCollector;
import gov.nist.secauto.metaschema.model.common.datatype.IDataTypeAdapter;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import java.io.IOException;
import java.util.Locale;
import java.util.function.Supplier;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import org.codehaus.stax2.XMLStreamWriter2;

abstract class AbstractFlagProperty
extends AbstractNamedProperty<IClassBinding>
implements IBoundFlagInstance {
    public AbstractFlagProperty(@NonNull IClassBinding parentClassBinding) {
        super(parentClassBinding);
    }

    @Override
    public IPropertyCollector newPropertyCollector() {
        return new SingletonPropertyCollector();
    }

    @Override
    public void copyBoundObject(Object fromInstance, Object toInstance) {
        Object value = this.getValue(fromInstance);
        IDataTypeAdapter adapter = this.getDefinition().getJavaTypeAdapter();
        this.setValue(toInstance, value == null ? null : adapter.copy(value));
    }

    @Override
    public boolean read(Object parentInstance, StartElement parent, IXmlParsingContext context) throws IOException {
        boolean handled = false;
        Attribute attribute = parent.getAttributeByName(this.getXmlQName());
        if (attribute != null) {
            Object value = this.getDefinition().getJavaTypeAdapter().parse((String)ObjectUtils.notNull((Object)attribute.getValue()));
            this.setValue(parentInstance, value);
            handled = true;
        }
        return handled;
    }

    @Override
    protected Object readInternal(Object parentInstance, IJsonParsingContext context) throws IOException {
        JsonParser parser = (JsonParser)context.getReader();
        parser.nextFieldName();
        return this.readValueAndSupply(context).get();
    }

    @Override
    public Object readValueFromString(String value) throws IOException {
        return this.getDefinition().getJavaTypeAdapter().parse(value);
    }

    @Override
    public Supplier<?> readValueAndSupply(String value) throws IOException {
        return this.getDefinition().getJavaTypeAdapter().parseAndSupply(value);
    }

    @Override
    public Supplier<?> readValueAndSupply(IJsonParsingContext context) throws IOException {
        return this.getDefinition().getJavaTypeAdapter().parseAndSupply((JsonParser)context.getReader());
    }

    @Override
    public boolean write(Object instance, QName parentName, IXmlWritingContext context) throws XMLStreamException, IOException {
        String value;
        Object objectValue = this.getValue(instance);
        String string = value = objectValue == null ? null : this.getDefinition().getJavaTypeAdapter().asString(objectValue);
        if (value != null) {
            QName name = this.getXmlQName();
            XMLStreamWriter2 writer = (XMLStreamWriter2)context.getWriter();
            if (name.getNamespaceURI().isEmpty()) {
                writer.writeAttribute(name.getLocalPart(), value);
            } else {
                writer.writeAttribute(name.getNamespaceURI(), name.getLocalPart(), value);
            }
        }
        return true;
    }

    @Override
    public void write(Object instance, IJsonWritingContext context) throws IOException {
        JsonGenerator writer = (JsonGenerator)context.getWriter();
        Object value = this.getValue(instance);
        if (value != null) {
            writer.writeFieldName(this.getJsonName());
            this.writeValue(value, context);
        }
    }

    @Override
    public String getValueAsString(Object value) {
        return value == null ? null : this.getDefinition().getJavaTypeAdapter().asString(value);
    }

    @Override
    public void writeValue(@NonNull Object value, IJsonWritingContext context) throws IOException {
        this.getDefinition().getJavaTypeAdapter().writeJsonValue(value, (JsonGenerator)context.getWriter());
    }

    public String toCoordinates() {
        return String.format("%s Instance(%s): %s", this.getModelType().name().toLowerCase(Locale.ROOT), this.getParentClassBinding().getBoundClass().getName(), this.getName());
    }
}

