/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.binding.model;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import gov.nist.secauto.metaschema.binding.io.BindingException;
import gov.nist.secauto.metaschema.binding.io.json.IJsonParsingContext;
import gov.nist.secauto.metaschema.binding.io.json.IJsonWritingContext;
import gov.nist.secauto.metaschema.binding.io.json.JsonUtil;
import gov.nist.secauto.metaschema.binding.io.xml.IXmlParsingContext;
import gov.nist.secauto.metaschema.binding.io.xml.IXmlWritingContext;
import gov.nist.secauto.metaschema.binding.model.AbstractNamedProperty;
import gov.nist.secauto.metaschema.binding.model.IAssemblyClassBinding;
import gov.nist.secauto.metaschema.binding.model.IBoundNamedModelInstance;
import gov.nist.secauto.metaschema.binding.model.IClassBinding;
import gov.nist.secauto.metaschema.binding.model.IDataTypeHandler;
import gov.nist.secauto.metaschema.binding.model.IModelPropertyInfo;
import gov.nist.secauto.metaschema.binding.model.IPropertyCollector;
import gov.nist.secauto.metaschema.binding.model.ModelUtil;
import gov.nist.secauto.metaschema.binding.model.annotations.GroupAs;
import gov.nist.secauto.metaschema.model.common.JsonGroupAsBehavior;
import gov.nist.secauto.metaschema.model.common.XmlGroupAsBehavior;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import gov.nist.secauto.metaschema.model.common.util.XmlEventUtil;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import nl.talsmasoftware.lazy4j.Lazy;
import org.codehaus.stax2.XMLEventReader2;
import org.codehaus.stax2.XMLStreamWriter2;

abstract class AbstractNamedModelProperty
extends AbstractNamedProperty<IAssemblyClassBinding>
implements IBoundNamedModelInstance {
    @NonNull
    private static final IGroupAs SINGLETON_GROUP_AS = new IGroupAs(){

        @Override
        public String getGroupAsName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getGroupAsXmlNamespace() {
            throw new UnsupportedOperationException();
        }

        @Override
        public JsonGroupAsBehavior getJsonGroupAsBehavior() {
            return JsonGroupAsBehavior.NONE;
        }

        @Override
        public XmlGroupAsBehavior getXmlGroupAsBehavior() {
            return XmlGroupAsBehavior.UNGROUPED;
        }
    };
    @NonNull
    private final Field field;
    @NonNull
    private final IGroupAs groupAs;
    private IModelPropertyInfo propertyInfo;
    private IDataTypeHandler dataTypeHandler;

    protected AbstractNamedModelProperty(@NonNull Field field, @NonNull IAssemblyClassBinding parentClassBinding) {
        super(parentClassBinding);
        this.field = (Field)ObjectUtils.requireNonNull((Object)field, (String)"field");
        GroupAs annotation = field.getAnnotation(GroupAs.class);
        this.groupAs = annotation == null ? SINGLETON_GROUP_AS : new SimpleGroupAs(annotation, parentClassBinding);
    }

    @Override
    public Field getField() {
        return this.field;
    }

    public abstract int getMinOccurs();

    public abstract int getMaxOccurs();

    public String getGroupAsName() {
        return this.groupAs.getGroupAsName();
    }

    public String getGroupAsXmlNamespace() {
        return this.groupAs.getGroupAsXmlNamespace();
    }

    public JsonGroupAsBehavior getJsonGroupAsBehavior() {
        return this.groupAs.getJsonGroupAsBehavior();
    }

    public XmlGroupAsBehavior getXmlGroupAsBehavior() {
        return this.groupAs.getXmlGroupAsBehavior();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public IModelPropertyInfo getPropertyInfo() {
        AbstractNamedModelProperty abstractNamedModelProperty = this;
        synchronized (abstractNamedModelProperty) {
            if (this.propertyInfo == null) {
                this.propertyInfo = this.newPropertyInfo();
            }
            return this.propertyInfo;
        }
    }

    @Override
    public Collection<? extends Object> getItemValues(Object value) {
        return this.getPropertyInfo().getItemsFromValue(value);
    }

    protected abstract IDataTypeHandler newDataTypeHandler();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IDataTypeHandler getDataTypeHandler() {
        AbstractNamedModelProperty abstractNamedModelProperty = this;
        synchronized (abstractNamedModelProperty) {
            if (this.dataTypeHandler == null) {
                this.dataTypeHandler = this.newDataTypeHandler();
            }
            return (IDataTypeHandler)ObjectUtils.notNull((Object)this.dataTypeHandler);
        }
    }

    public boolean isNextProperty(@NonNull IXmlParsingContext context) throws XMLStreamException {
        XMLEvent event;
        XMLEventReader2 eventReader = (XMLEventReader2)context.getReader();
        XmlEventUtil.skipWhitespace((XMLEventReader2)eventReader);
        boolean handled = false;
        QName groupQName = this.getXmlGroupAsQName();
        if (groupQName != null && (event = eventReader.peek()).isStartElement() && groupQName.equals(event.asStartElement().getName())) {
            handled = true;
        }
        if (!handled) {
            event = eventReader.peek();
            QName xmlQName = this.getXmlQName();
            if (xmlQName != null && event.isStartElement() && xmlQName.equals(event.asStartElement().getName())) {
                handled = true;
            }
        }
        return handled;
    }

    @Override
    public boolean read(Object parentInstance, StartElement start, IXmlParsingContext context) throws IOException, XMLStreamException {
        boolean handled = this.isNextProperty(context);
        if (handled) {
            Object value = this.readInternal(parentInstance, start, context);
            this.setValue(parentInstance, value);
        }
        return handled;
    }

    @Override
    protected Object readInternal(Object parentInstance, IJsonParsingContext context) throws IOException {
        JsonParser parser = (JsonParser)context.getReader();
        JsonUtil.assertAndAdvance(parser, JsonToken.FIELD_NAME);
        IPropertyCollector collector = this.newPropertyCollector();
        IModelPropertyInfo info = this.getPropertyInfo();
        info.readValue(collector, parentInstance, context);
        JsonUtil.assertCurrent((JsonParser)context.getReader(), JsonToken.FIELD_NAME, JsonToken.END_OBJECT);
        return collector.getValue();
    }

    protected Object readInternal(@Nullable Object parentInstance, @NonNull StartElement start, @NonNull IXmlParsingContext context) throws IOException, XMLStreamException {
        XMLEventReader2 eventReader = (XMLEventReader2)context.getReader();
        XmlEventUtil.skipWhitespace((XMLEventReader2)eventReader);
        StartElement currentStart = start;
        QName groupQName = this.getXmlGroupAsQName();
        if (groupQName != null) {
            XMLEvent groupEvent = XmlEventUtil.consumeAndAssert((XMLEventReader2)eventReader, (int)1, (QName)groupQName);
            currentStart = (StartElement)ObjectUtils.notNull((Object)groupEvent.asStartElement());
        }
        IPropertyCollector collector = this.newPropertyCollector();
        this.getPropertyInfo().readValue(collector, parentInstance, currentStart, context);
        Object value = collector.getValue();
        XmlEventUtil.skipWhitespace((XMLEventReader2)eventReader);
        if (groupQName != null) {
            XmlEventUtil.consumeAndAssert((XMLEventReader2)eventReader, (int)2, (QName)groupQName);
        }
        return value;
    }

    @Override
    public IPropertyCollector newPropertyCollector() {
        return this.getPropertyInfo().newPropertyCollector();
    }

    @Override
    public List<Object> readItem(Object parentInstance, boolean requiresJsonKey, IJsonParsingContext context) throws IOException {
        IDataTypeHandler supplier = this.getDataTypeHandler();
        return supplier.get(parentInstance, requiresJsonKey, context);
    }

    @Override
    public boolean write(Object parentInstance, QName parentName, IXmlWritingContext context) throws XMLStreamException, IOException {
        Object value = this.getValue(parentInstance);
        if (value == null) {
            return false;
        }
        IModelPropertyInfo propertyInfo = this.getPropertyInfo();
        if (propertyInfo.getProperty().getMinOccurs() > 0 || propertyInfo.getItemCount(value) > 0) {
            QName currentStart = parentName;
            XMLStreamWriter2 writer = (XMLStreamWriter2)context.getWriter();
            QName groupQName = this.getXmlGroupAsQName();
            if (groupQName != null) {
                writer.writeStartElement(groupQName.getNamespaceURI(), groupQName.getLocalPart());
                currentStart = groupQName;
            }
            propertyInfo.writeValue(value, currentStart, context);
            if (groupQName != null) {
                writer.writeEndElement();
            }
        }
        return true;
    }

    @Override
    public void write(Object parentInstance, IJsonWritingContext context) throws IOException {
        if (this.getPropertyInfo().isValueSet(parentInstance)) {
            ((JsonGenerator)context.getWriter()).writeFieldName(this.getJsonName());
            this.getPropertyInfo().writeValue(parentInstance, context);
        }
    }

    @Override
    public void copyBoundObject(@NonNull Object fromInstance, @NonNull Object toInstance) throws BindingException {
        Object value = this.getValue(fromInstance);
        if (value != null) {
            IModelPropertyInfo propertyInfo = this.getPropertyInfo();
            IPropertyCollector collector = this.newPropertyCollector();
            propertyInfo.copy(fromInstance, toInstance, collector);
            value = collector.getValue();
        }
        this.setValue(toInstance, value);
    }

    @Override
    public Object copyItem(Object fromItem, Object toInstance) throws BindingException {
        return this.getDataTypeHandler().copyItem(fromItem, toInstance);
    }

    private static final class SimpleGroupAs
    implements IGroupAs {
        @NonNull
        private final String name;
        @NonNull
        private final Lazy<String> namespace;
        @NonNull
        private final GroupAs annotation;

        private SimpleGroupAs(@NonNull GroupAs annotation, @NonNull IClassBinding parentDefinition) {
            this.annotation = annotation;
            String value = ModelUtil.resolveLocalName(annotation.name(), null);
            if (value == null) {
                throw new IllegalStateException(String.format("The %s#groupName value '%s' resulted in an invalid null value", GroupAs.class.getName(), annotation.name()));
            }
            this.name = value;
            this.namespace = (Lazy)ObjectUtils.notNull((Object)Lazy.lazy(() -> ModelUtil.resolveNamespace(annotation.namespace(), parentDefinition)));
        }

        @Override
        public String getGroupAsName() {
            return this.name;
        }

        @Override
        public String getGroupAsXmlNamespace() {
            return (String)this.namespace.get();
        }

        @Override
        public JsonGroupAsBehavior getJsonGroupAsBehavior() {
            return this.annotation.inJson();
        }

        @Override
        public XmlGroupAsBehavior getXmlGroupAsBehavior() {
            return this.annotation.inXml();
        }
    }

    private static interface IGroupAs {
        @NonNull
        public String getGroupAsName();

        @Nullable
        public String getGroupAsXmlNamespace();

        @NonNull
        public JsonGroupAsBehavior getJsonGroupAsBehavior();

        @NonNull
        public XmlGroupAsBehavior getXmlGroupAsBehavior();
    }
}

