/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.binding.model;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.binding.io.json.IJsonParsingContext;
import gov.nist.secauto.metaschema.binding.io.json.JsonUtil;
import gov.nist.secauto.metaschema.binding.model.AbstractProperty;
import gov.nist.secauto.metaschema.binding.model.IClassBinding;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

abstract class AbstractNamedProperty<CLASS_BINDING extends IClassBinding>
extends AbstractProperty<CLASS_BINDING> {
    private static final Logger LOGGER = LogManager.getLogger(AbstractNamedProperty.class);

    public AbstractNamedProperty(@NonNull CLASS_BINDING parentClassBinding) {
        super(parentClassBinding);
    }

    public boolean isNextProperty(IJsonParsingContext context) throws IOException {
        JsonParser parser = (JsonParser)context.getReader();
        JsonUtil.assertCurrent(parser, JsonToken.FIELD_NAME);
        String propertyName = parser.currentName();
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("reading property {}", (Object)propertyName);
        }
        return this.getJsonName().equals(propertyName);
    }

    @Override
    public Object read(IJsonParsingContext context) throws IOException {
        Object retval = null;
        if (this.isNextProperty(context)) {
            retval = this.readInternal(null, context);
        }
        return retval;
    }

    @Override
    public boolean read(Object objectInstance, IJsonParsingContext context) throws IOException {
        JsonParser parser = (JsonParser)context.getReader();
        JsonUtil.assertCurrent(parser, JsonToken.FIELD_NAME);
        boolean handled = this.isNextProperty(context);
        if (handled) {
            Object value = this.readInternal(objectInstance, context);
            this.setValue(objectInstance, value);
        }
        JsonUtil.assertCurrent(parser, JsonToken.FIELD_NAME, JsonToken.END_OBJECT);
        return handled;
    }

    protected abstract Object readInternal(Object var1, IJsonParsingContext var2) throws IOException;
}

