/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.binding.model;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.binding.model.AbstractFieldProperty;
import gov.nist.secauto.metaschema.binding.model.ClassDataTypeHandler;
import gov.nist.secauto.metaschema.binding.model.IAssemblyClassBinding;
import gov.nist.secauto.metaschema.binding.model.IDataTypeHandler;
import gov.nist.secauto.metaschema.binding.model.IFieldClassBinding;
import java.lang.reflect.Field;

class ClassBindingFieldProperty
extends AbstractFieldProperty {
    @NonNull
    private final IFieldClassBinding definition;

    public ClassBindingFieldProperty(@NonNull Field field, @NonNull IFieldClassBinding definition, @NonNull IAssemblyClassBinding parentClassBinding) {
        super(field, parentClassBinding);
        this.definition = definition;
        if (!this.isInXmlWrapped()) {
            if (!this.isSimple()) {
                throw new IllegalStateException(String.format("Field '%s' on class '%s' is requested to be unwrapped, but it has flags preventing this.", field.getName(), parentClassBinding.getBoundClass().getName()));
            }
            if (!this.getDefinition().getJavaTypeAdapter().isUnrappedValueAllowedInXml()) {
                throw new IllegalStateException(String.format("Field '%s' on class '%s' is requested to be unwrapped, but its data type '%s' does not allow this.", field.getName(), parentClassBinding.getBoundClass().getName(), this.getDefinition().getJavaTypeAdapter().getPreferredName()));
            }
        }
    }

    @Override
    public final IFieldClassBinding getDefinition() {
        return this.definition;
    }

    @Override
    protected IDataTypeHandler newDataTypeHandler() {
        return new ClassDataTypeHandler(this.getDefinition(), this);
    }

    public final boolean isSimple() {
        return this.getDefinition().isSimple();
    }
}

