/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.binding.model;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.binding.io.BindingException;
import gov.nist.secauto.metaschema.binding.io.json.IJsonParsingContext;
import gov.nist.secauto.metaschema.binding.io.json.IJsonWritingContext;
import gov.nist.secauto.metaschema.binding.io.json.JsonUtil;
import gov.nist.secauto.metaschema.binding.io.xml.IXmlParsingContext;
import gov.nist.secauto.metaschema.binding.io.xml.IXmlWritingContext;
import gov.nist.secauto.metaschema.binding.model.IBoundNamedModelInstance;
import gov.nist.secauto.metaschema.binding.model.IClassBinding;
import gov.nist.secauto.metaschema.binding.model.IDataTypeHandler;
import gov.nist.secauto.metaschema.model.common.datatype.IDataTypeAdapter;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;

class ClassDataTypeHandler
implements IDataTypeHandler {
    @NonNull
    private final IBoundNamedModelInstance property;
    @NonNull
    private final IClassBinding classBinding;

    public ClassDataTypeHandler(@NonNull IClassBinding classBinding, @NonNull IBoundNamedModelInstance property) {
        this.classBinding = (IClassBinding)ObjectUtils.requireNonNull((Object)classBinding, (String)"classBinding");
        this.property = (IBoundNamedModelInstance)ObjectUtils.requireNonNull((Object)property, (String)"property");
    }

    @Override
    public IBoundNamedModelInstance getProperty() {
        return this.property;
    }

    @Override
    public IDataTypeAdapter<?> getJavaTypeAdapter() {
        return null;
    }

    @Override
    public IClassBinding getClassBinding() {
        return this.classBinding;
    }

    @Override
    public boolean isUnwrappedValueAllowedInXml() {
        return false;
    }

    @Override
    public List<Object> get(Object parentInstance, boolean requiresJsonKey, IJsonParsingContext context) throws IOException {
        JsonParser parser = (JsonParser)context.getReader();
        boolean objectWrapper = JsonToken.START_OBJECT.equals((Object)parser.currentToken());
        if (objectWrapper) {
            JsonUtil.assertAndAdvance(parser, JsonToken.START_OBJECT);
        }
        List<Object> retval = this.classBinding.readItem(parentInstance, requiresJsonKey, context);
        if (objectWrapper) {
            JsonUtil.assertAndAdvance(parser, JsonToken.END_OBJECT);
        }
        return retval;
    }

    @Override
    public Object get(Object parentInstance, StartElement start, IXmlParsingContext context) throws IOException, XMLStreamException {
        return this.classBinding.readItem(parentInstance, start, context);
    }

    @Override
    public void accept(Object item, QName currentParentName, IXmlWritingContext context) throws IOException, XMLStreamException {
        this.classBinding.writeItem(item, currentParentName, context);
    }

    @Override
    public void writeItems(Collection<? extends Object> items, boolean writeObjectWrapper, IJsonWritingContext context) throws IOException {
        this.classBinding.writeItems(items, writeObjectWrapper, context);
    }

    @Override
    public Object copyItem(@NonNull Object fromItem, Object parentInstance) throws BindingException {
        return this.classBinding.copyBoundObject(fromItem, parentInstance);
    }
}

