/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.binding.model;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import gov.nist.secauto.metaschema.binding.model.annotations.AllowedValue;
import gov.nist.secauto.metaschema.binding.model.annotations.AllowedValues;
import gov.nist.secauto.metaschema.binding.model.annotations.Expect;
import gov.nist.secauto.metaschema.binding.model.annotations.HasCardinality;
import gov.nist.secauto.metaschema.binding.model.annotations.Index;
import gov.nist.secauto.metaschema.binding.model.annotations.IndexHasKey;
import gov.nist.secauto.metaschema.binding.model.annotations.IsUnique;
import gov.nist.secauto.metaschema.binding.model.annotations.KeyField;
import gov.nist.secauto.metaschema.binding.model.annotations.Matches;
import gov.nist.secauto.metaschema.binding.model.annotations.NullJavaTypeAdapter;
import gov.nist.secauto.metaschema.binding.model.annotations.Property;
import gov.nist.secauto.metaschema.model.common.constraint.AbstractConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.AbstractKeyConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.DefaultAllowedValue;
import gov.nist.secauto.metaschema.model.common.constraint.DefaultAllowedValuesConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.DefaultCardinalityConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.DefaultExpectConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.DefaultIndexConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.DefaultIndexHasKeyConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.DefaultKeyField;
import gov.nist.secauto.metaschema.model.common.constraint.DefaultMatchesConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.DefaultUniqueConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.IConstraint;
import gov.nist.secauto.metaschema.model.common.datatype.DataTypeService;
import gov.nist.secauto.metaschema.model.common.datatype.IDataTypeAdapter;
import gov.nist.secauto.metaschema.model.common.datatype.markup.MarkupLine;
import gov.nist.secauto.metaschema.model.common.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.model.common.metapath.MetapathExpression;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;

final class ConstraintFactory {
    private ConstraintFactory() {
    }

    static MarkupMultiline toRemarks(@NonNull String remarks) {
        return remarks.isBlank() ? null : MarkupMultiline.fromMarkdown((String)remarks);
    }

    @NonNull
    static MetapathExpression toMetapath(@NonNull String metapath) {
        return metapath.isBlank() ? IConstraint.DEFAULT_TARGET : MetapathExpression.compile((String)metapath);
    }

    @NonNull
    static <T extends AbstractConstraint.AbstractConstraintBuilder<T, ?>> T applyId(@NonNull T builder, @NonNull String id) {
        if (!id.isBlank()) {
            builder.identifier(id);
        }
        return builder;
    }

    @NonNull
    static <T extends AbstractConstraint.AbstractConstraintBuilder<T, ?>> T applyFormalName(@NonNull T builder, @NonNull String name) {
        if (!name.isBlank()) {
            builder.formalName(name);
        }
        return builder;
    }

    @NonNull
    static <T extends AbstractConstraint.AbstractConstraintBuilder<T, ?>> T applyDescription(@NonNull T builder, @NonNull String value) {
        if (!value.isBlank()) {
            builder.description(MarkupLine.fromMarkdown((String)value));
        }
        return builder;
    }

    @NonNull
    static <T extends AbstractConstraint.AbstractConstraintBuilder<T, ?>> T applyTarget(@NonNull T builder, @NonNull String target) {
        builder.target(ConstraintFactory.toMetapath(target));
        return builder;
    }

    @NonNull
    static <T extends AbstractConstraint.AbstractConstraintBuilder<T, ?>> T applyProperties(@NonNull T builder, Property ... properties) {
        if (properties != null) {
            for (Property property : properties) {
                String name = property.name();
                String namespace = property.namespace();
                QName qname = new QName(namespace, name);
                String[] values = property.values();
                List<String> valueList = Arrays.asList(values);
                LinkedHashSet<String> valueSet = new LinkedHashSet<String>(valueList);
                builder.property(qname, valueSet);
            }
        }
        return builder;
    }

    static <T extends AbstractConstraint.AbstractConstraintBuilder<T, ?>> T applyRemarks(@NonNull T builder, @NonNull String remarks) {
        if (!remarks.isBlank()) {
            builder.remarks(MarkupMultiline.fromMarkdown((String)remarks));
        }
        return builder;
    }

    @NonNull
    static DefaultAllowedValuesConstraint.Builder applyAllowedValues(@NonNull DefaultAllowedValuesConstraint.Builder builder, @NonNull AllowedValues constraint) {
        for (AllowedValue value : constraint.values()) {
            DefaultAllowedValue allowedValue = new DefaultAllowedValue(value.value(), MarkupLine.fromMarkdown((String)value.description()));
            builder.allowedValue(allowedValue);
        }
        return builder;
    }

    @Nullable
    static Pattern toPattern(@NonNull String pattern) {
        return pattern.isBlank() ? null : Pattern.compile(pattern);
    }

    @Nullable
    static String toMessage(@NonNull String message) {
        return message.isBlank() ? null : message;
    }

    @Nullable
    static IDataTypeAdapter<?> toDataType(@NonNull Class<? extends IDataTypeAdapter<?>> adapterClass) {
        return adapterClass.isAssignableFrom(NullJavaTypeAdapter.class) ? null : DataTypeService.getInstance().getJavaTypeAdapterByClass(adapterClass);
    }

    @NonNull
    static DefaultAllowedValuesConstraint newAllowedValuesConstraint(@NonNull AllowedValues constraint, @NonNull IConstraint.ISource source) {
        DefaultAllowedValuesConstraint.Builder builder = DefaultAllowedValuesConstraint.builder();
        ConstraintFactory.applyId(builder, constraint.id());
        ConstraintFactory.applyFormalName(builder, constraint.formalName());
        ConstraintFactory.applyDescription(builder, constraint.description());
        ((DefaultAllowedValuesConstraint.Builder)builder.source(source)).level(constraint.level());
        ConstraintFactory.applyTarget(builder, constraint.target());
        ConstraintFactory.applyProperties(builder, constraint.properties());
        ConstraintFactory.applyRemarks(builder, constraint.remarks());
        ConstraintFactory.applyAllowedValues(builder, constraint);
        builder.allowedOther(constraint.allowOthers());
        builder.extensible(constraint.extensible());
        return (DefaultAllowedValuesConstraint)builder.build();
    }

    @NonNull
    static DefaultMatchesConstraint newMatchesConstraint(Matches constraint, @NonNull IConstraint.ISource source) {
        IDataTypeAdapter<?> dataType;
        DefaultMatchesConstraint.Builder builder = DefaultMatchesConstraint.builder();
        ConstraintFactory.applyId(builder, constraint.id());
        ConstraintFactory.applyFormalName(builder, constraint.formalName());
        ConstraintFactory.applyDescription(builder, constraint.description());
        ((DefaultMatchesConstraint.Builder)builder.source(source)).level(constraint.level());
        ConstraintFactory.applyTarget(builder, constraint.target());
        ConstraintFactory.applyProperties(builder, constraint.properties());
        ConstraintFactory.applyRemarks(builder, constraint.remarks());
        Pattern pattern = ConstraintFactory.toPattern(constraint.pattern());
        if (pattern != null) {
            builder.regex(pattern);
        }
        if ((dataType = ConstraintFactory.toDataType(constraint.typeAdapter())) != null) {
            builder.datatype(dataType);
        }
        return (DefaultMatchesConstraint)builder.build();
    }

    @NonNull
    static <T extends AbstractKeyConstraint.AbstractKeyConstraintBuilder<T, ?>> T applyKeyFields(@NonNull T builder, KeyField ... keyFields) {
        for (KeyField keyField : keyFields) {
            DefaultKeyField field = new DefaultKeyField(ConstraintFactory.toMetapath(keyField.target()), ConstraintFactory.toPattern(keyField.pattern()), ConstraintFactory.toRemarks(keyField.remarks()));
            builder.keyField(field);
        }
        return builder;
    }

    @NonNull
    static DefaultUniqueConstraint newUniqueConstraint(@NonNull IsUnique constraint, @NonNull IConstraint.ISource source) {
        DefaultUniqueConstraint.Builder builder = DefaultUniqueConstraint.builder();
        ConstraintFactory.applyId(builder, constraint.id());
        ConstraintFactory.applyFormalName(builder, constraint.formalName());
        ConstraintFactory.applyDescription(builder, constraint.description());
        ((DefaultUniqueConstraint.Builder)builder.source(source)).level(constraint.level());
        ConstraintFactory.applyTarget(builder, constraint.target());
        ConstraintFactory.applyProperties(builder, constraint.properties());
        ConstraintFactory.applyRemarks(builder, constraint.remarks());
        ConstraintFactory.applyKeyFields(builder, constraint.keyFields());
        return (DefaultUniqueConstraint)builder.build();
    }

    @NonNull
    static DefaultIndexConstraint newIndexConstraint(@NonNull Index constraint, @NonNull IConstraint.ISource source) {
        DefaultIndexConstraint.Builder builder = DefaultIndexConstraint.builder();
        ConstraintFactory.applyId(builder, constraint.id());
        ConstraintFactory.applyFormalName(builder, constraint.formalName());
        ConstraintFactory.applyDescription(builder, constraint.description());
        ((DefaultIndexConstraint.Builder)builder.source(source)).level(constraint.level());
        ConstraintFactory.applyTarget(builder, constraint.target());
        ConstraintFactory.applyProperties(builder, constraint.properties());
        ConstraintFactory.applyRemarks(builder, constraint.remarks());
        builder.name(constraint.name());
        ConstraintFactory.applyKeyFields(builder, constraint.keyFields());
        return (DefaultIndexConstraint)builder.build();
    }

    @NonNull
    static DefaultIndexHasKeyConstraint newIndexHasKeyConstraint(@NonNull IndexHasKey constraint, @NonNull IConstraint.ISource source) {
        DefaultIndexHasKeyConstraint.Builder builder = DefaultIndexHasKeyConstraint.builder();
        ConstraintFactory.applyId(builder, constraint.id());
        ConstraintFactory.applyFormalName(builder, constraint.formalName());
        ConstraintFactory.applyDescription(builder, constraint.description());
        ((DefaultIndexHasKeyConstraint.Builder)builder.source(source)).level(constraint.level());
        ConstraintFactory.applyTarget(builder, constraint.target());
        ConstraintFactory.applyProperties(builder, constraint.properties());
        ConstraintFactory.applyRemarks(builder, constraint.remarks());
        builder.name(constraint.indexName());
        ConstraintFactory.applyKeyFields(builder, constraint.keyFields());
        return (DefaultIndexHasKeyConstraint)builder.build();
    }

    @NonNull
    static DefaultExpectConstraint newExpectConstraint(@NonNull Expect constraint, @NonNull IConstraint.ISource source) {
        DefaultExpectConstraint.Builder builder = DefaultExpectConstraint.builder();
        ConstraintFactory.applyId(builder, constraint.id());
        ConstraintFactory.applyFormalName(builder, constraint.formalName());
        ConstraintFactory.applyDescription(builder, constraint.description());
        ((DefaultExpectConstraint.Builder)builder.source(source)).level(constraint.level());
        ConstraintFactory.applyTarget(builder, constraint.target());
        ConstraintFactory.applyProperties(builder, constraint.properties());
        ConstraintFactory.applyRemarks(builder, constraint.remarks());
        builder.test(ConstraintFactory.toMetapath(constraint.test()));
        String message = constraint.message();
        if (!message.isBlank()) {
            builder.message(message);
        }
        return (DefaultExpectConstraint)builder.build();
    }

    @Nullable
    static Integer toCardinality(int value) {
        return value < 0 ? null : Integer.valueOf(value);
    }

    @NonNull
    static DefaultCardinalityConstraint newCardinalityConstraint(@NonNull HasCardinality constraint, @NonNull IConstraint.ISource source) {
        Integer max;
        DefaultCardinalityConstraint.Builder builder = DefaultCardinalityConstraint.builder();
        ConstraintFactory.applyId(builder, constraint.id());
        ConstraintFactory.applyFormalName(builder, constraint.formalName());
        ConstraintFactory.applyDescription(builder, constraint.description());
        ((DefaultCardinalityConstraint.Builder)builder.source(source)).level(constraint.level());
        ConstraintFactory.applyTarget(builder, constraint.target());
        ConstraintFactory.applyProperties(builder, constraint.properties());
        ConstraintFactory.applyRemarks(builder, constraint.remarks());
        Integer min = ConstraintFactory.toCardinality(constraint.minOccurs());
        if (min != null) {
            builder.minOccurs(min.intValue());
        }
        if ((max = ConstraintFactory.toCardinality(constraint.maxOccurs())) != null) {
            builder.maxOccurs(max.intValue());
        }
        return (DefaultCardinalityConstraint)builder.build();
    }
}

